/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.widgets.grid;

import com.ait.lienzo.client.core.shape.Group;
import com.ait.lienzo.client.core.types.Point2D;
import com.ait.lienzo.test.LienzoMockitoTestRunner;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.enterprise.event.Event;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.HasExpression;
import org.kie.workbench.common.dmn.api.definition.NOPDomainObject;
import org.kie.workbench.common.dmn.api.definition.model.Decision;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.dmn.api.property.dmn.QName;
import org.kie.workbench.common.dmn.client.commands.factory.canvas.SetComponentWidthCommand;
import org.kie.workbench.common.dmn.client.commands.general.DeleteCellValueCommand;
import org.kie.workbench.common.dmn.client.commands.general.DeleteHasValueCommand;
import org.kie.workbench.common.dmn.client.commands.general.DeleteHeaderValueCommand;
import org.kie.workbench.common.dmn.client.commands.general.SetCellValueCommand;
import org.kie.workbench.common.dmn.client.commands.general.SetHasValueCommand;
import org.kie.workbench.common.dmn.client.commands.general.SetHeaderValueCommand;
import org.kie.workbench.common.dmn.client.commands.general.SetTypeRefCommand;
import org.kie.workbench.common.dmn.client.editors.expressions.types.GridFactoryCommandUtils;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.ExpressionCellValue;
import org.kie.workbench.common.dmn.client.widgets.grid.BaseExpressionGrid;
import org.kie.workbench.common.dmn.client.widgets.grid.BaseExpressionGridTest;
import org.kie.workbench.common.dmn.client.widgets.grid.BaseGrid;
import org.kie.workbench.common.dmn.client.widgets.grid.columns.EditableHeaderMetaData;
import org.kie.workbench.common.dmn.client.widgets.grid.columns.factory.ListBoxSingletonDOMElementFactory;
import org.kie.workbench.common.dmn.client.widgets.grid.columns.factory.TextAreaSingletonDOMElementFactory;
import org.kie.workbench.common.dmn.client.widgets.grid.columns.factory.TextBoxSingletonDOMElementFactory;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.HasCellEditorControls;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.container.CellEditorControlsView;
import org.kie.workbench.common.dmn.client.widgets.grid.handlers.EditableHeaderGridWidgetEditCellMouseEventHandler;
import org.kie.workbench.common.dmn.client.widgets.grid.model.BaseUIModelMapper;
import org.kie.workbench.common.dmn.client.widgets.grid.model.DMNGridCell;
import org.kie.workbench.common.dmn.client.widgets.grid.model.DMNGridColumn;
import org.kie.workbench.common.dmn.client.widgets.grid.model.DMNGridData;
import org.kie.workbench.common.dmn.client.widgets.grid.model.ExpressionEditorChanged;
import org.kie.workbench.common.dmn.client.widgets.grid.model.GridCellTuple;
import org.kie.workbench.common.dmn.client.widgets.grid.model.GridCellValueTuple;
import org.kie.workbench.common.dmn.client.widgets.layer.DMNGridLayer;
import org.kie.workbench.common.dmn.client.widgets.panel.DMNGridPanel;
import org.kie.workbench.common.stunner.core.client.ReadOnlyProvider;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.command.UpdateElementPropertyCommand;
import org.kie.workbench.common.stunner.core.client.canvas.event.selection.DomainObjectSelectionEvent;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandResultBuilder;
import org.kie.workbench.common.stunner.core.client.command.SessionCommandManager;
import org.kie.workbench.common.stunner.core.client.session.ClientSession;
import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.domainobject.DomainObject;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;
import org.kie.workbench.common.stunner.core.graph.processing.index.Index;
import org.kie.workbench.common.stunner.core.util.UUID;
import org.kie.workbench.common.stunner.forms.client.event.RefreshFormPropertiesEvent;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.wires.core.grids.client.model.GridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridColumn;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridRow;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.grid.NodeMouseEventHandler;
import org.uberfire.ext.wires.core.grids.client.widget.grid.columns.RowNumberColumn;
import org.uberfire.ext.wires.core.grids.client.widget.grid.impl.DefaultGridWidgetCellSelectorMouseEventHandler;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.columns.GridColumnRenderer;
import org.uberfire.ext.wires.core.grids.client.widget.grid.selections.SelectionExtension;
import org.uberfire.ext.wires.core.grids.client.widget.layer.GridSelectionManager;
import org.uberfire.ext.wires.core.grids.client.widget.layer.impl.GridLayerRedrawManager;
import org.uberfire.ext.wires.core.grids.client.widget.layer.pinning.GridPinnedModeManager;
import org.uberfire.mocks.EventSourceMock;

@RunWith(value=LienzoMockitoTestRunner.class)
public class BaseExpressionGridGeneralTest
extends BaseExpressionGridTest {
    private static final String NODE_UUID = "uuid";
    private static final Name NAME = new Name("name");
    private static final QName TYPE_REF = new QName();
    private static final String DEFINITION = "definition";
    private static final String NAME_ID = "nameId";
    private static final double COLUMN_WIDTH = 100.0;
    private static final double HEADER_HEIGHT = 100.0;
    private GridCellTuple tupleWithoutValue;
    private GridCellValueTuple tupleWithValue;
    @Mock
    private ClientSession session;
    @Mock
    private AbstractCanvasHandler canvasHandler;
    @Mock
    private Diagram diagram;
    @Mock
    private Graph graph;
    @Mock
    private Node node;
    @Mock
    private Index<?, ?> index;
    @Mock
    private Element element;
    @Mock
    private Definition definition;
    @Mock
    private UpdateElementPropertyCommand updateElementPropertyCommand;
    @Mock
    private Group header;
    @Mock
    private ReadOnlyProvider readOnlyProvider;
    @Captor
    private ArgumentCaptor<GridLayerRedrawManager.PrioritizedCommand> redrawCommandCaptor;
    @Captor
    private ArgumentCaptor<Command> commandCaptor;
    @Captor
    private ArgumentCaptor<DomainObjectSelectionEvent> domainObjectSelectionEventCaptor;
    @Captor
    private ArgumentCaptor<RefreshFormPropertiesEvent> refreshFormPropertiesEventCaptor;
    @Captor
    private ArgumentCaptor<ExpressionEditorChanged> expressionEditorChangedArgumentCaptor;
    private Decision decision = new Decision();

    @Override
    public void setup() {
        super.setup();
        this.tupleWithoutValue = new GridCellTuple(0, 0, (GridWidget)this.grid);
        this.tupleWithValue = new GridCellValueTuple(0, 0, (GridWidget)this.grid, (GridCellValue)new BaseGridCellValue((Object)"value"));
        Mockito.when((Object)this.sessionManager.getCurrentSession()).thenReturn((Object)this.session);
        Mockito.when((Object)this.session.getCanvasHandler()).thenReturn((Object)this.canvasHandler);
        Mockito.when((Object)this.canvasHandler.getDiagram()).thenReturn((Object)this.diagram);
        Mockito.when((Object)this.diagram.getGraph()).thenReturn((Object)this.graph);
        Mockito.when((Object)this.graph.nodes()).thenReturn(Collections.singletonList(this.node));
        Mockito.when((Object)this.canvasHandler.getGraphIndex()).thenReturn(this.index);
        Mockito.when((Object)this.element.getContent()).thenReturn((Object)this.definition);
        Mockito.when((Object)this.definition.getDefinition()).thenReturn((Object)DEFINITION);
        Mockito.when((Object)this.definitionUtils.getNameIdentifier((Object)DEFINITION)).thenReturn((Object)NAME_ID);
        Mockito.when((Object)this.updateElementPropertyCommand.execute(this.canvasHandler)).thenReturn((Object)CanvasCommandResultBuilder.SUCCESS);
        Mockito.when((Object)this.grid.getHeader()).thenReturn((Object)this.header);
        Mockito.when((Object)this.header.getY()).thenReturn((Object)0.0);
        Mockito.when((Object)this.renderer.getHeaderHeight()).thenReturn((Object)100.0);
        Mockito.when((Object)this.renderer.getHeaderRowHeight()).thenReturn((Object)100.0);
    }

    @Override
    public BaseExpressionGrid getGrid() {
        Optional<Decision> hasName = Optional.of(this.decision);
        return new BaseExpressionGrid(this.parentCell, Optional.empty(), HasExpression.NOP, hasName, this.gridPanel, this.gridLayer, (GridData)new DMNGridData(), this.renderer, this.definitionUtils, this.sessionManager, this.sessionCommandManager, this.canvasCommandFactory, (Event)this.editorSelectedEvent, (Event)this.refreshFormPropertiesEvent, (Event)this.domainObjectSelectionEvent, this.cellEditorControls, this.listSelector, this.translationService, false, 0, this.readOnlyProvider){

            protected BaseUIModelMapper makeUiModelMapper() {
                return BaseExpressionGridGeneralTest.this.mapper;
            }

            protected void initialiseUiColumns() {
            }

            public void initialiseUiRows() {
            }

            public void initialiseUiCells() {
            }
        };
    }

    @Test
    public void testDefaultNodeMouseClickHandlers() {
        List handlers = this.grid.getNodeMouseClickEventHandlers((GridSelectionManager)this.gridLayer);
        Assertions.assertThat((List)handlers).hasSize(2);
        Assertions.assertThat((Object)((NodeMouseEventHandler)handlers.get(0))).isInstanceOf(DefaultGridWidgetCellSelectorMouseEventHandler.class);
        Assertions.assertThat((Object)((NodeMouseEventHandler)handlers.get(1))).isInstanceOf(EditableHeaderGridWidgetEditCellMouseEventHandler.class);
    }

    @Test
    public void testDefaultNodeMouseDoubleClickHandlers() {
        List handlers = this.grid.getNodeMouseDoubleClickEventHandlers((GridSelectionManager)this.gridLayer, (GridPinnedModeManager)this.gridLayer);
        Assertions.assertThat((List)handlers).hasSize(1);
        Assertions.assertThat((Object)((NodeMouseEventHandler)handlers.get(0))).isInstanceOf(EditableHeaderGridWidgetEditCellMouseEventHandler.class);
    }

    @Test
    public void testGetMinimumWidthNoColumns() {
        this.assertMinimumWidth(0.0, new MockColumnData[0]);
        Assertions.assertThat((double)this.grid.getMinimumWidth()).isEqualTo(0.0);
    }

    @Test
    public void testGetMinimumWidthOneColumn() {
        double COL_0_MIN = 100.0;
        this.assertMinimumWidth(100.0, new MockColumnData(200.0, 100.0));
    }

    @Test
    public void testGetMinimumWidthTwoColumns() {
        double COL_0_ACTUAL = 200.0;
        double COL_1_MIN = 150.0;
        this.assertMinimumWidth(350.0, new MockColumnData(200.0, 100.0), new MockColumnData(225.0, 150.0));
    }

    @Test
    public void testGetMinimumWidthMultipleColumns() {
        double COL_0_ACTUAL = 50.0;
        double COL_1_ACTUAL = 65.0;
        double COL_2_MIN = 150.0;
        this.assertMinimumWidth(265.0, new MockColumnData(50.0, 25.0), new MockColumnData(65.0, 35.0), new MockColumnData(225.0, 150.0));
    }

    @Test
    public void testGetViewportGridAttachedToLayer() {
        ((BaseExpressionGrid)Mockito.doReturn((Object)this.gridParent).when((Object)this.grid)).getParent();
        ((com.ait.lienzo.client.core.shape.Node)Mockito.doReturn((Object)this.viewport).when((Object)this.gridParent)).getViewport();
        Assert.assertEquals((Object)this.viewport, (Object)this.grid.getViewport());
    }

    @Test
    public void testGetViewportGridNotAttachedToLayer() {
        Assert.assertEquals((Object)this.viewport, (Object)this.grid.getViewport());
    }

    @Test
    public void testGetLayerGridAttachedToLayer() {
        ((BaseExpressionGrid)Mockito.doReturn((Object)this.gridParent).when((Object)this.grid)).getParent();
        ((com.ait.lienzo.client.core.shape.Node)Mockito.doReturn((Object)this.gridLayer).when((Object)this.gridParent)).getLayer();
        Assert.assertEquals((Object)this.gridLayer, (Object)this.grid.getLayer());
    }

    @Test
    public void testGetLayerGridNotAttachedToLayer() {
        Assert.assertEquals((Object)this.gridLayer, (Object)this.grid.getLayer());
    }

    @Test
    public void testSelect() {
        String expectedUUID = "0000-1111-2222";
        ((EventSourceMock)Mockito.doNothing().when((Object)this.editorSelectedEvent)).fire((Object)((ExpressionEditorChanged)ArgumentMatchers.any()));
        ((BaseExpressionGrid)Mockito.doReturn(Optional.of("0000-1111-2222")).when((Object)this.grid)).getNodeUUID();
        this.grid.select();
        ((BaseExpressionGrid)Mockito.verify((Object)this.grid, (VerificationMode)Mockito.never())).selectFirstCell();
        ((EventSourceMock)Mockito.verify((Object)this.editorSelectedEvent)).fire((Object)((ExpressionEditorChanged)this.expressionEditorChangedArgumentCaptor.capture()));
        Assert.assertEquals((Object)"0000-1111-2222", (Object)((ExpressionEditorChanged)this.expressionEditorChangedArgumentCaptor.getValue()).getNodeUUID());
    }

    @Test
    public void testDeselect() {
        String expectedUUID = "0000-1111-2222";
        ((BaseExpressionGrid)Mockito.doReturn(Optional.of("0000-1111-2222")).when((Object)this.grid)).getNodeUUID();
        this.grid.getModel().appendRow((GridRow)new BaseGridRow());
        this.appendColumns(GridColumn.class);
        this.grid.getModel().selectCell(0, 0);
        Assert.assertFalse((boolean)this.grid.getModel().getSelectedCells().isEmpty());
        this.grid.deselect();
        Assert.assertTrue((boolean)this.grid.getModel().getSelectedCells().isEmpty());
        ((BaseExpressionGrid)Mockito.verify((Object)this.grid)).clearSelectedDomainObject();
        ((EventSourceMock)Mockito.verify((Object)this.editorSelectedEvent)).fire((Object)((ExpressionEditorChanged)this.expressionEditorChangedArgumentCaptor.capture()));
        Assert.assertEquals((Object)"0000-1111-2222", (Object)((ExpressionEditorChanged)this.expressionEditorChangedArgumentCaptor.getValue()).getNodeUUID());
    }

    @Test
    public void testSelectFirstCellWithNoRowsOrColumns() {
        this.grid.selectFirstCell();
        Assertions.assertThat((List)this.grid.getModel().getSelectedCells()).isEmpty();
    }

    @Test
    public void testSelectFirstCellWithRowAndNonRowNumberColumn() {
        this.grid.getModel().appendRow((GridRow)new BaseGridRow());
        this.appendColumns(GridColumn.class);
        this.grid.selectFirstCell();
        Assertions.assertThat((List)this.grid.getModel().getSelectedCells()).isNotEmpty();
        Assertions.assertThat((List)this.grid.getModel().getSelectedCells()).contains((Object[])new GridData.SelectedCell[]{new GridData.SelectedCell(0, 0)});
        ((EventSourceMock)Mockito.verify((Object)this.domainObjectSelectionEvent)).fire((Object)((DomainObjectSelectionEvent)this.domainObjectSelectionEventCaptor.capture()));
        DomainObjectSelectionEvent domainObjectSelectionEvent = (DomainObjectSelectionEvent)this.domainObjectSelectionEventCaptor.getValue();
        Assertions.assertThat((Object)domainObjectSelectionEvent.getDomainObject()).isInstanceOf(NOPDomainObject.class);
    }

    @Test
    public void testSelectFirstCellWithRowAndRowNumberColumn() {
        this.grid.getModel().appendRow((GridRow)new BaseGridRow());
        this.appendColumns(RowNumberColumn.class);
        this.grid.selectFirstCell();
        Assertions.assertThat((List)this.grid.getModel().getSelectedCells()).isEmpty();
    }

    @Test
    public void testSelectFirstCellWithRowAndRowNumberColumnAndAnotherColumn() {
        this.grid.getModel().appendRow((GridRow)new BaseGridRow());
        this.appendColumns(RowNumberColumn.class, GridColumn.class);
        this.grid.selectFirstCell();
        Assertions.assertThat((List)this.grid.getModel().getSelectedCells()).isNotEmpty();
        Assertions.assertThat((List)this.grid.getModel().getSelectedCells()).contains((Object[])new GridData.SelectedCell[]{new GridData.SelectedCell(0, 1)});
        ((EventSourceMock)Mockito.verify((Object)this.domainObjectSelectionEvent)).fire((Object)((DomainObjectSelectionEvent)this.domainObjectSelectionEventCaptor.capture()));
        DomainObjectSelectionEvent domainObjectSelectionEvent = (DomainObjectSelectionEvent)this.domainObjectSelectionEventCaptor.getValue();
        Assertions.assertThat((Object)domainObjectSelectionEvent.getDomainObject()).isInstanceOf(NOPDomainObject.class);
    }

    @Test
    public void testSelectCellWithPoint() {
        this.grid.getModel().appendRow((GridRow)new BaseGridRow());
        this.appendColumns(RowNumberColumn.class, GridColumn.class);
        Point2D point = (Point2D)Mockito.mock(Point2D.class);
        double columnOffset = ((GridColumn)this.grid.getModel().getColumns().get(0)).getWidth();
        double columnWidth = ((GridColumn)this.grid.getModel().getColumns().get(1)).getWidth() / 2.0;
        double rowOffset = 100.0 + this.grid.getModel().getRow(0).getHeight() / 2.0;
        Mockito.when((Object)point.getX()).thenReturn((Object)(columnOffset + columnWidth));
        Mockito.when((Object)point.getY()).thenReturn((Object)rowOffset);
        this.grid.selectCell(point, false, true);
        Assertions.assertThat((List)this.grid.getModel().getSelectedCells()).isNotEmpty();
        Assertions.assertThat((List)this.grid.getModel().getSelectedCells()).contains((Object[])new GridData.SelectedCell[]{new GridData.SelectedCell(0, 1)});
        ((EventSourceMock)Mockito.verify((Object)this.domainObjectSelectionEvent)).fire((Object)((DomainObjectSelectionEvent)this.domainObjectSelectionEventCaptor.capture()));
        DomainObjectSelectionEvent domainObjectSelectionEvent = (DomainObjectSelectionEvent)this.domainObjectSelectionEventCaptor.getValue();
        Assertions.assertThat((Object)domainObjectSelectionEvent.getDomainObject()).isInstanceOf(NOPDomainObject.class);
    }

    @Test
    public void testSelectExpressionEditorFirstCell() {
        this.grid.getModel().appendRow((GridRow)new BaseGridRow());
        this.appendColumns(GridColumn.class);
        ExpressionCellValue cellValue = (ExpressionCellValue)Mockito.mock(ExpressionCellValue.class);
        BaseExpressionGrid cellGrid = (BaseExpressionGrid)Mockito.mock(BaseExpressionGrid.class);
        Mockito.when((Object)((Optional)cellValue.getValue())).thenReturn(Optional.of(cellGrid));
        this.grid.getModel().setCellValue(0, 0, (GridCellValue)cellValue);
        this.grid.selectExpressionEditorFirstCell(0, 0);
        ((DMNGridLayer)Mockito.verify((Object)this.gridLayer)).select((GridWidget)cellGrid);
        ((BaseExpressionGrid)Mockito.verify((Object)cellGrid)).selectFirstCell();
    }

    @Test
    public void testSelectHeaderWithPoint() {
        this.grid.getModel().appendColumn((GridColumn)new RowNumberColumn());
        this.grid.getModel().appendColumn((GridColumn)new RowNumberColumn());
        Point2D point = (Point2D)Mockito.mock(Point2D.class);
        double columnOffset = ((GridColumn)this.grid.getModel().getColumns().get(0)).getWidth();
        double columnWidth = ((GridColumn)this.grid.getModel().getColumns().get(1)).getWidth() / 2.0;
        Mockito.when((Object)point.getX()).thenReturn((Object)(columnOffset + columnWidth));
        Mockito.when((Object)point.getY()).thenReturn((Object)50.0);
        Mockito.when((Object)this.grid.getHeader()).thenReturn((Object)this.header);
        Mockito.when((Object)this.header.getY()).thenReturn((Object)0.0);
        Mockito.when((Object)this.renderer.getHeaderHeight()).thenReturn((Object)100.0);
        Mockito.when((Object)this.renderer.getHeaderRowHeight()).thenReturn((Object)100.0);
        this.grid.selectHeaderCell(point, false, false);
        this.assertHeaderSelection();
        this.assertDomainObjectEventFiring();
    }

    @Test
    public void testSelectHeaderWithCoordinate() {
        this.grid.getModel().appendColumn((GridColumn)new RowNumberColumn());
        this.grid.getModel().appendColumn((GridColumn)new RowNumberColumn());
        this.grid.selectHeaderCell(0, 1, false, false);
        this.assertHeaderSelection();
        this.assertDomainObjectEventFiring();
    }

    @Test
    public void testSelectHeaderCellWithDomainObjectInStunnerGraph() {
        this.grid.getModel().appendColumn((GridColumn)new RowNumberColumn());
        this.grid.getModel().appendColumn((GridColumn)new RowNumberColumn());
        Definition definition = (Definition)Mockito.mock(Definition.class);
        Mockito.when((Object)this.node.getUUID()).thenReturn((Object)NODE_UUID);
        Mockito.when((Object)this.node.getContent()).thenReturn((Object)definition);
        Mockito.when((Object)definition.getDefinition()).thenReturn((Object)this.decision);
        ((BaseExpressionGrid)Mockito.doAnswer(i -> {
            this.grid.fireDomainObjectSelectionEvent((DomainObject)this.decision);
            return null;
        }).when((Object)this.grid)).doAfterHeaderSelectionChange(ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt());
        this.grid.selectHeaderCell(0, 1, false, false);
        this.assertHeaderSelection();
        ((EventSourceMock)Mockito.verify((Object)this.refreshFormPropertiesEvent)).fire((Object)((RefreshFormPropertiesEvent)this.refreshFormPropertiesEventCaptor.capture()));
        RefreshFormPropertiesEvent refreshFormPropertiesEvent = (RefreshFormPropertiesEvent)this.refreshFormPropertiesEventCaptor.getValue();
        Assertions.assertThat((String)refreshFormPropertiesEvent.getUuid()).isEqualTo(NODE_UUID);
        Assertions.assertThat((Object)refreshFormPropertiesEvent.getSession()).isEqualTo((Object)this.session);
    }

    @Test
    public void testAdjustSelectionHandling_DataCells() {
        this.grid.getModel().appendColumn((GridColumn)new RowNumberColumn());
        this.grid.getModel().appendRow((GridRow)new BaseGridRow());
        this.grid.selectHeaderCell(0, 0, false, false);
        Mockito.reset((Object[])new BaseExpressionGrid[]{this.grid});
        this.grid.adjustSelection(SelectionExtension.DOWN, false);
        ((BaseExpressionGrid)Mockito.verify((Object)this.grid)).doAfterSelectionChange(0, 0);
    }

    @Test
    public void testAdjustSelectionHandling_HeaderCells() {
        this.grid.getModel().appendColumn((GridColumn)new RowNumberColumn());
        this.grid.getModel().appendRow((GridRow)new BaseGridRow());
        this.grid.selectCell(0, 0, false, false);
        Mockito.reset((Object[])new BaseExpressionGrid[]{this.grid});
        this.grid.adjustSelection(SelectionExtension.UP, false);
        ((BaseExpressionGrid)Mockito.verify((Object)this.grid)).doAfterHeaderSelectionChange(0, 0);
    }

    @Test
    public void testAdjustSelectionHandling_MoveUpWhenOnTopAlready() {
        this.grid.getModel().appendColumn((GridColumn)new RowNumberColumn());
        this.grid.getModel().appendRow((GridRow)new BaseGridRow());
        this.grid.selectHeaderCell(0, 0, false, false);
        Mockito.reset((Object[])new BaseExpressionGrid[]{this.grid});
        this.grid.adjustSelection(SelectionExtension.UP, false);
        ((BaseExpressionGrid)Mockito.verify((Object)this.grid, (VerificationMode)Mockito.never())).doAfterHeaderSelectionChange(ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt());
    }

    @Test
    public void testAdjustSelectionHandling_MoveDownWhenAtBottomAlready() {
        this.grid.getModel().appendColumn((GridColumn)new RowNumberColumn());
        this.grid.getModel().appendRow((GridRow)new BaseGridRow());
        this.grid.selectCell(0, 0, false, false);
        Mockito.reset((Object[])new BaseExpressionGrid[]{this.grid});
        this.grid.adjustSelection(SelectionExtension.DOWN, false);
        ((BaseExpressionGrid)Mockito.verify((Object)this.grid, (VerificationMode)Mockito.never())).doAfterSelectionChange(ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt());
    }

    private void assertHeaderSelection() {
        Assertions.assertThat((List)this.grid.getModel().getSelectedHeaderCells()).isNotEmpty();
        Assertions.assertThat((List)this.grid.getModel().getSelectedHeaderCells()).contains((Object[])new GridData.SelectedCell[]{new GridData.SelectedCell(0, 1)});
    }

    private void assertDomainObjectEventFiring() {
        ((EventSourceMock)Mockito.verify((Object)this.domainObjectSelectionEvent)).fire((Object)((DomainObjectSelectionEvent)this.domainObjectSelectionEventCaptor.capture()));
        DomainObjectSelectionEvent domainObjectSelectionEvent = (DomainObjectSelectionEvent)this.domainObjectSelectionEventCaptor.getValue();
        Assertions.assertThat((Object)domainObjectSelectionEvent.getDomainObject()).isInstanceOf(NOPDomainObject.class);
    }

    @Test
    public void testPaddingWithParent() {
        ((BaseExpressionGrid)Mockito.doReturn(Optional.of((BaseExpressionGrid)Mockito.mock(BaseExpressionGrid.class))).when((Object)this.grid)).findParentGrid();
        Assertions.assertThat((double)this.grid.getPadding()).isEqualTo(10.0);
    }

    @Test
    public void testPaddingWithNoParent() {
        ((BaseExpressionGrid)Mockito.doReturn(Optional.empty()).when((Object)this.grid)).findParentGrid();
        Assertions.assertThat((double)this.grid.getPadding()).isEqualTo(10.0);
    }

    @Test
    public void testFindParentGrid() throws Exception {
        GridWidget parentGrid = (GridWidget)Mockito.mock(BaseExpressionGrid.class);
        ((GridCellTuple)Mockito.doReturn((Object)parentGrid).when((Object)this.parentCell)).getGridWidget();
        Assertions.assertThat(this.grid.findParentGrid().get()).isEqualTo((Object)parentGrid);
    }

    @Test
    public void testFindParentGridNoParent() throws Exception {
        Assertions.assertThat((Optional)this.grid.findParentGrid()).isEmpty();
    }

    @Test
    public void testWidthIncreased() throws Exception {
        this.testUpdateWidthOfPeers(0, 150.0);
    }

    @Test
    public void testWidthIncreasedMultipleChildColumnsFirstUpdated() throws Exception {
        this.testUpdateWidthOfPeers(0, 150.0, 180.0);
    }

    @Test
    public void testWidthIncreasedMultipleChildColumnsLastUpdated() throws Exception {
        this.testUpdateWidthOfPeers(1, 150.0, 180.0);
    }

    @Test
    public void testWidthDecreased() throws Exception {
        this.testUpdateWidthOfPeers(0, 80.0);
    }

    @Test
    public void testWidthDecreasedMultipleChildColumnsFirstUpdated() throws Exception {
        this.testUpdateWidthOfPeers(0, 35.0, 45.0);
    }

    @Test
    public void testWidthDecreasedMultipleChildColumnsLastUpdated() throws Exception {
        this.testUpdateWidthOfPeers(1, 35.0, 45.0);
    }

    @Test
    public void testResizeWhenExpressionEditorChanged() {
        this.grid.resize(BaseExpressionGrid.RESIZE_EXISTING);
        ((DMNGridPanel)Mockito.verify((Object)this.gridPanel)).refreshScrollPosition();
        ((DMNGridPanel)Mockito.verify((Object)this.gridPanel)).updatePanelSize();
        ((GridCellTuple)Mockito.verify((Object)this.parentCell)).onResize();
        ((DMNGridLayer)Mockito.verify((Object)this.gridLayer)).batch((GridLayerRedrawManager.PrioritizedCommand)this.redrawCommandCaptor.capture());
        GridLayerRedrawManager.PrioritizedCommand redrawCommand = (GridLayerRedrawManager.PrioritizedCommand)this.redrawCommandCaptor.getValue();
        redrawCommand.execute();
        ((DMNGridLayer)Mockito.verify((Object)this.gridLayer)).draw();
    }

    @Test
    public void testResize() {
        this.grid.resize(BaseExpressionGrid.RESIZE_EXISTING);
        ((DMNGridPanel)Mockito.verify((Object)this.gridPanel)).refreshScrollPosition();
        ((DMNGridPanel)Mockito.verify((Object)this.gridPanel)).updatePanelSize();
        ((DMNGridPanel)Mockito.verify((Object)this.gridPanel)).setFocus(true);
        ((GridCellTuple)Mockito.verify((Object)this.parentCell)).onResize();
        ((DMNGridLayer)Mockito.verify((Object)this.gridLayer)).batch((GridLayerRedrawManager.PrioritizedCommand)this.redrawCommandCaptor.capture());
        GridLayerRedrawManager.PrioritizedCommand redrawCommand = (GridLayerRedrawManager.PrioritizedCommand)this.redrawCommandCaptor.getValue();
        redrawCommand.execute();
        ((DMNGridLayer)Mockito.verify((Object)this.gridLayer)).draw();
        ((DMNGridLayer)Mockito.verify((Object)this.gridLayer, (VerificationMode)Mockito.never())).select((GridWidget)ArgumentMatchers.any(GridWidget.class));
    }

    @Test
    public void testHeaderTextBoxFactory() {
        this.appendColumns(GridColumn.class);
        Mockito.when((Object)((GridColumn)this.grid.getModel().getColumns().get(0)).getHeaderMetaData()).thenReturn(Collections.singletonList((GridColumn.HeaderMetaData)Mockito.mock(EditableHeaderMetaData.class)));
        Mockito.when((Object)this.mapper.getUiModel()).thenReturn(() -> this.grid.getModel());
        TextBoxSingletonDOMElementFactory factory = this.grid.getHeaderTextBoxFactory();
        Assertions.assertThat((Object)((Command)factory.getHasNoValueCommand().apply(this.tupleWithoutValue))).isInstanceOf(DeleteHeaderValueCommand.class);
        Assertions.assertThat((Object)((Command)factory.getHasValueCommand().apply(this.tupleWithValue))).isInstanceOf(SetHeaderValueCommand.class);
    }

    @Test
    public void testHeaderTextAreaFactory() {
        this.appendColumns(GridColumn.class);
        Mockito.when((Object)((GridColumn)this.grid.getModel().getColumns().get(0)).getHeaderMetaData()).thenReturn(Collections.singletonList((GridColumn.HeaderMetaData)Mockito.mock(EditableHeaderMetaData.class)));
        Mockito.when((Object)this.mapper.getUiModel()).thenReturn(() -> this.grid.getModel());
        TextAreaSingletonDOMElementFactory factory = this.grid.getHeaderTextAreaFactory();
        Assertions.assertThat((Object)((Command)factory.getHasNoValueCommand().apply(this.tupleWithoutValue))).isInstanceOf(DeleteHeaderValueCommand.class);
        Assertions.assertThat((Object)((Command)factory.getHasValueCommand().apply(this.tupleWithValue))).isInstanceOf(SetHeaderValueCommand.class);
    }

    @Test
    public void testBodyListBoxFactory() {
        this.appendColumns(GridColumn.class);
        Mockito.when((Object)((GridColumn)this.grid.getModel().getColumns().get(0)).getHeaderMetaData()).thenReturn(Collections.singletonList((GridColumn.HeaderMetaData)Mockito.mock(EditableHeaderMetaData.class)));
        Mockito.when((Object)this.mapper.getUiModel()).thenReturn(() -> this.grid.getModel());
        ListBoxSingletonDOMElementFactory factory = this.grid.getBodyListBoxFactory();
        Assertions.assertThat((Object)((Command)factory.getHasNoValueCommand().apply(this.tupleWithoutValue))).isInstanceOf(DeleteCellValueCommand.class);
        Assertions.assertThat((Object)((Command)factory.getHasValueCommand().apply(this.tupleWithValue))).isInstanceOf(SetCellValueCommand.class);
    }

    @Test
    public void testClearValueConsumer() {
        this.doTestClearValueConsumer(false, DeleteHasValueCommand.class);
        ((DMNGridLayer)Mockito.verify((Object)this.gridLayer)).batch();
    }

    @Test
    public void testClearValueConsumerWhenNotNested() {
        this.grid.fireDomainObjectSelectionEvent((DomainObject)this.decision);
        Mockito.reset((Object[])new EventSourceMock[]{this.domainObjectSelectionEvent});
        this.doTestClearValueConsumer(false, DeleteHasValueCommand.class);
        ((DMNGridLayer)Mockito.verify((Object)this.gridLayer)).batch();
        ((EventSourceMock)Mockito.verify((Object)this.domainObjectSelectionEvent)).fire((Object)((DomainObjectSelectionEvent)this.domainObjectSelectionEventCaptor.capture()));
        DomainObjectSelectionEvent domainObjectSelectionEvent = (DomainObjectSelectionEvent)this.domainObjectSelectionEventCaptor.getValue();
        Assertions.assertThat((Object)domainObjectSelectionEvent.getDomainObject()).isEqualTo((Object)this.decision);
        Assertions.assertThat((Object)domainObjectSelectionEvent.getCanvasHandler()).isEqualTo((Object)this.canvasHandler);
    }

    @Test
    public void testClearValueConsumerAndUpdateStunnerTitle() {
        this.doTestClearValueConsumer(true, DeleteHasValueCommand.class);
        ((DMNGridLayer)Mockito.verify((Object)this.gridLayer)).batch();
    }

    @Test
    public void testClearValueConsumerWhenNotNestedAndUpdateStunnerTitle() {
        this.grid.fireDomainObjectSelectionEvent((DomainObject)this.decision);
        Mockito.reset((Object[])new EventSourceMock[]{this.domainObjectSelectionEvent});
        String uuid = UUID.uuid();
        Name name = new Name();
        ((BaseExpressionGrid)Mockito.doReturn(Optional.of(uuid)).when((Object)this.grid)).getNodeUUID();
        Mockito.when((Object)this.index.get(uuid)).thenReturn((Object)this.element);
        Mockito.when((Object)this.canvasCommandFactory.updatePropertyValue(this.element, NAME_ID, (Object)name)).thenReturn((Object)this.updateElementPropertyCommand);
        this.doTestClearValueConsumer(true, DeleteHasValueCommand.class, UpdateElementPropertyCommand.class);
        ((DMNGridLayer)Mockito.verify((Object)this.gridLayer)).batch();
        ((UpdateElementPropertyCommand)Mockito.verify((Object)this.updateElementPropertyCommand)).execute((AbstractCanvasHandler)ArgumentMatchers.eq((Object)this.canvasHandler));
        ((EventSourceMock)Mockito.verify((Object)this.domainObjectSelectionEvent)).fire((Object)((DomainObjectSelectionEvent)this.domainObjectSelectionEventCaptor.capture()));
        DomainObjectSelectionEvent domainObjectSelectionEvent = (DomainObjectSelectionEvent)this.domainObjectSelectionEventCaptor.getValue();
        Assertions.assertThat((Object)domainObjectSelectionEvent.getDomainObject()).isEqualTo((Object)this.decision);
        Assertions.assertThat((Object)domainObjectSelectionEvent.getCanvasHandler()).isEqualTo((Object)this.canvasHandler);
    }

    private void doTestClearValueConsumer(boolean updateStunnerTitle, Class ... expectedCommandClasses) {
        this.grid.clearValueConsumer(updateStunnerTitle, (Object)new Name()).accept(this.decision);
        ((SessionCommandManager)Mockito.verify((Object)this.sessionCommandManager)).execute((Object)((AbstractCanvasHandler)ArgumentMatchers.eq((Object)this.canvasHandler)), (Command)this.commandCaptor.capture());
        Command command = (Command)this.commandCaptor.getValue();
        GridFactoryCommandUtils.assertCommands(command, expectedCommandClasses);
        command.execute((Object)this.canvasHandler);
    }

    @Test
    public void testSetValueConsumer() {
        this.doTestSetValueConsumer(false, SetHasValueCommand.class);
        ((DMNGridLayer)Mockito.verify((Object)this.gridLayer)).batch();
    }

    @Test
    public void testSetValueConsumerWhenNotNested() {
        this.grid.fireDomainObjectSelectionEvent((DomainObject)this.decision);
        Mockito.reset((Object[])new EventSourceMock[]{this.domainObjectSelectionEvent});
        this.doTestSetValueConsumer(false, SetHasValueCommand.class);
        ((DMNGridLayer)Mockito.verify((Object)this.gridLayer)).batch();
        ((EventSourceMock)Mockito.verify((Object)this.domainObjectSelectionEvent)).fire((Object)((DomainObjectSelectionEvent)this.domainObjectSelectionEventCaptor.capture()));
        DomainObjectSelectionEvent domainObjectSelectionEvent = (DomainObjectSelectionEvent)this.domainObjectSelectionEventCaptor.getValue();
        Assertions.assertThat((Object)domainObjectSelectionEvent.getDomainObject()).isEqualTo((Object)this.decision);
        Assertions.assertThat((Object)domainObjectSelectionEvent.getCanvasHandler()).isEqualTo((Object)this.canvasHandler);
    }

    @Test
    public void testSetValueConsumerAndUpdateStunnerTitle() {
        this.doTestSetValueConsumer(true, SetHasValueCommand.class);
        ((DMNGridLayer)Mockito.verify((Object)this.gridLayer)).batch();
    }

    @Test
    public void testSetValueConsumerWhenNotNestedAndUpdateStunnerTitle() {
        this.grid.fireDomainObjectSelectionEvent((DomainObject)this.decision);
        Mockito.reset((Object[])new EventSourceMock[]{this.domainObjectSelectionEvent});
        String uuid = UUID.uuid();
        ((BaseExpressionGrid)Mockito.doReturn(Optional.of(uuid)).when((Object)this.grid)).getNodeUUID();
        Mockito.when((Object)this.index.get(uuid)).thenReturn((Object)this.element);
        Mockito.when((Object)this.canvasCommandFactory.updatePropertyValue(this.element, NAME_ID, (Object)NAME)).thenReturn((Object)this.updateElementPropertyCommand);
        this.doTestSetValueConsumer(true, SetHasValueCommand.class, UpdateElementPropertyCommand.class);
        ((DMNGridLayer)Mockito.verify((Object)this.gridLayer)).batch();
        ((UpdateElementPropertyCommand)Mockito.verify((Object)this.updateElementPropertyCommand)).execute((AbstractCanvasHandler)ArgumentMatchers.eq((Object)this.canvasHandler));
        ((EventSourceMock)Mockito.verify((Object)this.domainObjectSelectionEvent)).fire((Object)((DomainObjectSelectionEvent)this.domainObjectSelectionEventCaptor.capture()));
        DomainObjectSelectionEvent domainObjectSelectionEvent = (DomainObjectSelectionEvent)this.domainObjectSelectionEventCaptor.getValue();
        Assertions.assertThat((Object)domainObjectSelectionEvent.getDomainObject()).isEqualTo((Object)this.decision);
        Assertions.assertThat((Object)domainObjectSelectionEvent.getCanvasHandler()).isEqualTo((Object)this.canvasHandler);
    }

    private void doTestSetValueConsumer(boolean updateStunnerTitle, Class ... expectedCommandClasses) {
        this.grid.setValueConsumer(updateStunnerTitle).accept(this.decision, NAME);
        ((SessionCommandManager)Mockito.verify((Object)this.sessionCommandManager)).execute((Object)((AbstractCanvasHandler)ArgumentMatchers.eq((Object)this.canvasHandler)), (Command)this.commandCaptor.capture());
        Command command = (Command)this.commandCaptor.getValue();
        GridFactoryCommandUtils.assertCommands(command, expectedCommandClasses);
        command.execute((Object)this.canvasHandler);
    }

    @Test
    public void testSetTypeRefConsumer() {
        this.doTestSetTypeRefConsumer();
        ((DMNGridLayer)Mockito.verify((Object)this.gridLayer)).batch();
    }

    @Test
    public void testSetTypeRefConsumerWhenNotNested() {
        this.grid.fireDomainObjectSelectionEvent((DomainObject)this.decision);
        Mockito.reset((Object[])new EventSourceMock[]{this.domainObjectSelectionEvent});
        this.doTestSetTypeRefConsumer();
        ((DMNGridLayer)Mockito.verify((Object)this.gridLayer)).batch();
        ((EventSourceMock)Mockito.verify((Object)this.domainObjectSelectionEvent)).fire((Object)((DomainObjectSelectionEvent)this.domainObjectSelectionEventCaptor.capture()));
        DomainObjectSelectionEvent domainObjectSelectionEvent = (DomainObjectSelectionEvent)this.domainObjectSelectionEventCaptor.getValue();
        Assertions.assertThat((Object)domainObjectSelectionEvent.getDomainObject()).isEqualTo((Object)this.decision);
        Assertions.assertThat((Object)domainObjectSelectionEvent.getCanvasHandler()).isEqualTo((Object)this.canvasHandler);
    }

    @Test
    public void testShowContextMenuHeader() {
        MockHasCellEditorControlsHeaderMetaData headerMetaData = (MockHasCellEditorControlsHeaderMetaData)Mockito.mock(MockHasCellEditorControlsHeaderMetaData.class);
        HasCellEditorControls.Editor cellControlsEditorMock = (HasCellEditorControls.Editor)Mockito.mock(HasCellEditorControls.Editor.class);
        ((MockHasCellEditorControlsHeaderMetaData)Mockito.doReturn(Optional.of(cellControlsEditorMock)).when((Object)headerMetaData)).getEditor();
        this.grid.getModel().appendColumn((GridColumn)new BaseGridColumn((GridColumn.HeaderMetaData)headerMetaData, (GridColumnRenderer)Mockito.mock(GridColumnRenderer.class), 100.0));
        Assertions.assertThat((boolean)this.grid.showContextMenuForHeader(0, 0)).isTrue();
        ((HasCellEditorControls.Editor)Mockito.verify((Object)cellControlsEditorMock)).bind(ArgumentMatchers.eq((Object)headerMetaData), ArgumentMatchers.eq((int)0), ArgumentMatchers.eq((int)0));
        ((CellEditorControlsView.Presenter)Mockito.verify((Object)this.cellEditorControls)).show((HasCellEditorControls.Editor)ArgumentMatchers.eq((Object)cellControlsEditorMock), ArgumentMatchers.eq((int)50), ArgumentMatchers.eq((int)50));
    }

    @Test
    public void testShowContextMenuHeaderMissingEditor() {
        MockHasCellEditorControlsHeaderMetaData headerMetaData = (MockHasCellEditorControlsHeaderMetaData)Mockito.mock(MockHasCellEditorControlsHeaderMetaData.class);
        ((MockHasCellEditorControlsHeaderMetaData)Mockito.doReturn(Optional.empty()).when((Object)headerMetaData)).getEditor();
        this.grid.getModel().appendColumn((GridColumn)new BaseGridColumn((GridColumn.HeaderMetaData)Mockito.mock(GridColumn.HeaderMetaData.class), (GridColumnRenderer)Mockito.mock(GridColumnRenderer.class), 100.0));
        Assertions.assertThat((boolean)this.grid.showContextMenuForHeader(0, 0)).isFalse();
        ((CellEditorControlsView.Presenter)Mockito.verify((Object)this.cellEditorControls, (VerificationMode)Mockito.never())).show((HasCellEditorControls.Editor)ArgumentMatchers.any(HasCellEditorControls.Editor.class), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt());
    }

    @Test
    public void testShowContextMenu() {
        this.grid.getModel().appendColumn((GridColumn)new BaseGridColumn((GridColumn.HeaderMetaData)Mockito.mock(GridColumn.HeaderMetaData.class), (GridColumnRenderer)Mockito.mock(GridColumnRenderer.class), 100.0));
        BaseGridRow gridRow = new BaseGridRow();
        this.grid.getModel().appendRow((GridRow)gridRow);
        DMNGridCell dmnGridCellMock = (DMNGridCell)Mockito.mock(DMNGridCell.class);
        HasCellEditorControls.Editor cellControlsEditorMock = (HasCellEditorControls.Editor)Mockito.mock(HasCellEditorControls.Editor.class);
        ((DMNGridCell)Mockito.doReturn(Optional.of(cellControlsEditorMock)).when((Object)dmnGridCellMock)).getEditor();
        this.grid.getModel().setCell(0, 0, () -> dmnGridCellMock);
        Assertions.assertThat((boolean)this.grid.showContextMenuForCell(0, 0)).isTrue();
        ((HasCellEditorControls.Editor)Mockito.verify((Object)cellControlsEditorMock)).bind(ArgumentMatchers.eq((Object)this.grid), ArgumentMatchers.eq((int)0), ArgumentMatchers.eq((int)0));
        ((CellEditorControlsView.Presenter)Mockito.verify((Object)this.cellEditorControls)).show((HasCellEditorControls.Editor)ArgumentMatchers.eq((Object)cellControlsEditorMock), ArgumentMatchers.eq((int)50), ArgumentMatchers.eq((int)((int)(gridRow.getHeight() / 2.0 + 100.0))));
    }

    @Test
    public void testShowContextMenuMissingEditor() {
        this.grid.getModel().appendColumn((GridColumn)new BaseGridColumn((GridColumn.HeaderMetaData)Mockito.mock(GridColumn.HeaderMetaData.class), (GridColumnRenderer)Mockito.mock(GridColumnRenderer.class), 100.0));
        BaseGridRow gridRow = new BaseGridRow();
        this.grid.getModel().appendRow((GridRow)gridRow);
        DMNGridCell dmnGridCellMock = (DMNGridCell)Mockito.mock(DMNGridCell.class);
        ((DMNGridCell)Mockito.doReturn(Optional.empty()).when((Object)dmnGridCellMock)).getEditor();
        this.grid.getModel().setCell(0, 0, () -> dmnGridCellMock);
        Assertions.assertThat((boolean)this.grid.showContextMenuForCell(0, 0)).isFalse();
        ((CellEditorControlsView.Presenter)Mockito.verify((Object)this.cellEditorControls, (VerificationMode)Mockito.never())).show((HasCellEditorControls.Editor)ArgumentMatchers.any(HasCellEditorControls.Editor.class), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt());
    }

    private void doTestSetTypeRefConsumer() {
        this.grid.setTypeRefConsumer().accept(this.decision.getVariable(), TYPE_REF);
        ((SessionCommandManager)Mockito.verify((Object)this.sessionCommandManager)).execute((Object)((AbstractCanvasHandler)ArgumentMatchers.eq((Object)this.canvasHandler)), (Command)this.commandCaptor.capture());
        Command command = (Command)this.commandCaptor.getValue();
        Assertions.assertThat((Object)command).isInstanceOf(SetTypeRefCommand.class);
        command.execute((Object)this.canvasHandler);
    }

    @Test
    public void testRegisterColumnResizeCompleted() {
        DMNGridColumn uiColumn = this.mockColumn(200.0, (BaseGrid)this.grid);
        this.grid.registerColumnResizeCompleted(uiColumn, 100.0);
        ((SessionCommandManager)Mockito.verify((Object)this.sessionCommandManager)).execute((Object)((AbstractCanvasHandler)ArgumentMatchers.eq((Object)this.canvasHandler)), (Command)this.commandCaptor.capture());
        Command command = (Command)this.commandCaptor.getValue();
        Assertions.assertThat((Object)command).isInstanceOf(SetComponentWidthCommand.class);
    }

    @Test
    public void testReadOnlyModeActive() {
        Mockito.when((Object)this.readOnlyProvider.isReadOnlyDiagram()).thenReturn((Object)true);
        Assertions.assertThat((boolean)this.grid.isOnlyVisualChangeAllowed()).isTrue();
    }

    @Test
    public void testReadOnlyModeNonActive() {
        Mockito.when((Object)this.readOnlyProvider.isReadOnlyDiagram()).thenReturn((Object)false);
        Assertions.assertThat((boolean)this.grid.isOnlyVisualChangeAllowed()).isFalse();
    }

    private void testUpdateWidthOfPeers(int indexOfColumnToUpdate, double ... widthsOfNestedColumns) {
        BaseExpressionGrid parentGrid = (BaseExpressionGrid)Mockito.mock(BaseExpressionGrid.class);
        GridData parentGridData = (GridData)Mockito.mock(GridData.class);
        Mockito.when((Object)parentGrid.getModel()).thenReturn((Object)parentGridData);
        Mockito.when((Object)parentGrid.getExpression()).thenReturn(Optional::empty);
        DMNGridColumn parentColumn = this.mockColumn(100.0, (BaseGrid)parentGrid);
        Mockito.when((Object)this.parentCell.getGridWidget()).thenReturn((Object)parentGrid);
        Mockito.when((Object)parentGridData.getColumns()).thenReturn(Collections.singletonList(parentColumn));
        Mockito.when((Object)parentGridData.getColumnCount()).thenReturn((Object)widthsOfNestedColumns.length);
        Mockito.when((Object)this.gridLayer.getGridWidgets()).thenReturn(Collections.singleton(parentGrid));
        List columns = Arrays.stream(widthsOfNestedColumns).mapToObj(width -> this.mockColumn(width, (BaseGrid)this.grid)).collect(Collectors.toList());
        this.grid.getModel().appendRow((GridRow)new BaseGridRow());
        columns.stream().forEach(column -> this.grid.getModel().appendColumn((GridColumn)column));
        ((DMNGridColumn)columns.get(indexOfColumnToUpdate)).updateWidthOfPeers();
        double padding = 20.0;
        Assertions.assertThat((double)parentColumn.getWidth()).isEqualTo(Arrays.stream(widthsOfNestedColumns).sum() + 20.0);
    }

    private void assertMinimumWidth(double expectedMinimumWidth, MockColumnData ... columnData) {
        Arrays.asList(columnData).forEach(cd -> {
            GridColumn uiColumn = (GridColumn)Mockito.mock(GridColumn.class);
            ((GridColumn)Mockito.doReturn((Object)((MockColumnData)cd).width).when((Object)uiColumn)).getWidth();
            ((GridColumn)Mockito.doReturn((Object)((MockColumnData)cd).minWidth).when((Object)uiColumn)).getMinimumWidth();
            this.grid.getModel().appendColumn(uiColumn);
        });
        Assert.assertEquals((double)expectedMinimumWidth, (double)this.grid.getMinimumWidth(), (double)0.0);
    }

    @SafeVarargs
    private final void appendColumns(Class<? extends GridColumn> ... columnClasses) {
        IntStream.range(0, columnClasses.length).forEach(i -> {
            GridColumn column = (GridColumn)Mockito.mock((Class)columnClasses[i]);
            ((GridColumn)Mockito.doReturn((Object)i).when((Object)column)).getIndex();
            ((GridColumn)Mockito.doReturn((Object)true).when((Object)column)).isVisible();
            ((GridColumn)Mockito.doReturn((Object)100.0).when((Object)column)).getWidth();
            this.grid.getModel().appendColumn(column);
        });
    }

    private DMNGridColumn mockColumn(final double width, BaseGrid gridWidget) {
        GridColumn.HeaderMetaData headerMetaData = (GridColumn.HeaderMetaData)Mockito.mock(GridColumn.HeaderMetaData.class);
        GridColumnRenderer columnRenderer = (GridColumnRenderer)Mockito.mock(GridColumnRenderer.class);
        return new DMNGridColumn(headerMetaData, columnRenderer, width, gridWidget){
            {
                super(arg0, arg1, arg2, arg3);
                this.setWidth(width);
            }
        };
    }

    private static class MockColumnData {
        private double width;
        private double minWidth;

        public MockColumnData(double width, double minWidth) {
            this.width = width;
            this.minWidth = minWidth;
        }
    }

    private static interface MockHasCellEditorControlsHeaderMetaData
    extends HasCellEditorControls,
    GridColumn.HeaderMetaData {
    }
}

