/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.widgets.grid.columns;

import com.ait.lienzo.client.core.types.Point2D;
import com.ait.lienzo.test.LienzoMockitoTestRunner;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.assertj.core.api.Assertions;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.HasName;
import org.kie.workbench.common.dmn.api.definition.HasTypeRef;
import org.kie.workbench.common.dmn.api.definition.model.DMNModelInstrumentedBase;
import org.kie.workbench.common.dmn.api.definition.model.InformationItem;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.dmn.api.property.dmn.QName;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.ContextGrid;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.InformationItemCell;
import org.kie.workbench.common.dmn.client.editors.types.HasValueAndTypeRef;
import org.kie.workbench.common.dmn.client.editors.types.ValueAndDataTypePopoverView;
import org.kie.workbench.common.dmn.client.widgets.grid.columns.EditableNameAndDataTypeColumn;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.HasCellEditorControls;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.container.CellEditorControlsView;
import org.kie.workbench.common.dmn.client.widgets.grid.model.GridCellTuple;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.wires.core.grids.client.model.GridCell;
import org.uberfire.ext.wires.core.grids.client.model.GridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridCell;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridCellValue;
import org.uberfire.ext.wires.core.grids.client.widget.context.GridBodyCellEditContext;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;

@RunWith(value=LienzoMockitoTestRunner.class)
public class EditableNameAndDataTypeColumnTest {
    private static final int UI_ROW_INDEX = 0;
    private static final int UI_COLUMN_INDEX = 1;
    private static final double ABSOLUTE_CELL_X = 100.0;
    private static final double ABSOLUTE_CELL_Y = 200.0;
    private static final double RELATIVE_X = 105.0;
    private static final double RELATIVE_Y = 210.0;
    private static final String NAME = "name";
    private static final String NEW_NAME = "new name";
    private static final String POPOVER_TITLE = "title";
    @Mock
    private GridColumn.HeaderMetaData headerMetaData;
    @Mock
    private ContextGrid gridWidget;
    @Mock
    private Predicate<Integer> isEditable;
    @Mock
    private Consumer<HasName> clearValueConsumer;
    @Mock
    private BiConsumer<HasName, Name> setValueConsumer;
    @Mock
    private BiConsumer<HasTypeRef, QName> setTypeRefConsumer;
    @Mock
    private TranslationService translationService;
    @Mock
    private CellEditorControlsView.Presenter cellEditorControls;
    @Mock
    private ValueAndDataTypePopoverView.Presenter editor;
    @Mock
    private GridBodyCellEditContext context;
    @Mock
    private Consumer<GridCellValue<InformationItemCell.HasNameCell>> callback;
    @Spy
    private InformationItem informationItem = new InformationItem();
    @Captor
    private ArgumentCaptor<HasValueAndTypeRef<Name>> hasNameAndDataTypeControlCaptor;
    @Captor
    private ArgumentCaptor<Name> nameCaptor;
    private GridCell<InformationItemCell.HasNameCell> cell;
    private EditableNameAndDataTypeColumn column;

    @Before
    public void setup() {
        Mockito.when((Object)this.gridWidget.getExpression()).thenReturn(Optional::empty);
        this.cell = new BaseGridCell((GridCellValue)new BaseGridCellValue((Object)InformationItemCell.HasNameAndDataTypeCell.wrap((InformationItem)this.informationItem)));
        this.column = (EditableNameAndDataTypeColumn)Mockito.spy((Object)new EditableNameAndDataTypeColumn<ContextGrid>(this.headerMetaData, 100.0, this.gridWidget, this.isEditable, this.clearValueConsumer, this.setValueConsumer, this.setTypeRefConsumer, this.translationService, this.cellEditorControls, this.editor){

            protected String getPopoverTitle() {
                return EditableNameAndDataTypeColumnTest.POPOVER_TITLE;
            }
        });
        Mockito.when((Object)this.context.getRelativeLocation()).thenReturn(Optional.of(new Point2D(105.0, 210.0)));
        Mockito.when((Object)this.context.getRowIndex()).thenReturn((Object)0);
        Mockito.when((Object)this.context.getColumnIndex()).thenReturn((Object)1);
        Mockito.when((Object)this.context.getAbsoluteCellX()).thenReturn((Object)100.0);
        Mockito.when((Object)this.context.getAbsoluteCellY()).thenReturn((Object)200.0);
        Mockito.when((Object)this.gridWidget.getParentInformation()).thenReturn((Object)new GridCellTuple(0, 0, (GridWidget)this.gridWidget));
        Mockito.when((Object)this.translationService.getTranslation((String)Mockito.any())).thenAnswer(i -> i.getArguments()[0]);
    }

    @Test
    public void testIsMovable() {
        Assertions.assertThat((boolean)this.column.isMovable()).isFalse();
    }

    @Test
    public void testIsResizable() {
        Assertions.assertThat((boolean)this.column.isResizable()).isTrue();
    }

    @Test
    public void testEditWhenRowIsNotEditable() {
        Mockito.when((Object)this.isEditable.test(ArgumentMatchers.anyInt())).thenReturn((Object)false);
        this.column.edit(this.cell, this.context, this.callback);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.editor});
    }

    @Test
    public void testEditWhenRowIsEditable() {
        Mockito.when((Object)this.isEditable.test(ArgumentMatchers.anyInt())).thenReturn((Object)true);
        this.column.edit(this.cell, this.context, this.callback);
        ((ValueAndDataTypePopoverView.Presenter)Mockito.verify((Object)this.editor)).bind((Object)((HasValueAndTypeRef)ArgumentMatchers.any(HasValueAndTypeRef.class)), ArgumentMatchers.eq((int)0), ArgumentMatchers.eq((int)1));
        ((CellEditorControlsView.Presenter)Mockito.verify((Object)this.cellEditorControls)).show((HasCellEditorControls.Editor)ArgumentMatchers.eq((Object)this.editor), ArgumentMatchers.eq((int)105), ArgumentMatchers.eq((int)210));
    }

    @Test
    public void testEditGetters() {
        this.mockEditAction();
        HasValueAndTypeRef hasValueAndTypeRef = (HasValueAndTypeRef)this.hasNameAndDataTypeControlCaptor.getValue();
        hasValueAndTypeRef.getValue();
        ((InformationItem)Mockito.verify((Object)this.informationItem)).getName();
        hasValueAndTypeRef.getTypeRef();
        ((InformationItem)Mockito.verify((Object)this.informationItem)).getTypeRef();
        hasValueAndTypeRef.getHasTypeRefs();
        ((InformationItem)Mockito.verify((Object)this.informationItem)).getHasTypeRefs();
        Assertions.assertThat((Object)hasValueAndTypeRef.asDMNModelInstrumentedBase()).isEqualTo((Object)this.informationItem);
    }

    @Test
    public void testEditSetNameNoChange() {
        this.mockEditAction();
        HasValueAndTypeRef hasValueAndTypeRef = (HasValueAndTypeRef)this.hasNameAndDataTypeControlCaptor.getValue();
        hasValueAndTypeRef.setValue((Object)this.informationItem.getName());
        ((Consumer)Mockito.verify(this.clearValueConsumer, (VerificationMode)Mockito.never())).accept((HasName)ArgumentMatchers.any(HasName.class));
        ((BiConsumer)Mockito.verify(this.setValueConsumer, (VerificationMode)Mockito.never())).accept((HasName)ArgumentMatchers.anyObject(), (Name)ArgumentMatchers.any(Name.class));
    }

    @Test
    public void testEditSetNameChanged() {
        this.mockEditAction();
        HasValueAndTypeRef hasValueAndTypeRef = (HasValueAndTypeRef)this.hasNameAndDataTypeControlCaptor.getValue();
        hasValueAndTypeRef.setValue((Object)new Name(NEW_NAME));
        ((Consumer)Mockito.verify(this.clearValueConsumer, (VerificationMode)Mockito.never())).accept((HasName)ArgumentMatchers.any(HasName.class));
        ((BiConsumer)Mockito.verify(this.setValueConsumer)).accept((HasName)ArgumentMatchers.eq((Object)((InformationItemCell.HasNameCell)this.cell.getValue().getValue())), (Name)this.nameCaptor.capture());
        Assertions.assertThat((String)((Name)this.nameCaptor.getValue()).getValue()).isEqualTo(NEW_NAME);
    }

    @Test
    public void testEditSetNameChangedToEmpty() {
        this.mockEditAction();
        HasValueAndTypeRef hasValueAndTypeRef = (HasValueAndTypeRef)this.hasNameAndDataTypeControlCaptor.getValue();
        hasValueAndTypeRef.setValue(null);
        ((Consumer)Mockito.verify(this.clearValueConsumer)).accept((HasName)ArgumentMatchers.eq((Object)((InformationItemCell.HasNameCell)this.cell.getValue().getValue())));
        ((BiConsumer)Mockito.verify(this.setValueConsumer, (VerificationMode)Mockito.never())).accept((HasName)ArgumentMatchers.anyObject(), (Name)ArgumentMatchers.any(Name.class));
    }

    @Test
    public void testEditSetTypeRefNoChange() {
        this.mockEditAction();
        HasValueAndTypeRef hasValueAndTypeRef = (HasValueAndTypeRef)this.hasNameAndDataTypeControlCaptor.getValue();
        hasValueAndTypeRef.setTypeRef(new QName());
        ((BiConsumer)Mockito.verify(this.setTypeRefConsumer, (VerificationMode)Mockito.never())).accept((HasTypeRef)ArgumentMatchers.anyObject(), (QName)ArgumentMatchers.any(QName.class));
    }

    @Test
    public void testEditSetTypeRefChanged() {
        this.mockEditAction();
        HasValueAndTypeRef hasValueAndTypeRef = (HasValueAndTypeRef)this.hasNameAndDataTypeControlCaptor.getValue();
        QName feel = new QName(DMNModelInstrumentedBase.Namespace.DMN.getUri(), "", DMNModelInstrumentedBase.Namespace.DMN.getPrefix());
        hasValueAndTypeRef.setTypeRef(feel);
        ((BiConsumer)Mockito.verify(this.setTypeRefConsumer)).accept((HasTypeRef)ArgumentMatchers.eq((Object)((InformationItemCell.HasNameAndDataTypeCell)this.cell.getValue().getValue())), (QName)ArgumentMatchers.eq((Object)feel));
    }

    @Test
    public void testDefaultValue() {
        Assertions.assertThat((String)((InformationItemCell.HasNameCell)this.column.makeDefaultCellValue().getValue()).getName().getValue()).isEmpty();
    }

    @Test
    public void testSetWidth() {
        this.column.setWidth(200.0);
        ((EditableNameAndDataTypeColumn)Mockito.verify((Object)this.column)).updateWidthOfPeers();
    }

    @Test
    public void testGetPopoverTitle() {
        this.mockEditAction();
        HasValueAndTypeRef hasValueAndTypeRef = (HasValueAndTypeRef)this.hasNameAndDataTypeControlCaptor.getValue();
        Assertions.assertThat((String)hasValueAndTypeRef.getPopoverTitle()).isEqualTo(POPOVER_TITLE);
    }

    @Test
    public void testToModelValue() {
        this.mockEditAction();
        HasValueAndTypeRef hasValueAndTypeRef = (HasValueAndTypeRef)this.hasNameAndDataTypeControlCaptor.getValue();
        Assertions.assertThat((String)((Name)hasValueAndTypeRef.toModelValue(NAME)).getValue()).isEqualTo(NAME);
    }

    @Test
    public void testToWidgetValue() {
        this.mockEditAction();
        HasValueAndTypeRef hasValueAndTypeRef = (HasValueAndTypeRef)this.hasNameAndDataTypeControlCaptor.getValue();
        Assertions.assertThat((String)hasValueAndTypeRef.toWidgetValue((Object)new Name(NAME))).isEqualTo(NAME);
    }

    @Test
    public void testGetValueLabel() {
        this.mockEditAction();
        HasValueAndTypeRef hasValueAndTypeRef = (HasValueAndTypeRef)this.hasNameAndDataTypeControlCaptor.getValue();
        Assertions.assertThat((String)hasValueAndTypeRef.getValueLabel()).isEqualTo("NameAndDataTypePopover.NameLabel");
    }

    @Test
    public void testNormaliseValue() {
        String value = "   name   ";
        this.mockEditAction();
        HasValueAndTypeRef hasValueAndTypeRef = (HasValueAndTypeRef)this.hasNameAndDataTypeControlCaptor.getValue();
        Assertions.assertThat((String)hasValueAndTypeRef.normaliseValue("   name   ")).isEqualTo(NAME);
    }

    private void mockEditAction() {
        Mockito.when((Object)this.isEditable.test(ArgumentMatchers.anyInt())).thenReturn((Object)true);
        this.column.edit(this.cell, this.context, this.callback);
        ((ValueAndDataTypePopoverView.Presenter)Mockito.verify((Object)this.editor)).bind((Object)((HasValueAndTypeRef)this.hasNameAndDataTypeControlCaptor.capture()), ArgumentMatchers.eq((int)0), ArgumentMatchers.eq((int)1));
    }
}

