/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.widgets.grid.columns.factory.dom;

import com.ait.lienzo.test.LienzoMockitoTestRunner;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.widgets.grid.columns.factory.dom.MonacoEditorWidget;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.views.pfly.monaco.jsinterop.MonacoStandaloneCodeEditor;

@RunWith(value=LienzoMockitoTestRunner.class)
public class MonacoEditorWidgetTest {
    @Mock
    private MonacoStandaloneCodeEditor codeEditor;
    private MonacoEditorWidget widget;

    @Before
    public void setup() {
        this.widget = (MonacoEditorWidget)Mockito.spy((Object)new MonacoEditorWidget());
        this.widget.setCodeEditor(this.codeEditor);
    }

    @Test
    public void testSetValueWhenCodeEditorIsPresent() {
        String value = "value";
        this.widget.setValue("value");
        ((MonacoStandaloneCodeEditor)Mockito.verify((Object)this.codeEditor)).setValue("value");
    }

    @Test
    public void testSetValueWhenCodeEditorIsNotPresent() {
        String value = "value";
        this.widget.setCodeEditor(null);
        this.widget.setValue("value");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.codeEditor});
    }

    @Test
    public void testGetValueWhenCodeEditorIsPresent() {
        String expectedValue = "value";
        Mockito.when((Object)this.codeEditor.getValue()).thenReturn((Object)"value");
        String actualValue = this.widget.getValue();
        Assert.assertEquals((Object)"value", (Object)actualValue);
    }

    @Test
    public void testGetValueWhenCodeEditorIsNotPresent() {
        String expectedValue = "";
        this.widget.setCodeEditor(null);
        Mockito.when((Object)this.widget.getValue()).thenReturn((Object)"");
        String actualValue = this.widget.getValue();
        Assert.assertEquals((Object)"", (Object)actualValue);
    }

    @Test
    public void testSetFocusWhenFocusIsEnabled() {
        this.widget.setFocus(true);
        ((MonacoStandaloneCodeEditor)Mockito.verify((Object)this.codeEditor)).focus();
    }

    @Test
    public void testSetFocusWhenFocusIsNotEnabled() {
        this.widget.setFocus(false);
        ((MonacoStandaloneCodeEditor)Mockito.verify((Object)this.codeEditor, (VerificationMode)Mockito.never())).focus();
    }

    @Test
    public void testSetFocusWhenCodeEditorIsNotPresent() {
        this.widget.setCodeEditor(null);
        this.widget.setFocus(true);
        ((MonacoStandaloneCodeEditor)Mockito.verify((Object)this.codeEditor, (VerificationMode)Mockito.never())).focus();
    }
}

