/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.widgets.grid.model;

import java.util.HashMap;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.kie.workbench.common.dmn.client.widgets.grid.model.HasDynamicHeight;
import org.kie.workbench.common.dmn.client.widgets.grid.model.LiteralExpressionGridRow;
import org.mockito.Mockito;
import org.uberfire.ext.wires.core.grids.client.model.GridCell;
import org.uberfire.ext.wires.core.grids.client.model.GridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridCell;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridCellValue;

public class LiteralExpressionGridRowTest {
    private static final double CELL_HEIGHT = 96.0;

    @Test
    public void testEmptyRow() {
        LiteralExpressionGridRow row = new LiteralExpressionGridRow();
        Assertions.assertThat((double)row.getHeight()).isEqualTo(48.0);
    }

    @Test
    public void testGetHeightWithHasDynamicHeightCell() {
        GridRow row = (GridRow)Mockito.spy((Object)new LiteralExpressionGridRow());
        HashMap<Integer, GridCell> cells = new HashMap<Integer, GridCell>(){
            {
                this.put(0, new MockHasDynamicHeightCell((GridCellValue)new BaseGridCellValue((Object)"cheese")));
                this.put(1, new BaseGridCell((GridCellValue)new BaseGridCellValue((Object)"cheese")));
            }
        };
        ((GridRow)Mockito.doReturn((Object)cells).when((Object)row)).getCells();
        Assertions.assertThat((double)row.getHeight()).isEqualTo(96.0);
    }

    @Test
    public void testGetHeightWithoutHasDynamicHeightCell() {
        GridRow row = (GridRow)Mockito.spy((Object)new LiteralExpressionGridRow());
        HashMap<Integer, GridCell> cells = new HashMap<Integer, GridCell>(){
            {
                this.put(0, new BaseGridCell((GridCellValue)new BaseGridCellValue((Object)"cheese")));
            }
        };
        ((GridRow)Mockito.doReturn((Object)cells).when((Object)row)).getCells();
        Assertions.assertThat((double)row.getHeight()).isEqualTo(48.0);
    }

    private static class MockHasDynamicHeightCell<T>
    extends BaseGridCell<T>
    implements HasDynamicHeight {
        private MockHasDynamicHeightCell(GridCellValue<T> value) {
            super(value);
        }

        public double getHeight() {
            return 96.0;
        }
    }
}

