/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.canvas.controls.selection;

import com.google.gwt.event.dom.client.ContextMenuEvent;
import com.google.gwt.event.dom.client.ContextMenuHandler;
import com.google.gwt.event.dom.client.DomEvent;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.kie.workbench.common.dmn.api.qualifiers.DMNEditor;
import org.kie.workbench.common.dmn.client.editors.drd.DRDContextMenu;
import org.kie.workbench.common.stunner.client.lienzo.canvas.controls.LienzoMultipleSelectionControl;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.controls.SelectionControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.select.MultipleSelection;
import org.kie.workbench.common.stunner.core.client.canvas.event.selection.CanvasClearSelectionEvent;
import org.kie.workbench.common.stunner.core.client.canvas.event.selection.CanvasSelectionEvent;
import org.kie.workbench.common.stunner.core.client.canvas.event.selection.DomainObjectSelectionEvent;
import org.kie.workbench.common.stunner.core.client.canvas.util.CanvasLayoutUtils;
import org.kie.workbench.common.stunner.core.domainobject.DomainObject;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.Bounds;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.uberfire.ext.wires.core.grids.client.util.CoordinateUtilities;

@Dependent
@MultipleSelection
@DMNEditor
public class DomainObjectAwareLienzoMultipleSelectionControl<H extends AbstractCanvasHandler>
extends LienzoMultipleSelectionControl<H> {
    private Optional<DomainObject> selectedDomainObject = Optional.empty();
    private final DRDContextMenu drdContextMenu;
    private HandlerRegistration handlerRegistration;

    @Inject
    public DomainObjectAwareLienzoMultipleSelectionControl(Event<CanvasSelectionEvent> canvasSelectionEvent, Event<CanvasClearSelectionEvent> clearSelectionEvent, DRDContextMenu drdContextMenu) {
        super(canvasSelectionEvent, clearSelectionEvent);
        this.drdContextMenu = drdContextMenu;
    }

    protected void onEnable(H canvasHandler) {
        super.onEnable(canvasHandler);
        this.handlerRegistration = canvasHandler.getAbstractCanvas().getView().asWidget().addDomHandler((EventHandler)((ContextMenuHandler)event -> {
            event.preventDefault();
            event.stopPropagation();
            boolean selectionIsMultiple = this.getSelectedItems().size() > 1;
            boolean aSelectedShapeHasBeenClicked = this.isClickedOnShape(canvasHandler, CoordinateUtilities.getRelativeXOfEvent((DomEvent)event), CoordinateUtilities.getRelativeYOfEvent((DomEvent)event));
            if (selectionIsMultiple && aSelectedShapeHasBeenClicked) {
                this.drdContextMenu.appendContextMenuToTheDOM(event.getNativeEvent().getClientX(), event.getNativeEvent().getClientY());
                this.drdContextMenu.show(this.getSelectedNodes(canvasHandler));
            }
        }), ContextMenuEvent.getType());
    }

    protected boolean isClickedOnShape(H canvasHandler, int canvasX, int canvasY) {
        return this.getSelectedNodesStream(canvasHandler).map(Element::getContent).filter(content -> content instanceof View).anyMatch(view -> {
            Bounds bounds = ((View)view).getBounds();
            return (double)canvasX >= bounds.getUpperLeft().getX() && (double)canvasX <= bounds.getLowerRight().getX() && (double)canvasY >= bounds.getUpperLeft().getY() && (double)canvasY <= bounds.getLowerRight().getY();
        });
    }

    protected List<Node<? extends Definition<?>, Edge>> getSelectedNodes(H canvasHandler) {
        return this.getSelectedNodesStream(canvasHandler).map(Element::asNode).collect(Collectors.toList());
    }

    protected Stream<? extends Element<? extends Definition<?>>> getSelectedNodesStream(H canvasHandler) {
        return this.getSelectedItems().stream().map(uuid -> CanvasLayoutUtils.getElement((AbstractCanvasHandler)canvasHandler, (String)uuid)).filter(element -> element instanceof Node);
    }

    public Optional<Object> getSelectedItemDefinition() {
        if (this.selectedDomainObject.isPresent()) {
            return Optional.of(this.selectedDomainObject.get());
        }
        return super.getSelectedItemDefinition();
    }

    protected void onSelect(Collection<String> uuids) {
        this.selectedDomainObject = Optional.empty();
        super.onSelect(uuids);
    }

    public SelectionControl<H, Element> select(String uuid) {
        this.selectedDomainObject = Optional.empty();
        return super.select(uuid);
    }

    public void clear() {
        this.selectedDomainObject = Optional.empty();
        super.clear();
    }

    protected void onClearSelection() {
        this.selectedDomainObject = Optional.empty();
        super.onClearSelection();
    }

    public void destroy() {
        this.selectedDomainObject = Optional.empty();
        super.destroy();
    }

    protected void onDestroy() {
        this.selectedDomainObject = Optional.empty();
        this.handlerRegistration.removeHandler();
        super.onDestroy();
    }

    protected void handleCanvasElementSelectedEvent(CanvasSelectionEvent event) {
        this.selectedDomainObject = Optional.empty();
        super.handleCanvasElementSelectedEvent(event);
    }

    protected void handleCanvasClearSelectionEvent(CanvasClearSelectionEvent event) {
        this.selectedDomainObject = Optional.empty();
        super.handleCanvasClearSelectionEvent(event);
        super.onClearSelection();
    }

    void handleDomainObjectSelectedEvent(@Observes DomainObjectSelectionEvent event) {
        PortablePreconditions.checkNotNull((String)"event", (Object)event);
        if (Objects.equals(this.getCanvasHandler(), event.getCanvasHandler())) {
            this.selectedDomainObject = Optional.ofNullable(event.getDomainObject());
        }
    }

    private AbstractCanvasHandler getCanvasHandler() {
        return this.getSelectionControl().getCanvasHandler();
    }
}

