/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.canvas.controls.toolbox;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.PreDestroy;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Any;
import javax.inject.Inject;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.kie.workbench.common.dmn.api.definition.model.BusinessKnowledgeModel;
import org.kie.workbench.common.dmn.api.definition.model.Decision;
import org.kie.workbench.common.dmn.api.definition.model.DecisionService;
import org.kie.workbench.common.dmn.api.qualifiers.DMNEditor;
import org.kie.workbench.common.dmn.client.canvas.controls.toolbox.DMNCommonActionsToolbox;
import org.kie.workbench.common.dmn.client.canvas.controls.toolbox.DMNEditBusinessKnowledgeModelToolboxAction;
import org.kie.workbench.common.dmn.client.canvas.controls.toolbox.DMNEditDRDToolboxAction;
import org.kie.workbench.common.dmn.client.canvas.controls.toolbox.DMNEditDecisionToolboxAction;
import org.kie.workbench.common.dmn.client.commands.factory.DefaultCanvasCommandFactory;
import org.kie.workbench.common.stunner.core.client.ReadOnlyProvider;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandFactory;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandManager;
import org.kie.workbench.common.stunner.core.client.components.toolbox.actions.ActionsToolboxView;
import org.kie.workbench.common.stunner.core.client.components.toolbox.actions.CommonActionsToolbox;
import org.kie.workbench.common.stunner.core.client.components.toolbox.actions.CommonActionsToolboxFactory;
import org.kie.workbench.common.stunner.core.client.components.toolbox.actions.DeleteNodeToolboxAction;
import org.kie.workbench.common.stunner.core.client.components.toolbox.actions.ToolboxAction;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;

@Dependent
@DMNCommonActionsToolbox
public class DMNCommonActionsToolboxFactory
extends CommonActionsToolboxFactory {
    private final ManagedInstance<DMNEditDecisionToolboxAction> editDecisionToolboxActions;
    private final ManagedInstance<DMNEditBusinessKnowledgeModelToolboxAction> editBusinessKnowledgeModelToolboxActions;
    private final ManagedInstance<DMNEditDRDToolboxAction> editDRDToolboxActions;
    private final ManagedInstance<ActionsToolboxView> views;
    private final ReadOnlyProvider readOnlyProvider;

    @Inject
    public DMNCommonActionsToolboxFactory(@Any ManagedInstance<DMNEditDecisionToolboxAction> editDecisionToolboxActions, @Any ManagedInstance<DMNEditBusinessKnowledgeModelToolboxAction> editBusinessKnowledgeModelToolboxActions, @Any ManagedInstance<DMNEditDRDToolboxAction> editDRDToolboxActions, @Any @CommonActionsToolbox ManagedInstance<ActionsToolboxView> views, CanvasCommandManager<AbstractCanvasHandler> commandManager, @DMNEditor DefaultCanvasCommandFactory commandFactory, @DMNEditor ManagedInstance<DeleteNodeToolboxAction> deleteNodeActions, ReadOnlyProvider readOnlyProvider) {
        super(commandManager, (CanvasCommandFactory)commandFactory, deleteNodeActions, views);
        this.editDecisionToolboxActions = editDecisionToolboxActions;
        this.editBusinessKnowledgeModelToolboxActions = editBusinessKnowledgeModelToolboxActions;
        this.editDRDToolboxActions = editDRDToolboxActions;
        this.views = views;
        this.readOnlyProvider = readOnlyProvider;
    }

    protected ActionsToolboxView<?> newViewInstance() {
        return (ActionsToolboxView)this.views.get();
    }

    public Collection<ToolboxAction<AbstractCanvasHandler>> getActions(AbstractCanvasHandler canvasHandler, Element<?> element) {
        if (this.readOnlyProvider.isReadOnlyDiagram()) {
            ArrayList<ToolboxAction<AbstractCanvasHandler>> editActions = new ArrayList<ToolboxAction<AbstractCanvasHandler>>();
            this.addEditAction(element, editActions);
            return editActions;
        }
        ArrayList<ToolboxAction<AbstractCanvasHandler>> actions = new ArrayList<ToolboxAction<AbstractCanvasHandler>>(this.superGetActions(canvasHandler, element));
        this.addEditAction(element, actions);
        actions.add((ToolboxAction<AbstractCanvasHandler>)((ToolboxAction)this.editDRDToolboxActions.get()));
        return actions;
    }

    void addEditAction(Element<?> element, List<ToolboxAction<AbstractCanvasHandler>> actions) {
        if (this.isDecision(element)) {
            actions.add((ToolboxAction<AbstractCanvasHandler>)((ToolboxAction)this.editDecisionToolboxActions.get()));
        } else if (this.isBusinessKnowledgeModel(element)) {
            actions.add((ToolboxAction<AbstractCanvasHandler>)((ToolboxAction)this.editBusinessKnowledgeModelToolboxActions.get()));
        }
    }

    Collection<ToolboxAction<AbstractCanvasHandler>> superGetActions(AbstractCanvasHandler canvasHandler, Element<?> element) {
        return super.getActions(canvasHandler, element);
    }

    @PreDestroy
    public void destroy() {
        this.editDecisionToolboxActions.destroyAll();
        this.editBusinessKnowledgeModelToolboxActions.destroyAll();
        this.editDRDToolboxActions.destroyAll();
        this.views.destroyAll();
    }

    private boolean isDecision(Element<?> element) {
        return null != element.asNode() && element.getContent() instanceof Definition && ((Definition)element.getContent()).getDefinition() instanceof Decision;
    }

    private boolean isBusinessKnowledgeModel(Element<?> element) {
        return null != element.asNode() && element.getContent() instanceof Definition && ((Definition)element.getContent()).getDefinition() instanceof BusinessKnowledgeModel;
    }

    protected boolean isAllowed(AbstractCanvasHandler canvasHandler, Node node) {
        Object definition;
        Object content = node.getContent();
        if (content instanceof Definition && (definition = ((Definition)content).getDefinition()) instanceof DecisionService) {
            return true;
        }
        return this.superIsAllowed(canvasHandler, node);
    }

    protected boolean superIsAllowed(AbstractCanvasHandler canvasHandler, Node node) {
        return super.isAllowed(canvasHandler, node);
    }
}

