/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.commands.expressions.types.list;

import java.util.stream.IntStream;
import org.kie.workbench.common.dmn.api.definition.HasExpression;
import org.kie.workbench.common.dmn.api.definition.model.List;
import org.kie.workbench.common.dmn.client.commands.VetoExecutionCommand;
import org.kie.workbench.common.dmn.client.commands.VetoUndoCommand;
import org.kie.workbench.common.dmn.client.commands.util.CommandUtils;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.command.AbstractCanvasCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.AbstractCanvasGraphCommand;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandResultBuilder;
import org.kie.workbench.common.stunner.core.client.command.CanvasViolation;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandExecutionContext;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandResultBuilder;
import org.kie.workbench.common.stunner.core.graph.command.impl.AbstractGraphCommand;
import org.kie.workbench.common.stunner.core.rule.RuleViolation;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;
import org.uberfire.mvp.Command;

public class DeleteListRowCommand
extends AbstractCanvasGraphCommand
implements VetoExecutionCommand,
VetoUndoCommand {
    private final List list;
    private final GridData uiModel;
    private final int uiRowIndex;
    private final Command canvasOperation;
    private final HasExpression oldHasExpression;
    private final GridRow oldUiModelRow;

    public DeleteListRowCommand(List list, GridData uiModel, int uiRowIndex, Command canvasOperation) {
        this.list = list;
        this.uiModel = uiModel;
        this.uiRowIndex = uiRowIndex;
        this.canvasOperation = canvasOperation;
        this.oldHasExpression = (HasExpression)list.getExpression().get(uiRowIndex);
        this.oldUiModelRow = uiModel.getRow(uiRowIndex);
    }

    protected org.kie.workbench.common.stunner.core.command.Command<GraphCommandExecutionContext, RuleViolation> newGraphCommand(AbstractCanvasHandler handler) {
        return new AbstractGraphCommand(){

            protected CommandResult<RuleViolation> check(GraphCommandExecutionContext gce) {
                return GraphCommandResultBuilder.SUCCESS;
            }

            public CommandResult<RuleViolation> execute(GraphCommandExecutionContext gce) {
                DeleteListRowCommand.this.list.getExpression().remove(DeleteListRowCommand.this.uiRowIndex);
                return GraphCommandResultBuilder.SUCCESS;
            }

            public CommandResult<RuleViolation> undo(GraphCommandExecutionContext gce) {
                DeleteListRowCommand.this.list.getExpression().add(DeleteListRowCommand.this.uiRowIndex, DeleteListRowCommand.this.oldHasExpression);
                return GraphCommandResultBuilder.SUCCESS;
            }
        };
    }

    protected org.kie.workbench.common.stunner.core.command.Command<AbstractCanvasHandler, CanvasViolation> newCanvasCommand(AbstractCanvasHandler handler) {
        return new AbstractCanvasCommand(){

            public CommandResult<CanvasViolation> execute(AbstractCanvasHandler handler) {
                DeleteListRowCommand.this.uiModel.deleteRow(DeleteListRowCommand.this.uiRowIndex);
                DeleteListRowCommand.this.updateRowNumbers();
                DeleteListRowCommand.this.updateParentInformation();
                DeleteListRowCommand.this.canvasOperation.execute();
                return CanvasCommandResultBuilder.SUCCESS;
            }

            public CommandResult<CanvasViolation> undo(AbstractCanvasHandler handler) {
                DeleteListRowCommand.this.uiModel.insertRow(DeleteListRowCommand.this.uiRowIndex, DeleteListRowCommand.this.oldUiModelRow);
                DeleteListRowCommand.this.updateRowNumbers();
                DeleteListRowCommand.this.updateParentInformation();
                DeleteListRowCommand.this.canvasOperation.execute();
                return CanvasCommandResultBuilder.SUCCESS;
            }
        };
    }

    public void updateRowNumbers() {
        CommandUtils.updateRowNumbers(this.uiModel, IntStream.range(0, this.uiModel.getRowCount()));
    }

    public void updateParentInformation() {
        CommandUtils.updateParentInformation(this.uiModel);
    }
}

