/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.commands.util;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.ExpressionCellValue;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.ExpressionEditorColumn;
import org.kie.workbench.common.dmn.client.widgets.grid.BaseExpressionGrid;
import org.kie.workbench.common.dmn.client.widgets.grid.model.GridCellTuple;
import org.uberfire.ext.wires.core.grids.client.model.GridCell;
import org.uberfire.ext.wires.core.grids.client.model.GridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridCellValue;
import org.uberfire.ext.wires.core.grids.client.widget.dnd.IsRowDragHandle;

public class CommandUtils {
    public static void updateRowNumbers(GridData uiModel, IntStream rangeOfRowsToUpdate) {
        Optional<GridColumn> rowNumberColumn = uiModel.getColumns().stream().filter(column -> column instanceof IsRowDragHandle).findFirst();
        rowNumberColumn.ifPresent(c -> {
            int columnIndex = uiModel.getColumns().indexOf(c);
            rangeOfRowsToUpdate.forEach(rowIndex -> uiModel.setCellValue(rowIndex, columnIndex, (GridCellValue)new BaseGridCellValue((Object)(rowIndex + 1))));
        });
    }

    public static <T> void moveRows(List<T> allRows, List<T> rowsToMove, int index) {
        int oldBlockStart = allRows.indexOf(rowsToMove.get(0));
        allRows.removeAll(rowsToMove);
        if (index < oldBlockStart) {
            allRows.addAll(index, rowsToMove);
        } else if (index > oldBlockStart) {
            allRows.addAll(index - rowsToMove.size() + 1, rowsToMove);
        }
    }

    public static void moveComponentWidths(int index, int oldIndex, List<Double> componentWidths, List<Integer> uiColumnIndexes) {
        List componentWidthsToMove = uiColumnIndexes.stream().map(componentWidths::get).collect(Collectors.toList());
        uiColumnIndexes.forEach(i -> componentWidths.remove(oldIndex));
        if (index < oldIndex) {
            componentWidths.addAll(index, componentWidthsToMove);
        } else if (index > oldIndex) {
            componentWidths.addAll(oldIndex + 1, componentWidthsToMove);
        }
    }

    public static void updateParentInformation(GridData uiModel) {
        Optional<ExpressionEditorColumn> expressionColumn = uiModel.getColumns().stream().filter(c -> c instanceof ExpressionEditorColumn).map(c -> (ExpressionEditorColumn)((Object)c)).findFirst();
        expressionColumn.ifPresent(c -> {
            int columnIndex = uiModel.getColumns().indexOf(c);
            for (int rowIndex = 0; rowIndex < uiModel.getRowCount(); ++rowIndex) {
                ExpressionCellValue ecv;
                GridCellValue value;
                GridCell cell = uiModel.getCell(rowIndex, columnIndex);
                if (cell == null || !((value = cell.getValue()) instanceof ExpressionCellValue) || !((Optional)(ecv = (ExpressionCellValue)value).getValue()).isPresent()) continue;
                BaseExpressionGrid beg = (BaseExpressionGrid)((Optional)ecv.getValue()).get();
                beg.getParentInformation().setRowIndex(rowIndex);
                beg.getParentInformation().setColumnIndex(columnIndex);
            }
        });
    }

    public static Optional<GridCellValue<?>> extractGridCellValue(GridCellTuple cellTuple) {
        GridCell cell = cellTuple.getGridWidget().getModel().getCell(cellTuple.getRowIndex(), cellTuple.getColumnIndex());
        return Optional.ofNullable(cell == null ? null : cell.getValue());
    }
}

