/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.docks.navigator;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeSet;
import java.util.function.Consumer;
import org.uberfire.mvp.Command;

public class DecisionNavigatorItem
implements Comparable {
    private String uuid;
    private String label;
    private String parentUUID;
    private Type type;
    private Command onClick;
    private boolean isDRG;
    private Consumer<DecisionNavigatorItem> onUpdate;
    private Consumer<DecisionNavigatorItem> onRemove;
    private TreeSet<DecisionNavigatorItem> children = new TreeSet();

    public String getUUID() {
        return this.uuid;
    }

    public String getLabel() {
        return this.label;
    }

    public Type getType() {
        return this.type;
    }

    public TreeSet<DecisionNavigatorItem> getChildren() {
        return this.children;
    }

    public Optional<Command> getOnClick() {
        return Optional.ofNullable(this.onClick);
    }

    public String getParentUUID() {
        return this.parentUUID;
    }

    void setUUID(String uuid) {
        this.uuid = uuid;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    void setType(Type type) {
        this.type = type;
    }

    void setParentUUID(String parentUUID) {
        this.parentUUID = parentUUID;
    }

    void setOnClick(Command onClick) {
        this.onClick = onClick;
    }

    void setOnUpdate(Consumer<DecisionNavigatorItem> onUpdate) {
        this.onUpdate = onUpdate;
    }

    void setOnRemove(Consumer<DecisionNavigatorItem> onRemove) {
        this.onRemove = onRemove;
    }

    void setIsDRG(boolean isDRG) {
        this.isDRG = isDRG;
    }

    public void removeChild(DecisionNavigatorItem item) {
        this.getChildren().removeIf(i -> i.getUUID().equals(item.getUUID()));
    }

    public void addChild(DecisionNavigatorItem item) {
        this.removeChild(item);
        this.getChildren().add(item);
        item.setParentUUID(this.uuid);
    }

    public void onClick() {
        this.getOnClick().ifPresent(Command::execute);
    }

    public void onUpdate() {
        this.getOnUpdate().ifPresent(c -> c.accept(this));
    }

    public void onRemove() {
        this.getOnRemove().ifPresent(c -> c.accept(this));
    }

    public boolean isEditable() {
        return this.getOnUpdate().isPresent() && this.getOnRemove().isPresent() && !this.isDRG();
    }

    private boolean isDRG() {
        return this.isDRG;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DecisionNavigatorItem item = (DecisionNavigatorItem)o;
        return Objects.equals(this.uuid, item.uuid) && Objects.equals(this.label, item.label) && Objects.equals(this.parentUUID, item.parentUUID) && this.type == item.type;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.uuid, this.label, this.type, this.parentUUID});
    }

    public int compareTo(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return 1;
        }
        DecisionNavigatorItem that = (DecisionNavigatorItem)o;
        if (this.equals(that)) {
            return 0;
        }
        return this.getOrderingName().compareTo(that.getOrderingName());
    }

    private String getOrderingName() {
        String orderingLabel = this.getLabel() + this.getUUID();
        return orderingLabel.toLowerCase();
    }

    private Optional<Consumer<DecisionNavigatorItem>> getOnUpdate() {
        return Optional.ofNullable(this.onUpdate);
    }

    private Optional<Consumer<DecisionNavigatorItem>> getOnRemove() {
        return Optional.ofNullable(this.onRemove);
    }

    public static enum Type {
        ROOT("Root"),
        ITEM("Item"),
        CONTEXT("Context"),
        DECISION_TABLE("DecisionTable"),
        FUNCTION_DEFINITION("FunctionDefinition"),
        INVOCATION("Invocation"),
        LIST("List"),
        LITERAL_EXPRESSION("LiteralExpression"),
        RELATION("Relation"),
        TEXT_ANNOTATION("TextAnnotation"),
        BUSINESS_KNOWLEDGE_MODEL("BusinessKnowledgeModel"),
        INPUT_DATA("InputData"),
        DECISION_SERVICE("DecisionService"),
        KNOWLEDGE_SOURCE("KnowledgeSource"),
        DECISION("Decision"),
        SEPARATOR("None");

        private static final Map<String, Type> BY_CLASS_NAME;
        private final String navigatorItemClassName;

        private Type(String navigatorItemClassName) {
            this.navigatorItemClassName = navigatorItemClassName;
        }

        public static Type ofExpressionNodeClassName(String nodeClassName) {
            return BY_CLASS_NAME.getOrDefault(nodeClassName, ITEM);
        }

        static {
            BY_CLASS_NAME = new HashMap<String, Type>();
            for (Type type : Type.values()) {
                BY_CLASS_NAME.put(type.navigatorItemClassName, type);
            }
        }
    }
}

