/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.docks.navigator;

import elemental2.dom.DomGlobal;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.errai.ui.client.local.api.elemental2.IsElement;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.kie.workbench.common.dmn.client.docks.navigator.DecisionNavigatorItem;
import org.kie.workbench.common.dmn.client.docks.navigator.DecisionNavigatorItemsProvider;
import org.kie.workbench.common.dmn.client.docks.navigator.DecisionNavigatorObserver;
import org.kie.workbench.common.dmn.client.docks.navigator.drds.DMNDiagramsSession;
import org.kie.workbench.common.dmn.client.docks.navigator.events.RefreshDecisionComponents;
import org.kie.workbench.common.dmn.client.docks.navigator.included.components.DecisionComponents;
import org.kie.workbench.common.dmn.client.docks.navigator.tree.DecisionNavigatorTreePresenter;
import org.kie.workbench.common.dmn.client.editors.included.common.IncludedModelsContext;
import org.uberfire.client.annotations.DefaultPosition;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.client.mvp.UberElemental;
import org.uberfire.mvp.Command;
import org.uberfire.workbench.model.CompassPosition;
import org.uberfire.workbench.model.Position;

@ApplicationScoped
@WorkbenchScreen(identifier="org.kie.dmn.decision.navigator")
public class DecisionNavigatorPresenter {
    public static final String IDENTIFIER = "org.kie.dmn.decision.navigator";
    static final int DEFER_DELAY = 250;
    private View view;
    private DecisionNavigatorTreePresenter treePresenter;
    private DecisionComponents decisionComponents;
    private DecisionNavigatorObserver decisionNavigatorObserver;
    private TranslationService translationService;
    private IncludedModelsContext includedModelContext;
    private DecisionNavigatorItemsProvider navigatorItemsProvider;
    private DMNDiagramsSession dmnDiagramsSession;
    private boolean isRefreshComponentsViewSuspended;
    double latestDeferred = 0.0;

    @Inject
    public DecisionNavigatorPresenter(View view, DecisionNavigatorTreePresenter treePresenter, DecisionComponents decisionComponents, DecisionNavigatorObserver decisionNavigatorObserver, TranslationService translationService, IncludedModelsContext includedModelContext, DecisionNavigatorItemsProvider navigatorItemsProvider, DMNDiagramsSession dmnDiagramsSession) {
        this.view = view;
        this.treePresenter = treePresenter;
        this.decisionComponents = decisionComponents;
        this.decisionNavigatorObserver = decisionNavigatorObserver;
        this.translationService = translationService;
        this.includedModelContext = includedModelContext;
        this.navigatorItemsProvider = navigatorItemsProvider;
        this.dmnDiagramsSession = dmnDiagramsSession;
    }

    @WorkbenchPartView
    public View getView() {
        return this.view;
    }

    @WorkbenchPartTitle
    public String getTitle() {
        return this.translationService.format("DecisionNavigatorPresenter.DecisionNavigator", new Object[0]);
    }

    @DefaultPosition
    public Position getDefaultPosition() {
        return CompassPosition.WEST;
    }

    @PostConstruct
    void setup() {
        this.initialize();
        this.setupView();
        this.refreshComponentsView();
    }

    public void onRefreshDecisionComponents(@Observes RefreshDecisionComponents events) {
        if (!this.isRefreshComponentsViewSuspended) {
            this.refreshComponentsView();
        }
    }

    public DecisionNavigatorTreePresenter getTreePresenter() {
        return this.treePresenter;
    }

    public void removeAllElements() {
        this.treePresenter.removeAllItems();
        this.decisionComponents.removeAllItems();
    }

    void initialize() {
        this.view.init(this);
        this.decisionNavigatorObserver.init(this);
    }

    void setupView() {
        this.view.setupMainTree(this.treePresenter.getView());
        if (this.includedModelContext.isIncludedModelChannel()) {
            this.view.showDecisionComponentsContainer();
            this.view.setupDecisionComponents(this.decisionComponents.getView());
        } else {
            this.view.hideDecisionComponentsContainer();
        }
    }

    public void refresh() {
        this.deferredRefresh();
    }

    public void refreshTreeView() {
        this.treePresenter.setupItems(this.getItems());
    }

    public void refreshComponentsView() {
        this.decisionComponents.refresh();
    }

    List<DecisionNavigatorItem> getItems() {
        return this.navigatorItemsProvider.getItems();
    }

    public void clearSelections() {
        this.getTreePresenter().deselectItem();
    }

    void deferredRefresh() {
        if (this.dmnDiagramsSession.isSessionStatePresent()) {
            this.defer(() -> {
                this.refreshTreeView();
                this.refreshComponentsView();
            });
        }
    }

    void defer(Command cmd) {
        this.clearTimeout(this.latestDeferred);
        this.latestDeferred = this.setTimeout(e -> cmd.execute(), 250);
    }

    double setTimeout(DomGlobal.SetTimeoutCallbackFn callbackFn, int delay) {
        return DomGlobal.setTimeout((DomGlobal.SetTimeoutCallbackFn)callbackFn, (double)delay, (Object[])new Object[0]);
    }

    public void setIsRefreshComponentsViewSuspended(boolean isRefreshComponentsViewSuspended) {
        this.isRefreshComponentsViewSuspended = isRefreshComponentsViewSuspended;
    }

    void clearTimeout(double latestDeferred) {
        DomGlobal.clearTimeout((double)latestDeferred);
    }

    public static interface View
    extends UberElemental<DecisionNavigatorPresenter>,
    IsElement {
        public void setupMainTree(DecisionNavigatorTreePresenter.View var1);

        public void setupDecisionComponents(DecisionComponents.View var1);

        public void showDecisionComponentsContainer();

        public void hideDecisionComponentsContainer();
    }
}

