/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.docks.navigator.factories;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.kie.workbench.common.dmn.api.definition.model.DMNDiagram;
import org.kie.workbench.common.dmn.api.definition.model.DMNDiagramElement;
import org.kie.workbench.common.dmn.api.definition.model.Definitions;
import org.kie.workbench.common.dmn.client.docks.navigator.DecisionNavigatorItem;
import org.kie.workbench.common.dmn.client.docks.navigator.DecisionNavigatorItemBuilder;
import org.kie.workbench.common.dmn.client.docks.navigator.drds.DMNDiagramSelected;
import org.kie.workbench.common.dmn.client.docks.navigator.drds.DMNDiagramTuple;
import org.kie.workbench.common.dmn.client.docks.navigator.drds.DMNDiagramsSession;
import org.kie.workbench.common.dmn.client.docks.navigator.drds.DRGDiagramUtils;
import org.kie.workbench.common.dmn.client.docks.navigator.factories.DecisionNavigatorBaseItemFactory;
import org.kie.workbench.common.dmn.client.marshaller.common.DMNGraphUtils;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.util.DefinitionUtils;
import org.kie.workbench.common.stunner.core.util.UUID;
import org.uberfire.mvp.Command;

@Dependent
public class DecisionNavigatorItemFactory {
    private final DecisionNavigatorBaseItemFactory baseItemFactory;
    private final Event<DMNDiagramSelected> selectedEvent;
    private final DMNDiagramsSession dmnDiagramsSession;

    @Inject
    public DecisionNavigatorItemFactory(DecisionNavigatorBaseItemFactory baseItemFactory, Event<DMNDiagramSelected> selectedEvent, DMNDiagramsSession dmnDiagramsSession) {
        this.baseItemFactory = baseItemFactory;
        this.selectedEvent = selectedEvent;
        this.dmnDiagramsSession = dmnDiagramsSession;
    }

    public DecisionNavigatorItem makeItem(Node<View, Edge> node) {
        String nodeClassName = Optional.ofNullable(DefinitionUtils.getElementDefinition(node)).map(elementDefinition -> elementDefinition.getClass().getSimpleName()).orElse(Node.class.getSimpleName());
        return this.baseItemFactory.makeItem(node, DecisionNavigatorItem.Type.ofExpressionNodeClassName(nodeClassName));
    }

    public DecisionNavigatorItem makeRoot(DMNDiagramTuple diagramTuple) {
        String label;
        DMNDiagramElement dmnDiagramElement = diagramTuple.getDMNDiagram();
        String uuid = dmnDiagramElement.getId().getValue();
        String diagramName = dmnDiagramElement.getName().getValue();
        boolean isDRG = DRGDiagramUtils.isDRG(dmnDiagramElement);
        if (isDRG) {
            Graph graph = diagramTuple.getStunnerDiagram().getGraph();
            Node rootNode = this.getRootNode(graph);
            label = this.getNodeName(rootNode);
        } else {
            label = diagramName;
        }
        return this.navigatorItemBuilder().withUUID(uuid).withLabel(label).withType(DecisionNavigatorItem.Type.ROOT).withIsDRG(isDRG).withOnClick(this.getOnClickAction(dmnDiagramElement)).withOnUpdate(this.getOnUpdate(dmnDiagramElement)).withOnRemove(this.getOnRemove(dmnDiagramElement)).build();
    }

    Command getOnClickAction(DMNDiagramElement dmnDiagramElement) {
        return () -> this.selectedEvent.fire((Object)new DMNDiagramSelected(dmnDiagramElement));
    }

    Consumer<DecisionNavigatorItem> getOnUpdate(DMNDiagramElement dmnDiagramElement) {
        return item -> {
            dmnDiagramElement.getName().setValue(item.getLabel());
            this.selectedEvent.fire((Object)new DMNDiagramSelected(dmnDiagramElement));
        };
    }

    Consumer<DecisionNavigatorItem> getOnRemove(DMNDiagramElement dmnDiagramElement) {
        return item -> {
            this.removeFromModel(dmnDiagramElement);
            this.removeFromSession(dmnDiagramElement);
            this.selectedEvent.fire((Object)new DMNDiagramSelected(this.dmnDiagramsSession.getDRGDiagramElement()));
        };
    }

    private void removeFromSession(DMNDiagramElement dmnDiagramElement) {
        this.dmnDiagramsSession.remove(dmnDiagramElement);
    }

    private void removeFromModel(DMNDiagramElement dmnDiagramElement) {
        Graph graph = this.dmnDiagramsSession.getDRGDiagram().getGraph();
        Node<?, ?> dmnDiagramRoot = DMNGraphUtils.findDMNDiagramRoot(graph);
        Definitions definitions = ((DMNDiagram)DefinitionUtils.getElementDefinition(dmnDiagramRoot)).getDefinitions();
        definitions.getDiagramElements().removeIf(e -> {
            String diagramId = e.getId().getValue();
            String removedDiagramId = dmnDiagramElement.getId().getValue();
            return Objects.equals(diagramId, removedDiagramId);
        });
    }

    public DecisionNavigatorItem makeSeparator(String label) {
        return this.navigatorItemBuilder().withUUID(UUID.uuid()).withLabel(label).withType(DecisionNavigatorItem.Type.SEPARATOR).build();
    }

    private Node getRootNode(Graph graph) {
        return DMNGraphUtils.findDMNDiagramRoot(graph);
    }

    private String getNodeName(Node<?, ?> rootNode) {
        return this.baseItemFactory.getLabel((Element<View>)rootNode);
    }

    private DecisionNavigatorItemBuilder navigatorItemBuilder() {
        return new DecisionNavigatorItemBuilder();
    }
}

