/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.common.messages;

import com.google.gwt.event.dom.client.ClickEvent;
import elemental2.dom.DomGlobal;
import elemental2.dom.Element;
import elemental2.dom.HTMLButtonElement;
import elemental2.dom.HTMLDivElement;
import elemental2.dom.HTMLElement;
import elemental2.dom.NodeList;
import java.util.Optional;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import javax.inject.Named;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.dmn.client.editors.common.messages.FlashMessages;

@Templated
@Dependent
public class FlashMessagesView
implements FlashMessages.View {
    static final String ERROR_CSS_CLASS = "kie-flash-message-error-element";
    static final String WARNING_CSS_CLASS = "kie-flash-message-warning-element";
    static final String OPENED_CONTAINER_CSS_CLASS = "opened";
    @DataField(value="error-container")
    private final HTMLDivElement errorContainer;
    @DataField(value="warning-container")
    private final HTMLDivElement warningContainer;
    @DataField(value="success-container")
    private final HTMLDivElement successContainer;
    @DataField(value="strong-error-message")
    private final HTMLElement strongErrorMessage;
    @DataField(value="regular-error-message")
    private final HTMLElement regularErrorMessage;
    @DataField(value="strong-warning-message")
    private final HTMLElement strongWarningMessage;
    @DataField(value="regular-warning-message")
    private final HTMLElement regularWarningMessage;
    @DataField(value="strong-success-message")
    private final HTMLElement strongSuccessMessage;
    @DataField(value="regular-success-message")
    private final HTMLElement regularSuccessMessage;
    @DataField(value="ok-warning-button")
    private final HTMLButtonElement okWarningButton;
    @DataField(value="cancel-warning-button")
    private final HTMLButtonElement cancelWarningButton;
    @DataField(value="close-success-message-button")
    private final HTMLButtonElement closeSuccessButton;
    private FlashMessages presenter;

    @Inject
    public FlashMessagesView(HTMLDivElement errorContainer, HTMLDivElement warningContainer, @Named(value="strong") HTMLElement strongErrorMessage, @Named(value="span") HTMLElement regularErrorMessage, @Named(value="strong") HTMLElement strongWarningMessage, @Named(value="span") HTMLElement regularWarningMessage, HTMLButtonElement okWarningButton, HTMLButtonElement cancelWarningButton, HTMLButtonElement closeSuccessButton, HTMLDivElement successContainer, @Named(value="strong") HTMLElement strongSuccessMessage, @Named(value="span") HTMLElement regularSuccessMessage) {
        this.errorContainer = errorContainer;
        this.warningContainer = warningContainer;
        this.strongErrorMessage = strongErrorMessage;
        this.regularErrorMessage = regularErrorMessage;
        this.strongWarningMessage = strongWarningMessage;
        this.regularWarningMessage = regularWarningMessage;
        this.okWarningButton = okWarningButton;
        this.cancelWarningButton = cancelWarningButton;
        this.closeSuccessButton = closeSuccessButton;
        this.successContainer = successContainer;
        this.strongSuccessMessage = strongSuccessMessage;
        this.regularSuccessMessage = regularSuccessMessage;
    }

    public void init(FlashMessages presenter) {
        this.presenter = presenter;
    }

    @EventHandler(value={"close-success-message-button"})
    public void onCloseSuccessButtonClick(ClickEvent e) {
        this.hideSuccessContainer();
    }

    @EventHandler(value={"ok-warning-button"})
    public void onOkWarningButtonClick(ClickEvent e) {
        this.presenter.executeSuccessWarningCallback();
        this.hideWarningContainer();
        this.disableWarningHighlight();
    }

    @EventHandler(value={"cancel-warning-button"})
    public void onCancelWarningButtonClick(ClickEvent e) {
        this.presenter.executeErrorWarningCallback();
        this.hideWarningContainer();
        this.disableWarningHighlight();
    }

    @Override
    public void showErrorMessage(String strongMessage, String regularMessage) {
        this.show((Element)this.errorContainer);
        this.strongErrorMessage.textContent = strongMessage;
        this.regularErrorMessage.textContent = regularMessage;
    }

    @Override
    public void showWarningMessage(String strongMessage, String regularMessage) {
        this.show((Element)this.warningContainer);
        this.strongWarningMessage.textContent = strongMessage;
        this.regularWarningMessage.textContent = regularMessage;
    }

    @Override
    public void showSuccessMessage(String strongMessage, String regularMessage) {
        this.show((Element)this.successContainer);
        this.strongSuccessMessage.textContent = strongMessage;
        this.regularSuccessMessage.textContent = regularMessage;
    }

    @Override
    public void showErrorHighlight(String errorElementSelector) {
        this.querySelector(errorElementSelector).ifPresent(element -> {
            this.enableErrorHighlight((Element)element);
            this.setupDisableErrorHighlightCallbacks((Element)element);
            element.focus();
        });
    }

    @Override
    public void showWarningHighlight(String warningElementSelector) {
        this.disableWarningHighlight();
        this.querySelector(warningElementSelector).ifPresent(this::enableWarningHighlight);
    }

    @Override
    public boolean isElementPresent(String elementSelector) {
        return this.querySelector(elementSelector).isPresent();
    }

    private Optional<Element> querySelector(String selector) {
        return Optional.ofNullable(this.getElement().parentNode).map(node -> node.querySelector(selector));
    }

    @Override
    public void hideWarningContainer() {
        this.hide((Element)this.warningContainer);
    }

    @Override
    public void hideSuccessContainer() {
        this.hide((Element)this.successContainer);
    }

    @Override
    public void hideErrorContainer() {
        this.hide((Element)this.errorContainer);
    }

    void setupDisableErrorHighlightCallbacks(Element element) {
        element.onkeypress = e -> {
            this.disableErrorHighlight(element);
            return true;
        };
        element.onblur = e -> {
            this.disableErrorHighlight(element);
            return true;
        };
    }

    void enableErrorHighlight(Element element) {
        element.classList.add(new String[]{ERROR_CSS_CLASS});
    }

    void enableWarningHighlight(Element element) {
        element.classList.add(new String[]{WARNING_CSS_CLASS});
    }

    void disableWarningHighlight() {
        NodeList warningElements = this.getElement().parentNode.querySelectorAll(".kie-flash-message-warning-element");
        for (int i = 0; i < warningElements.length; ++i) {
            ((Element)warningElements.getAt((int)i)).classList.remove(new String[]{WARNING_CSS_CLASS});
        }
    }

    void disableErrorHighlight(Element element) {
        element.classList.remove(new String[]{ERROR_CSS_CLASS});
        this.setTimeout(type -> {
            boolean isErrorEnabled = element.classList.contains(ERROR_CSS_CLASS);
            if (!isErrorEnabled) {
                this.hideErrorContainer();
                this.teardownDisableErrorHighlightCallbacks(element);
            }
        }, 500.0);
    }

    void teardownDisableErrorHighlightCallbacks(Element element) {
        element.onkeypress = e -> true;
        element.onblur = e -> true;
    }

    void setTimeout(DomGlobal.SetTimeoutCallbackFn callback, double delay) {
        DomGlobal.setTimeout((DomGlobal.SetTimeoutCallbackFn)callback, (double)delay, (Object[])new Object[0]);
    }

    private void hide(Element element) {
        element.classList.remove(new String[]{OPENED_CONTAINER_CSS_CLASS});
    }

    private void show(Element element) {
        element.classList.add(new String[]{OPENED_CONTAINER_CSS_CLASS});
    }
}

