/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.documentation.common;

import com.google.gwt.core.client.GWT;
import java.util.Optional;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.kie.workbench.common.dmn.client.editors.documentation.common.DMNDocumentation;
import org.kie.workbench.common.dmn.client.editors.documentation.common.DMNDocumentationFactory;
import org.kie.workbench.common.dmn.client.editors.documentation.common.DMNDocumentationService;
import org.kie.workbench.common.dmn.client.editors.documentation.template.DMNDocumentationTemplateSource;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.documentation.model.DocumentationOutput;
import org.kie.workbench.common.stunner.core.documentation.model.HTMLDocumentationTemplate;
import org.uberfire.ext.editor.commons.client.template.mustache.ClientMustacheTemplateRenderer;

@Dependent
public class DMNDocumentationServiceImpl
implements DMNDocumentationService {
    private final ClientMustacheTemplateRenderer mustacheTemplateRenderer;
    private final DMNDocumentationFactory dmnDocumentationFactory;

    @Inject
    public DMNDocumentationServiceImpl(ClientMustacheTemplateRenderer mustacheTemplateRenderer, DMNDocumentationFactory dmnDocumentationFactory) {
        this.mustacheTemplateRenderer = mustacheTemplateRenderer;
        this.dmnDocumentationFactory = dmnDocumentationFactory;
    }

    public DMNDocumentation processDocumentation(Diagram diagram) {
        return this.dmnDocumentationFactory.create(diagram);
    }

    public HTMLDocumentationTemplate getDocumentationTemplate() {
        DMNDocumentationTemplateSource source = (DMNDocumentationTemplateSource)GWT.create(DMNDocumentationTemplateSource.class);
        return new HTMLDocumentationTemplate(source.documentationTemplate().getText());
    }

    public DocumentationOutput buildDocumentation(HTMLDocumentationTemplate template, DMNDocumentation diagramDocumentation) {
        String rendered = this.mustacheTemplateRenderer.render(template.getTemplate(), (Object)diagramDocumentation);
        return new DocumentationOutput(rendered);
    }

    public DocumentationOutput generate(Diagram diagram) {
        return Optional.ofNullable(diagram).map(this::processDocumentation).map(dmnDocumentation -> this.buildDocumentation(this.getDocumentationTemplate(), (DMNDocumentation)dmnDocumentation)).orElse(DocumentationOutput.EMPTY);
    }
}

