/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.drd;

import elemental2.dom.DomGlobal;
import elemental2.dom.HTMLElement;
import elemental2.dom.Node;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.kie.workbench.common.dmn.api.property.dmn.Id;
import org.kie.workbench.common.dmn.client.docks.navigator.drds.DMNDiagramTuple;
import org.kie.workbench.common.dmn.client.docks.navigator.drds.DMNDiagramsSession;
import org.kie.workbench.common.dmn.client.editors.contextmenu.ContextMenu;
import org.kie.workbench.common.dmn.client.editors.drd.DRDContextMenuService;
import org.kie.workbench.common.stunner.core.client.i18n.ClientTranslationService;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;

@ApplicationScoped
public class DRDContextMenu {
    static final String DRDACTIONS_CONTEXT_MENU_TITLE = "DRDActions.ContextMenu.Title";
    static final String DRDACTIONS_CONTEXT_MENU_ACTIONS_CREATE = "DRDActions.ContextMenu.Actions.Create";
    static final String DRDACTIONS_CONTEXT_MENU_ACTIONS_ADD_TO = "DRDActions.ContextMenu.Actions.AddTo";
    static final String DRDACTIONS_CONTEXT_MENU_ACTIONS_REMOVE = "DRDActions.ContextMenu.Actions.Remove";
    static final String HEADER_MENU_ICON_CLASS = "fa fa-share-alt";
    private final ClientTranslationService translationService;
    private final ContextMenu contextMenu;
    private final DRDContextMenuService drdContextMenuService;
    private final DMNDiagramsSession dmnDiagramsSession;

    @Inject
    public DRDContextMenu(ContextMenu contextMenu, ClientTranslationService translationService, DRDContextMenuService drdContextMenuService, DMNDiagramsSession dmnDiagramsSession) {
        this.contextMenu = contextMenu;
        this.translationService = translationService;
        this.drdContextMenuService = drdContextMenuService;
        this.dmnDiagramsSession = dmnDiagramsSession;
    }

    public String getTitle() {
        return this.translationService.getValue(DRDACTIONS_CONTEXT_MENU_TITLE);
    }

    public void appendContextMenuToTheDOM(double x, double y) {
        HTMLElement contextMenuElement = this.contextMenu.getElement();
        contextMenuElement.style.position = "absolute";
        contextMenuElement.style.left = x + "px";
        contextMenuElement.style.top = y + "px";
        DomGlobal.document.body.appendChild((Node)contextMenuElement);
    }

    public void show(Collection<org.kie.workbench.common.stunner.core.graph.Node<? extends Definition<?>, Edge>> selectedNodes) {
        this.contextMenu.show((ContextMenu self) -> this.setDRDContextMenuHandler((ContextMenu)self, selectedNodes));
    }

    protected void setDRDContextMenuHandler(ContextMenu contextMenu, Collection<org.kie.workbench.common.stunner.core.graph.Node<? extends Definition<?>, Edge>> selectedNodes) {
        contextMenu.hide();
        contextMenu.setHeaderMenu(this.translationService.getValue(DRDACTIONS_CONTEXT_MENU_TITLE).toUpperCase(), HEADER_MENU_ICON_CLASS);
        contextMenu.addTextMenuItem(this.translationService.getValue(DRDACTIONS_CONTEXT_MENU_ACTIONS_CREATE), true, () -> this.drdContextMenuService.addToNewDRD(selectedNodes));
        this.getDiagrams().stream().filter(this.excludeGlobalGraphPredicate()).filter(this.excludeCurrentDRDPredicate()).forEach(dmnDiagram -> contextMenu.addTextMenuItem(this.translationService.getValue(DRDACTIONS_CONTEXT_MENU_ACTIONS_ADD_TO) + " " + this.getDiagramName((DMNDiagramTuple)dmnDiagram), true, () -> this.drdContextMenuService.addToExistingDRD((DMNDiagramTuple)dmnDiagram, selectedNodes)));
        if (!this.dmnDiagramsSession.isGlobalGraphSelected()) {
            contextMenu.addTextMenuItem(this.translationService.getValue(DRDACTIONS_CONTEXT_MENU_ACTIONS_REMOVE), true, () -> this.drdContextMenuService.removeFromCurrentDRD(selectedNodes));
        }
    }

    private Predicate<DMNDiagramTuple> excludeCurrentDRDPredicate() {
        return dmnDiagramTuple -> {
            Id dmnDiagramId = dmnDiagramTuple.getDMNDiagram().getId();
            return this.dmnDiagramsSession.getCurrentDMNDiagramElement().map(dmnDiagramElement -> !dmnDiagramId.equals((Object)dmnDiagramElement.getId())).orElse(false);
        };
    }

    private Predicate<DMNDiagramTuple> excludeGlobalGraphPredicate() {
        return dmnDiagramTuple -> {
            Id dmnDiagramId = dmnDiagramTuple.getDMNDiagram().getId();
            return !dmnDiagramId.equals((Object)this.dmnDiagramsSession.getDRGDiagramElement().getId());
        };
    }

    private String getDiagramName(DMNDiagramTuple dmnDiagram) {
        return dmnDiagram.getDMNDiagram().getName().getValue();
    }

    private List<DMNDiagramTuple> getDiagrams() {
        return this.drdContextMenuService.getDiagrams();
    }

    public HTMLElement getElement() {
        return this.contextMenu.getElement();
    }
}

