/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.drd;

import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.kie.workbench.common.dmn.api.DMNDefinitionSet;
import org.kie.workbench.common.dmn.api.definition.HasName;
import org.kie.workbench.common.dmn.api.definition.HasText;
import org.kie.workbench.common.dmn.api.definition.model.DMNDiagram;
import org.kie.workbench.common.dmn.api.definition.model.DMNDiagramElement;
import org.kie.workbench.common.dmn.api.definition.model.DMNModelInstrumentedBase;
import org.kie.workbench.common.dmn.api.definition.model.Definitions;
import org.kie.workbench.common.dmn.api.graph.DMNDiagramUtils;
import org.kie.workbench.common.dmn.client.commands.clone.DMNDeepCloneProcess;
import org.kie.workbench.common.dmn.client.docks.navigator.drds.DMNDiagramSelected;
import org.kie.workbench.common.dmn.client.docks.navigator.drds.DMNDiagramTuple;
import org.kie.workbench.common.dmn.client.docks.navigator.drds.DMNDiagramsSession;
import org.kie.workbench.common.dmn.client.marshaller.common.DMNGraphUtils;
import org.kie.workbench.common.dmn.client.marshaller.unmarshall.DMNUnmarshaller;
import org.kie.workbench.common.stunner.core.api.FactoryManager;
import org.kie.workbench.common.stunner.core.definition.adapter.binding.BindableAdapterUtils;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.Bound;
import org.kie.workbench.common.stunner.core.graph.content.Bounds;
import org.kie.workbench.common.stunner.core.graph.content.HasContentDefinitionId;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;
import org.kie.workbench.common.stunner.core.graph.content.relationship.Child;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.graph.impl.EdgeImpl;
import org.kie.workbench.common.stunner.core.util.UUID;

@ApplicationScoped
public class DRDContextMenuService {
    private static String NEW_DIAGRAM_NAME = "new-diagram";
    private final DMNDiagramsSession dmnDiagramsSession;
    private final FactoryManager factoryManager;
    private final Event<DMNDiagramSelected> selectedEvent;
    private final DMNDiagramUtils dmnDiagramUtils;
    private final DMNDeepCloneProcess dmnDeepCloneProcess;
    private final DMNUnmarshaller dmnUnmarshaller;

    @Inject
    public DRDContextMenuService(DMNDiagramsSession dmnDiagramsSession, FactoryManager factoryManager, Event<DMNDiagramSelected> selectedEvent, DMNDiagramUtils dmnDiagramUtils, DMNDeepCloneProcess dmnDeepCloneProcess, DMNUnmarshaller dmnUnmarshaller) {
        this.dmnDiagramsSession = dmnDiagramsSession;
        this.factoryManager = factoryManager;
        this.selectedEvent = selectedEvent;
        this.dmnDiagramUtils = dmnDiagramUtils;
        this.dmnDeepCloneProcess = dmnDeepCloneProcess;
        this.dmnUnmarshaller = dmnUnmarshaller;
    }

    public List<DMNDiagramTuple> getDiagrams() {
        return this.dmnDiagramsSession.getDMNDiagrams();
    }

    public void addToNewDRD(Collection<Node<? extends Definition<?>, Edge>> selectedNodes) {
        DMNDiagramElement dmnElement = this.makeDmnDiagramElement();
        Diagram stunnerElement = this.buildStunnerElement(dmnElement);
        selectedNodes.forEach(this.addNodesToDRD(dmnElement, stunnerElement));
        this.addDmnDiagramElementToDRG(dmnElement);
        this.dmnDiagramsSession.add(dmnElement, stunnerElement);
        this.selectedEvent.fire((Object)new DMNDiagramSelected(dmnElement));
    }

    public void addToExistingDRD(DMNDiagramTuple dmnDiagram, Collection<Node<? extends Definition<?>, Edge>> selectedNodes) {
        selectedNodes.forEach(this.addNodesToDRD(dmnDiagram.getDMNDiagram(), dmnDiagram.getStunnerDiagram()));
        this.selectedEvent.fire((Object)new DMNDiagramSelected(dmnDiagram.getDMNDiagram()));
    }

    private Consumer<Node<? extends Definition<?>, Edge>> addNodesToDRD(DMNDiagramElement dmnElement, Diagram stunnerElement) {
        return node -> {
            Definition content = (Definition)node.getContent();
            Object definition = ((View)content).getDefinition();
            if (definition instanceof HasContentDefinitionId) {
                Node<?, ?> dmnDiagramRoot = DMNGraphUtils.findDMNDiagramRoot(stunnerElement.getGraph());
                Node clone = this.cloneNode((Node)node, dmnElement);
                this.connectRootWithChild(dmnDiagramRoot, clone);
                stunnerElement.getGraph().addNode(clone);
            }
        };
    }

    private void connectRootWithChild(Node dmnDiagramRoot, Node child) {
        String uuid = UUID.uuid();
        EdgeImpl edge = new EdgeImpl(uuid);
        edge.setContent((Object)new Child());
        this.connectEdge((Edge)edge, dmnDiagramRoot, child);
        Definitions definitions = ((DMNDiagram)((View)dmnDiagramRoot.getContent()).getDefinition()).getDefinitions();
        DMNModelInstrumentedBase childDRG = (DMNModelInstrumentedBase)((View)child.getContent()).getDefinition();
        childDRG.setParent((DMNModelInstrumentedBase)definitions);
    }

    private void connectEdge(Edge edge, Node source, Node target) {
        edge.setSourceNode(source);
        edge.setTargetNode(target);
        source.getOutEdges().add(edge);
        target.getInEdges().add(edge);
    }

    private Node cloneNode(Node nodeToClone, DMNDiagramElement dmnElement) {
        View content = (View)nodeToClone.getContent();
        Bounds bounds = content.getBounds();
        Object definition = content.getDefinition();
        Node clonedNode = this.factoryManager.newElement(UUID.uuid(), BindableAdapterUtils.getDefinitionId(definition.getClass())).asNode();
        View clonedContent = (View)clonedNode.getContent();
        clonedContent.setDefinition((Object)this.cloneDefinition(dmnElement, definition));
        clonedContent.setBounds(this.cloneBounds(bounds));
        return clonedNode;
    }

    private HasContentDefinitionId cloneDefinition(DMNDiagramElement dmnElement, Object definition) {
        HasContentDefinitionId originalDefinition = (HasContentDefinitionId)definition;
        HasContentDefinitionId clonedDefinition = (HasContentDefinitionId)this.dmnDeepCloneProcess.clone(originalDefinition);
        clonedDefinition.setContentDefinitionId(originalDefinition.getContentDefinitionId());
        clonedDefinition.setDiagramId(dmnElement.getId().getValue());
        if (definition instanceof HasText && clonedDefinition instanceof HasText) {
            HasText hasText = (HasText)definition;
            ((HasText)clonedDefinition).setText(hasText.getText());
        }
        if (definition instanceof HasName && clonedDefinition instanceof HasName) {
            HasName hasName = (HasName)definition;
            ((HasName)clonedDefinition).setName(hasName.getValue());
        }
        return clonedDefinition;
    }

    private Bounds cloneBounds(Bounds bounds) {
        Bound ul = bounds.getUpperLeft();
        Bound lr = bounds.getLowerRight();
        return Bounds.create((double)ul.getX(), (double)ul.getY(), (double)lr.getX(), (double)lr.getY());
    }

    public void removeFromCurrentDRD(Collection<Node<? extends Definition<?>, Edge>> selectedNodes) {
        Diagram diagram = this.dmnDiagramsSession.getCurrentDiagram().orElse(this.dmnDiagramsSession.getDRGDiagram());
        selectedNodes.forEach(node -> diagram.getGraph().removeNode(node.getUUID()));
        this.dmnDiagramsSession.getCurrentDMNDiagramElement().ifPresent(dmnDiagramElement -> this.selectedEvent.fire((Object)new DMNDiagramSelected((DMNDiagramElement)dmnDiagramElement)));
    }

    private void addDmnDiagramElementToDRG(DMNDiagramElement dmnElement) {
        this.dmnDiagramUtils.getDefinitions(this.dmnDiagramsSession.getDRGDiagram()).getDiagramElements().add(dmnElement);
    }

    private Diagram buildStunnerElement(DMNDiagramElement dmnElement) {
        String diagramId = dmnElement.getId().getValue();
        return this.factoryManager.newDiagram(diagramId, BindableAdapterUtils.getDefinitionSetId(DMNDefinitionSet.class), this.getMetadata());
    }

    private DMNDiagramElement makeDmnDiagramElement() {
        DMNDiagramElement diagramElement = new DMNDiagramElement();
        diagramElement.getName().setValue(this.getUniqueName());
        return diagramElement;
    }

    private String getUniqueName() {
        List<String> currentDiagramNames = this.getCurrentDiagramNames();
        if (currentDiagramNames.contains(NEW_DIAGRAM_NAME)) {
            return this.getUniqueName(2, currentDiagramNames);
        }
        return NEW_DIAGRAM_NAME;
    }

    private List<String> getCurrentDiagramNames() {
        return this.dmnDiagramsSession.getDMNDiagrams().stream().map(e -> e.getDMNDiagram().getName().getValue()).collect(Collectors.toList());
    }

    private String getUniqueName(int seeds, List<String> currentDiagramNames) {
        String newDiagramName = NEW_DIAGRAM_NAME + "-" + seeds;
        if (currentDiagramNames.contains(newDiagramName)) {
            return this.getUniqueName(seeds + 1, currentDiagramNames);
        }
        return newDiagramName;
    }

    private Metadata getMetadata() {
        return this.dmnDiagramsSession.getDRGDiagram().getMetadata();
    }
}

