/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.drd;

import com.google.gwt.dom.client.DivElement;
import com.google.gwt.dom.client.InputElement;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.BlurEvent;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.KeyDownEvent;
import elemental2.dom.HTMLAnchorElement;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.gwtbootstrap3.client.ui.html.Span;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.dmn.api.definition.model.DMNDiagramElement;
import org.kie.workbench.common.dmn.client.docks.navigator.drds.DMNDiagramSelected;
import org.kie.workbench.common.dmn.client.docks.navigator.drds.DMNDiagramsSession;
import org.kie.workbench.common.dmn.client.editors.drd.DRDNameChanger;
import org.kie.workbench.common.stunner.client.widgets.presenters.session.SessionPresenter;

@Templated
@ApplicationScoped
public class DRDNameChangerView
implements DRDNameChanger {
    private static final int SESSION_HEADER_HEIGHT = 50;
    private final DMNDiagramsSession dmnDiagramsSession;
    private final Event<DMNDiagramSelected> selectedEvent;
    private SessionPresenter.View sessionPresenterView;
    @DataField(value="viewMode")
    private final DivElement viewMode;
    @DataField(value="editMode")
    private final DivElement editMode;
    @DataField(value="returnToDRG")
    private final HTMLAnchorElement returnToDRG;
    @DataField(value="drdName")
    private final Span drdName;
    @DataField(value="drdNameInput")
    private final InputElement drdNameInput;

    @Inject
    public DRDNameChangerView(DMNDiagramsSession dmnDiagramsSession, Event<DMNDiagramSelected> selectedEvent, DivElement viewMode, DivElement editMode, HTMLAnchorElement returnToDRG, Span drdName, InputElement drdNameInput) {
        this.dmnDiagramsSession = dmnDiagramsSession;
        this.selectedEvent = selectedEvent;
        this.viewMode = viewMode;
        this.editMode = editMode;
        this.returnToDRG = returnToDRG;
        this.drdName = drdName;
        this.drdNameInput = drdNameInput;
    }

    @Override
    public void setSessionPresenterView(SessionPresenter.View sessionPresenterView) {
        this.sessionPresenterView = sessionPresenterView;
        if (this.dmnDiagramsSession.isGlobalGraphSelected()) {
            this.hideDRDNameChanger();
        } else {
            this.showDRDNameChanger();
        }
    }

    @Override
    public void showDRDNameChanger() {
        this.sessionPresenterView.showSessionHeaderContainer(50);
    }

    @Override
    public void hideDRDNameChanger() {
        this.sessionPresenterView.hideSessionHeaderContainer();
    }

    void onSettingCurrentDMNDiagramElement(@Observes DMNDiagramSelected selected) {
        if (this.dmnDiagramsSession.isGlobalGraphSelected()) {
            this.hideDRDNameChanger();
        } else {
            this.drdName.setText(selected.getDiagramElement().getName().getValue());
            this.editMode.getStyle().setDisplay(Style.Display.NONE);
            this.viewMode.getStyle().setDisplay(Style.Display.BLOCK);
            this.showDRDNameChanger();
        }
    }

    @EventHandler(value={"returnToDRG"})
    void onClickReturnToDRG(ClickEvent event) {
        this.hideDRDNameChanger();
        this.selectedEvent.fire((Object)new DMNDiagramSelected(this.dmnDiagramsSession.getDRGDiagramElement()));
    }

    @EventHandler(value={"viewMode"})
    void enableEdit(ClickEvent event) {
        this.drdNameInput.setValue(this.drdName.getText());
        this.viewMode.getStyle().setDisplay(Style.Display.NONE);
        this.editMode.getStyle().setDisplay(Style.Display.BLOCK);
        this.drdNameInput.focus();
    }

    @EventHandler(value={"drdNameInput"})
    void onInputTextKeyPress(KeyDownEvent event) {
        if (event.getNativeEvent().getKeyCode() == 13) {
            this.saveForTheCurrentDiagram();
        }
    }

    @EventHandler(value={"drdNameInput"})
    void onInputTextBlur(BlurEvent event) {
        this.saveForTheCurrentDiagram();
    }

    void saveForTheCurrentDiagram() {
        this.dmnDiagramsSession.getCurrentDMNDiagramElement().ifPresent(this::performSave);
    }

    private void performSave(DMNDiagramElement dmnDiagramElement) {
        dmnDiagramElement.getName().setValue(this.drdNameInput.getValue());
        this.selectedEvent.fire((Object)new DMNDiagramSelected(dmnDiagramElement));
    }
}

