/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.expressions;

import java.util.Optional;
import java.util.function.Supplier;
import org.kie.workbench.common.dmn.api.definition.HasExpression;
import org.kie.workbench.common.dmn.api.definition.HasName;
import org.kie.workbench.common.dmn.api.definition.model.Expression;
import org.kie.workbench.common.dmn.client.editors.expressions.types.ExpressionEditorDefinition;
import org.kie.workbench.common.dmn.client.editors.expressions.types.ExpressionEditorDefinitions;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.ContextGridCell;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.ExpressionCellValue;
import org.kie.workbench.common.dmn.client.widgets.grid.BaseExpressionGrid;
import org.kie.workbench.common.dmn.client.widgets.grid.ExpressionGridCache;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.list.ListSelectorView;
import org.kie.workbench.common.dmn.client.widgets.grid.model.BaseUIModelMapper;
import org.kie.workbench.common.dmn.client.widgets.grid.model.GridCellTuple;
import org.uberfire.ext.wires.core.grids.client.model.GridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.GridData;

public class ExpressionContainerUIModelMapper
extends BaseUIModelMapper<Expression> {
    private final GridCellTuple parent;
    private final Supplier<String> nodeUUID;
    private final Supplier<HasExpression> hasExpression;
    private final Supplier<Optional<HasName>> hasName;
    private final Supplier<Boolean> isOnlyVisualChangeAllowedSupplier;
    private final Supplier<ExpressionEditorDefinitions> expressionEditorDefinitions;
    private final Supplier<ExpressionGridCache> expressionGridCache;
    private final ListSelectorView.Presenter listSelector;

    public ExpressionContainerUIModelMapper(GridCellTuple parent, Supplier<GridData> uiModel, Supplier<Optional<Expression>> dmnModel, Supplier<String> nodeUUID, Supplier<HasExpression> hasExpression, Supplier<Optional<HasName>> hasName, Supplier<Boolean> isOnlyVisualChangeAllowedSupplier, Supplier<ExpressionEditorDefinitions> expressionEditorDefinitions, Supplier<ExpressionGridCache> expressionGridCache, ListSelectorView.Presenter listSelector) {
        super(uiModel, dmnModel);
        this.parent = parent;
        this.nodeUUID = nodeUUID;
        this.hasExpression = hasExpression;
        this.hasName = hasName;
        this.isOnlyVisualChangeAllowedSupplier = isOnlyVisualChangeAllowedSupplier;
        this.expressionEditorDefinitions = expressionEditorDefinitions;
        this.expressionGridCache = expressionGridCache;
        this.listSelector = listSelector;
    }

    @Override
    public void fromDMNModel(int rowIndex, int columnIndex) {
        String uuid = this.nodeUUID.get();
        GridData uiModel = (GridData)this.uiModel.get();
        Optional expression = (Optional)this.dmnModel.get();
        Optional<HasName> hasName = this.hasName.get();
        boolean isOnlyVisualChangeAllowed = this.isOnlyVisualChangeAllowedSupplier.get();
        HasExpression hasExpression = this.hasExpression.get();
        Optional<ExpressionEditorDefinition<Expression>> expressionEditorDefinition = this.expressionEditorDefinitions.get().getExpressionEditorDefinition(expression);
        expressionEditorDefinition.ifPresent(definition -> {
            Optional<BaseExpressionGrid<? extends Expression, ? extends GridData, ? extends BaseUIModelMapper>> editor = this.expressionGridCache.get().getExpressionGrid(uuid);
            if (!editor.isPresent()) {
                Optional<BaseExpressionGrid<? extends Expression, ? extends GridData, ? extends BaseUIModelMapper>> oEditor = definition.getEditor(this.parent, Optional.of(uuid), hasExpression, hasName, isOnlyVisualChangeAllowed, 0);
                this.expressionGridCache.get().putExpressionGrid(uuid, oEditor);
                editor = oEditor;
            }
            Optional<BaseExpressionGrid<? extends Expression, ? extends GridData, ? extends BaseUIModelMapper>> _editor = editor;
            uiModel.setCell(0, 0, () -> new ContextGridCell(new ExpressionCellValue(_editor), this.listSelector));
        });
    }

    @Override
    public void toDMNModel(int rowIndex, int columnIndex, Supplier<Optional<GridCellValue<?>>> cell) {
        throw new UnsupportedOperationException("ExpressionContainerUIModelMapper does not support updating DMN models.");
    }
}

