/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.expressions;

import com.ait.lienzo.client.core.mediator.IMediator;
import com.ait.lienzo.client.core.shape.IPrimitive;
import com.ait.lienzo.client.core.types.Transform;
import com.google.gwt.dom.client.Document;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.KeyDownHandler;
import com.google.gwt.user.client.ui.Widget;
import java.util.Optional;
import java.util.function.Supplier;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.jboss.errai.common.client.dom.Anchor;
import org.jboss.errai.common.client.dom.Span;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.dmn.api.definition.HasExpression;
import org.kie.workbench.common.dmn.api.definition.HasName;
import org.kie.workbench.common.dmn.api.definition.model.Expression;
import org.kie.workbench.common.dmn.api.qualifiers.DMNEditor;
import org.kie.workbench.common.dmn.client.commands.factory.DefaultCanvasCommandFactory;
import org.kie.workbench.common.dmn.client.editors.expressions.ExpressionContainerGrid;
import org.kie.workbench.common.dmn.client.editors.expressions.ExpressionEditorView;
import org.kie.workbench.common.dmn.client.editors.expressions.types.ExpressionEditorDefinitions;
import org.kie.workbench.common.dmn.client.session.DMNSession;
import org.kie.workbench.common.dmn.client.widgets.grid.BoundaryTransformMediator;
import org.kie.workbench.common.dmn.client.widgets.grid.ExpressionGridCache;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.container.CellEditorControlsView;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.list.ListSelectorView;
import org.kie.workbench.common.dmn.client.widgets.grid.keyboard.KeyboardOperationEditCell;
import org.kie.workbench.common.dmn.client.widgets.grid.keyboard.KeyboardOperationEscapeGridCell;
import org.kie.workbench.common.dmn.client.widgets.grid.keyboard.KeyboardOperationInvokeContextMenuForSelectedCell;
import org.kie.workbench.common.dmn.client.widgets.layer.DMNGridLayer;
import org.kie.workbench.common.dmn.client.widgets.panel.DMNGridPanel;
import org.kie.workbench.common.dmn.client.widgets.panel.DMNGridPanelContainer;
import org.kie.workbench.common.stunner.core.client.api.SessionManager;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.event.selection.DomainObjectSelectionEvent;
import org.kie.workbench.common.stunner.core.client.command.SessionCommandManager;
import org.kie.workbench.common.stunner.forms.client.event.RefreshFormPropertiesEvent;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.grid.impl.BaseGridWidgetKeyboardHandler;
import org.uberfire.ext.wires.core.grids.client.widget.grid.impl.KeyboardOperation;
import org.uberfire.ext.wires.core.grids.client.widget.grid.impl.KeyboardOperationMoveDown;
import org.uberfire.ext.wires.core.grids.client.widget.grid.impl.KeyboardOperationMoveLeft;
import org.uberfire.ext.wires.core.grids.client.widget.grid.impl.KeyboardOperationMoveRight;
import org.uberfire.ext.wires.core.grids.client.widget.grid.impl.KeyboardOperationMoveUp;
import org.uberfire.ext.wires.core.grids.client.widget.layer.GridLayer;
import org.uberfire.ext.wires.core.grids.client.widget.layer.pinning.TransformMediator;
import org.uberfire.ext.wires.core.grids.client.widget.layer.pinning.impl.RestrictedMousePanMediator;
import org.uberfire.ext.wires.core.grids.client.widget.scrollbars.GridLienzoScrollable;
import org.uberfire.mvp.ParameterizedCommand;

@Templated
@Dependent
public class ExpressionEditorViewImpl
implements ExpressionEditorView {
    static final double VP_SCALE = 1.0;
    private ExpressionEditorView.Presenter presenter;
    @DataField(value="returnToLink")
    private Anchor returnToLink;
    @DataField(value="expressionName")
    private Span expressionName;
    @DataField(value="expressionType")
    private Span expressionType;
    @DataField(value="dmn-table")
    private DMNGridPanelContainer gridPanelContainer;
    private TranslationService translationService;
    private ListSelectorView.Presenter listSelector;
    private SessionManager sessionManager;
    private SessionCommandManager<AbstractCanvasHandler> sessionCommandManager;
    private DefaultCanvasCommandFactory canvasCommandFactory;
    private Supplier<ExpressionEditorDefinitions> expressionEditorDefinitionsSupplier;
    private Event<RefreshFormPropertiesEvent> refreshFormPropertiesEvent;
    private Event<DomainObjectSelectionEvent> domainObjectSelectionEvent;
    private DMNGridPanel gridPanel;
    private DMNGridLayer gridLayer;
    private CellEditorControlsView.Presenter cellEditorControls;
    private RestrictedMousePanMediator mousePanMediator;
    private ExpressionContainerGrid expressionContainerGrid;

    public ExpressionEditorViewImpl() {
    }

    @Inject
    public ExpressionEditorViewImpl(Anchor returnToLink, Span expressionName, Span expressionType, @DMNEditor DMNGridPanelContainer gridPanelContainer, TranslationService translationService, ListSelectorView.Presenter listSelector, SessionManager sessionManager, SessionCommandManager<AbstractCanvasHandler> sessionCommandManager, @DMNEditor DefaultCanvasCommandFactory canvasCommandFactory, @DMNEditor Supplier<ExpressionEditorDefinitions> expressionEditorDefinitionsSupplier, Event<RefreshFormPropertiesEvent> refreshFormPropertiesEvent, Event<DomainObjectSelectionEvent> domainObjectSelectionEvent) {
        this.returnToLink = returnToLink;
        this.expressionName = expressionName;
        this.expressionType = expressionType;
        this.gridPanelContainer = gridPanelContainer;
        this.translationService = translationService;
        this.listSelector = listSelector;
        this.sessionManager = sessionManager;
        this.sessionCommandManager = sessionCommandManager;
        this.canvasCommandFactory = canvasCommandFactory;
        this.expressionEditorDefinitionsSupplier = expressionEditorDefinitionsSupplier;
        this.refreshFormPropertiesEvent = refreshFormPropertiesEvent;
        this.domainObjectSelectionEvent = domainObjectSelectionEvent;
    }

    public void init(ExpressionEditorView.Presenter presenter) {
        this.presenter = presenter;
    }

    public void bind(DMNSession session) {
        this.gridPanel = session.getGridPanel();
        this.gridLayer = session.getGridLayer();
        this.cellEditorControls = session.getCellEditorControls();
        this.mousePanMediator = session.getMousePanMediator();
        this.setupGridPanel();
        this.setupGridWidget();
        this.setupGridWidgetPanControl();
    }

    protected void setupGridPanel() {
        Transform transform = new Transform().scale(1.0);
        this.gridPanel.getElement().setId("dmn_container_" + Document.get().createUniqueId());
        this.gridPanel.getViewport().setTransform(transform);
        BaseGridWidgetKeyboardHandler handler = new BaseGridWidgetKeyboardHandler((GridLayer)this.gridLayer);
        this.addKeyboardOperation(handler, (KeyboardOperation)new KeyboardOperationEditCell((GridLayer)this.gridLayer));
        this.addKeyboardOperation(handler, (KeyboardOperation)new KeyboardOperationEscapeGridCell((GridLayer)this.gridLayer));
        this.addKeyboardOperation(handler, (KeyboardOperation)new KeyboardOperationMoveLeft((GridLayer)this.gridLayer, (GridLienzoScrollable)this.gridPanel));
        this.addKeyboardOperation(handler, (KeyboardOperation)new KeyboardOperationMoveRight((GridLayer)this.gridLayer, (GridLienzoScrollable)this.gridPanel));
        this.addKeyboardOperation(handler, (KeyboardOperation)new KeyboardOperationMoveUp((GridLayer)this.gridLayer, (GridLienzoScrollable)this.gridPanel));
        this.addKeyboardOperation(handler, (KeyboardOperation)new KeyboardOperationMoveDown((GridLayer)this.gridLayer, (GridLienzoScrollable)this.gridPanel));
        this.addKeyboardOperation(handler, (KeyboardOperation)new KeyboardOperationInvokeContextMenuForSelectedCell((GridLayer)this.gridLayer));
        this.gridPanel.addKeyDownHandler((KeyDownHandler)handler);
        this.gridPanelContainer.clear();
        this.gridPanelContainer.setWidget((Widget)this.gridPanel);
    }

    void addKeyboardOperation(BaseGridWidgetKeyboardHandler handler, KeyboardOperation operation) {
        handler.addOperation(new KeyboardOperation[]{operation});
    }

    protected void setupGridWidget() {
        this.expressionContainerGrid = new ExpressionContainerGrid(this.gridLayer, this.cellEditorControls, this.translationService, this.listSelector, this.sessionManager, this.sessionCommandManager, this.canvasCommandFactory, this.expressionEditorDefinitionsSupplier, this.getExpressionGridCacheSupplier(), (ParameterizedCommand<Optional<Expression>>)((ParameterizedCommand)this::setExpressionTypeText), (ParameterizedCommand<Optional<HasName>>)((ParameterizedCommand)this::setExpressionNameText), this.refreshFormPropertiesEvent, this.domainObjectSelectionEvent);
        this.gridLayer.removeAll();
        this.gridLayer.add((IPrimitive)this.expressionContainerGrid);
        this.gridLayer.select((GridWidget)this.expressionContainerGrid);
        this.gridLayer.enterPinnedMode((GridWidget)this.expressionContainerGrid, () -> {});
    }

    protected Supplier<ExpressionGridCache> getExpressionGridCacheSupplier() {
        return () -> ((DMNSession)this.sessionManager.getCurrentSession()).getExpressionGridCache();
    }

    protected void setupGridWidgetPanControl() {
        BoundaryTransformMediator defaultTransformMediator = new BoundaryTransformMediator((GridWidget)this.expressionContainerGrid);
        this.mousePanMediator.setTransformMediator((TransformMediator)defaultTransformMediator);
        this.mousePanMediator.setBatchDraw(true);
        this.gridLayer.setDefaultTransformMediator(defaultTransformMediator);
        this.gridPanel.getViewport().getMediators().push((IMediator)this.mousePanMediator);
    }

    @Override
    public void setReturnToLinkText(String text) {
        this.returnToLink.setTextContent(this.translationService.format("ExpressionEditor.ReturnToLink", new Object[]{text}));
    }

    @Override
    public void setExpression(String nodeUUID, HasExpression hasExpression, Optional<HasName> hasName, boolean isOnlyVisualChangeAllowed) {
        this.expressionContainerGrid.setExpression(nodeUUID, hasExpression, hasName, isOnlyVisualChangeAllowed);
        this.setExpressionNameText(hasName);
        this.setExpressionTypeText(Optional.ofNullable(hasExpression.getExpression()));
    }

    public ExpressionContainerGrid getExpressionContainerGrid() {
        return this.expressionContainerGrid;
    }

    @Override
    public void setExpressionNameText(Optional<HasName> hasName) {
        hasName.ifPresent(name -> this.expressionName.setTextContent(name.getName().getValue()));
    }

    @Override
    public void setExpressionTypeText(Optional<Expression> expression) {
        String expressionTypeText = this.expressionEditorDefinitionsSupplier.get().getExpressionEditorDefinition(expression).get().getName();
        this.expressionType.setTextContent(this.translationService.format("ExpressionEditor.ExpressionTypeText", new Object[]{expression.isPresent() ? expressionTypeText : "<" + expressionTypeText + ">"}));
    }

    @EventHandler(value={"returnToLink"})
    void onClickReturnToLink(ClickEvent event) {
        this.presenter.exit();
    }

    public void onResize() {
        this.gridPanelContainer.onResize();
    }

    @Override
    public void refresh() {
        this.gridLayer.batch();
    }

    @Override
    public void setFocus() {
        this.gridPanel.setFocus(true);
    }
}

