/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.expressions.util;

import com.ait.lienzo.client.core.shape.Group;
import com.ait.lienzo.client.core.shape.IPrimitive;
import com.ait.lienzo.client.core.shape.ITextWrapper;
import com.ait.lienzo.client.core.shape.Text;
import com.ait.lienzo.client.core.shape.TextLineBreakWrap;
import com.ait.lienzo.shared.core.types.TextAlign;
import com.google.gwt.core.client.GWT;
import org.kie.workbench.common.dmn.api.property.dmn.QName;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.InformationItemCell;
import org.kie.workbench.common.dmn.client.widgets.grid.columns.EditableHeaderMetaData;
import org.kie.workbench.common.dmn.client.widgets.grid.columns.ValueAndDataTypeHeaderMetaData;
import org.kie.workbench.common.stunner.core.util.StringUtils;
import org.uberfire.ext.wires.core.grids.client.model.GridCell;
import org.uberfire.ext.wires.core.grids.client.model.GridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridCell;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridCellValue;
import org.uberfire.ext.wires.core.grids.client.widget.context.GridBodyCellRenderContext;
import org.uberfire.ext.wires.core.grids.client.widget.context.GridHeaderColumnRenderContext;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.GridRenderer;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.themes.GridRendererTheme;

public class RendererUtils {
    public static final double EXPRESSION_TEXT_PADDING = 5.0;
    public static final String FONT_STYLE_TYPE_REF = "italic";
    public static final double SPACING = 8.0;

    public static Group getExpressionCellText(GridBodyCellRenderContext context, GridCell<String> gridCell) {
        GridRenderer gridRenderer = context.getRenderer();
        GridRendererTheme theme = gridRenderer.getTheme();
        return RendererUtils.getExpressionText(theme, (String)gridCell.getValue().getValue());
    }

    public static Group getCenteredCellText(GridBodyCellRenderContext context, GridCell<String> gridCell) {
        Text t;
        GridRenderer gridRenderer = context.getRenderer();
        GridRendererTheme theme = gridRenderer.getTheme();
        Group g = (Group)GWT.create(Group.class);
        String value = (String)gridCell.getValue().getValue();
        if (!StringUtils.isEmpty((String)value)) {
            t = theme.getBodyText();
        } else {
            value = gridCell.getValue().getPlaceHolder();
            t = theme.getPlaceholderText();
        }
        t.setText(value);
        t.setListening(false);
        t.setX(context.getCellWidth() / 2.0);
        t.setY(context.getCellHeight() / 2.0);
        g.add((IPrimitive)t);
        return g;
    }

    public static Group getNameAndDataTypeCellText(InformationItemCell.HasNameAndDataTypeCell hasNameAndDataTypeCell, GridBodyCellRenderContext context) {
        if (!hasNameAndDataTypeCell.hasData()) {
            BaseGridCellValue cell = new BaseGridCellValue(null, hasNameAndDataTypeCell.getPlaceHolderText());
            return RendererUtils.getCenteredCellText(context, (GridCell<String>)new BaseGridCell((GridCellValue)cell));
        }
        return RendererUtils.getNameAndDataTypeText(context.getRenderer().getTheme(), hasNameAndDataTypeCell.getName().getValue(), hasNameAndDataTypeCell.getTypeRef(), context.getCellWidth(), context.getCellHeight());
    }

    public static Group getExpressionHeaderText(EditableHeaderMetaData headerMetaData, GridHeaderColumnRenderContext context) {
        GridRenderer gridRenderer = context.getRenderer();
        GridRendererTheme theme = gridRenderer.getTheme();
        return RendererUtils.getExpressionText(theme, headerMetaData.getTitle());
    }

    public static Group getValueAndDataTypeHeaderText(ValueAndDataTypeHeaderMetaData headerMetaData, GridHeaderColumnRenderContext context, double blockWidth, double blockHeight) {
        return RendererUtils.getNameAndDataTypeText(context.getRenderer().getTheme(), headerMetaData.getTitle(), headerMetaData.getTypeRef(), blockWidth, blockHeight);
    }

    public static Group getEditableHeaderText(EditableHeaderMetaData headerMetaData, GridHeaderColumnRenderContext context, double blockWidth, double blockHeight) {
        Group headerGroup = (Group)GWT.create(Group.class);
        GridRenderer renderer = context.getRenderer();
        GridRendererTheme theme = renderer.getTheme();
        Text text = theme.getHeaderText();
        String value = headerMetaData.getTitle();
        text.setX(blockWidth / 2.0);
        text.setY(blockHeight / 2.0);
        text.setText(value);
        text.setListening(false);
        headerGroup.add((IPrimitive)text);
        return headerGroup;
    }

    public static Group getEditableHeaderPlaceHolderText(EditableHeaderMetaData headerMetaData, GridHeaderColumnRenderContext context, double blockWidth, double blockHeight) {
        Group headerGroup = (Group)GWT.create(Group.class);
        headerMetaData.getPlaceHolder().ifPresent(placeHolder -> {
            GridRenderer renderer = context.getRenderer();
            GridRendererTheme theme = renderer.getTheme();
            Text text = theme.getPlaceholderText();
            text.setX(blockWidth / 2.0);
            text.setY(blockHeight / 2.0);
            text.setText(placeHolder);
            text.setListening(false);
            headerGroup.add((IPrimitive)text);
        });
        return headerGroup;
    }

    private static Group getExpressionText(GridRendererTheme theme, String text) {
        Group g = (Group)GWT.create(Group.class);
        Text t = RendererUtils.makeExpressionText(theme);
        t.setText(text);
        t.setListening(false);
        t.setX(5.0);
        t.setY(5.0);
        t.setTextAlign(TextAlign.LEFT);
        t.setWrapper((ITextWrapper)new TextLineBreakWrap(t));
        g.add((IPrimitive)t);
        return g;
    }

    private static Text makeExpressionText(GridRendererTheme theme) {
        Text t = theme.getBodyText();
        t.setFontFamily("Courier New");
        return t;
    }

    public static double getExpressionTextLineHeight(GridRendererTheme theme) {
        return RendererUtils.makeExpressionText(theme).getLineHeight(null);
    }

    private static Group getNameAndDataTypeText(GridRendererTheme theme, String name, QName typeRef, double blockWidth, double blockHeight) {
        Group headerGroup = (Group)GWT.create(Group.class);
        Text tName = theme.getHeaderText();
        tName.setText(name);
        tName.setListening(false);
        tName.setX(blockWidth / 2.0);
        tName.setY(blockHeight / 2.0 - 8.0);
        Text tTypeRef = theme.getHeaderText();
        tTypeRef.setFontStyle(FONT_STYLE_TYPE_REF);
        tTypeRef.setFontSize(8.0);
        tTypeRef.setText("(" + typeRef.toString() + ")");
        tTypeRef.setListening(false);
        tTypeRef.setX(blockWidth / 2.0);
        tTypeRef.setY(blockHeight / 2.0 + 8.0);
        headerGroup.add((IPrimitive)tName);
        headerGroup.add((IPrimitive)tTypeRef);
        return headerGroup;
    }
}

