/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.included.imports;

import java.util.Objects;
import javax.inject.Inject;
import org.kie.workbench.common.dmn.api.definition.model.Import;
import org.kie.workbench.common.dmn.api.definition.model.ImportDMN;
import org.kie.workbench.common.dmn.api.definition.model.ImportPMML;
import org.kie.workbench.common.dmn.api.property.dmn.LocationURI;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.dmn.client.editors.included.BaseIncludedModelActiveRecord;
import org.kie.workbench.common.dmn.client.editors.included.DMNIncludedModelActiveRecord;
import org.kie.workbench.common.dmn.client.editors.included.PMMLIncludedModelActiveRecord;
import org.kie.workbench.common.dmn.client.editors.included.imports.IncludedModelsIndex;

public class ImportFactory {
    private final IncludedModelsIndex modelsIndex;

    @Inject
    public ImportFactory(IncludedModelsIndex modelsIndex) {
        this.modelsIndex = modelsIndex;
    }

    public Import makeImport(BaseIncludedModelActiveRecord record) {
        Import anImport;
        if (record instanceof DMNIncludedModelActiveRecord) {
            ImportDMN dmn = new ImportDMN();
            DMNIncludedModelActiveRecord dmnRecord = (DMNIncludedModelActiveRecord)record;
            dmn.setName(this.name(record));
            dmn.setNamespace(record.getNamespace());
            dmn.setLocationURI(this.location(record));
            dmn.setImportType(record.getImportType());
            dmn.setDrgElementsCount(dmnRecord.getDrgElementsCount().intValue());
            dmn.setItemDefinitionsCount(dmnRecord.getDataTypesCount().intValue());
            anImport = dmn;
        } else if (record instanceof PMMLIncludedModelActiveRecord) {
            ImportPMML pmml = new ImportPMML();
            PMMLIncludedModelActiveRecord pmmlRecord = (PMMLIncludedModelActiveRecord)record;
            pmml.setName(this.name(record));
            pmml.setNamespace(this.name(record).getValue());
            pmml.setLocationURI(this.location(record));
            pmml.setImportType(record.getImportType());
            pmml.setModelCount(pmmlRecord.getModelCount().intValue());
            anImport = pmml;
        } else {
            anImport = new Import();
        }
        anImport.setLocationURI(this.location(record));
        anImport.setImportType(record.getImportType());
        return anImport;
    }

    private LocationURI location(BaseIncludedModelActiveRecord record) {
        return new LocationURI(record.getPath());
    }

    Name name(BaseIncludedModelActiveRecord record) {
        return new Name(this.uniqueName(record.getName()));
    }

    private String uniqueName(String name) {
        return this.uniqueName(name, 1);
    }

    private String uniqueName(String name, int suffix) {
        String newName;
        String string = newName = suffix == 1 ? name : name + " - " + suffix;
        if (this.isUnique(newName)) {
            return newName;
        }
        return this.uniqueName(name, suffix + 1);
    }

    private boolean isUnique(String name) {
        return this.modelsIndex.getIndexedImports().stream().map(anImport -> anImport.getName().getValue()).noneMatch(importName -> Objects.equals(importName, name));
    }
}

