/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types;

import java.util.Optional;
import java.util.function.Consumer;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.kie.workbench.common.dmn.api.property.dmn.QName;
import org.kie.workbench.common.dmn.client.editors.types.CanBeClosedByKeyboard;
import org.kie.workbench.common.dmn.client.editors.types.DataTypePageTabActiveEvent;
import org.kie.workbench.common.dmn.client.editors.types.HasValueAndTypeRef;
import org.kie.workbench.common.dmn.client.editors.types.ValueAndDataTypePopoverView;

@Dependent
public class ValueAndDataTypePopoverImpl
implements ValueAndDataTypePopoverView.Presenter {
    static final String BINDING_EXCEPTION = "Popover has not been bound.";
    private ValueAndDataTypePopoverView view;
    private Optional<HasValueAndTypeRef> binding = Optional.empty();

    public ValueAndDataTypePopoverImpl() {
    }

    @Inject
    public ValueAndDataTypePopoverImpl(ValueAndDataTypePopoverView view) {
        this.view = view;
        view.init(this);
    }

    public HTMLElement getElement() {
        return this.view.getElement();
    }

    @Override
    public String getPopoverTitle() {
        return this.binding.orElseThrow(() -> new IllegalStateException(BINDING_EXCEPTION)).getPopoverTitle();
    }

    @Override
    public void bind(HasValueAndTypeRef bound, int uiRowIndex, int uiColumnIndex) {
        this.binding = Optional.ofNullable(bound);
        this.refresh();
    }

    private void refresh() {
        this.binding.ifPresent(b -> {
            this.view.setDMNModel(b.asDMNModelInstrumentedBase());
            this.view.initValue(b.toWidgetValue(b.getValue()));
            this.view.initSelectedTypeRef(b.getTypeRef());
        });
    }

    @Override
    public void setValue(String value) {
        this.binding.ifPresent(b -> b.setValue(b.toModelValue(value)));
    }

    @Override
    public void setTypeRef(QName typeRef) {
        this.binding.ifPresent(b -> b.setTypeRef(typeRef));
    }

    @Override
    public String getValueLabel() {
        return this.binding.orElseThrow(() -> new IllegalStateException(BINDING_EXCEPTION)).getValueLabel();
    }

    @Override
    public String normaliseValue(String value) {
        return this.binding.orElseThrow(() -> new IllegalStateException(BINDING_EXCEPTION)).normaliseValue(value);
    }

    @Override
    public void setOnClosedByKeyboardCallback(Consumer<CanBeClosedByKeyboard> callback) {
        this.binding.ifPresent(b -> this.view.setOnClosedByKeyboardCallback(callback));
    }

    @Override
    public void show() {
        this.binding.ifPresent(b -> this.view.show(Optional.ofNullable(this.getPopoverTitle())));
    }

    @Override
    public void hide() {
        this.binding.ifPresent(b -> this.view.hide());
    }

    public void onDataTypePageNavTabActiveEvent(@Observes DataTypePageTabActiveEvent event) {
        this.hide();
    }
}

