/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types;

import com.google.gwt.event.dom.client.BlurEvent;
import com.google.gwt.event.dom.client.KeyDownEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import elemental2.dom.DomGlobal;
import elemental2.dom.Element;
import elemental2.dom.KeyboardEvent;
import java.util.Objects;
import java.util.Optional;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.common.client.dom.Button;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.common.client.dom.EventListener;
import org.jboss.errai.common.client.dom.Input;
import org.jboss.errai.common.client.dom.Span;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.dmn.api.definition.model.DMNModelInstrumentedBase;
import org.kie.workbench.common.dmn.api.property.dmn.QName;
import org.kie.workbench.common.dmn.client.editors.types.DataTypePickerWidget;
import org.kie.workbench.common.dmn.client.editors.types.ValueAndDataTypePopoverView;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.popover.AbstractPopoverViewImpl;
import org.uberfire.client.views.pfly.selectpicker.JQuerySelectPicker;
import org.uberfire.client.views.pfly.widgets.JQueryProducer;
import org.uberfire.client.views.pfly.widgets.Popover;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.ParameterizedCommand;

@Templated
@Dependent
public class ValueAndDataTypePopoverViewImpl
extends AbstractPopoverViewImpl
implements ValueAndDataTypePopoverView {
    static final String TYPE_SELECTOR_BUTTON_SELECTOR = "button.dropdown-toggle.btn-default";
    static final String MANAGE_BUTTON_SELECTOR = "#typeButton";
    static final String TAB_KEY = "Tab";
    static final String ESCAPE_KEY = "Escape";
    static final String ESC_KEY = "Esc";
    static final String ENTER_KEY = "Enter";
    static final String DROPDOWN_ELEMENT_SELECTOR = ".bs-container.btn-group.bootstrap-select.show-tick.input-group-btn";
    @DataField(value="valueEditor")
    private Input valueEditor;
    @DataField(value="typeRefSelector")
    private DataTypePickerWidget typeRefEditor;
    @DataField(value="valueLabel")
    private Span valueLabel;
    @DataField(value="dataTypeLabel")
    private Span dataTypeLabel;
    private ValueAndDataTypePopoverView.Presenter presenter;
    private String currentValue;
    private String previousValue;
    private QName currentTypeRef;
    private QName previousTypeRef;
    private BootstrapSelectDropDownMonitor monitor;

    public ValueAndDataTypePopoverViewImpl() {
    }

    @Inject
    public ValueAndDataTypePopoverViewImpl(Input valueEditor, DataTypePickerWidget typeRefEditor, Div popoverElement, Div popoverContentElement, Span valueLabel, Span dataTypeLabel, JQueryProducer.JQuery<Popover> jQueryPopover, TranslationService translationService) {
        super(popoverElement, popoverContentElement, jQueryPopover);
        this.valueEditor = valueEditor;
        this.typeRefEditor = typeRefEditor;
        this.popoverElement = popoverElement;
        this.popoverContentElement = popoverContentElement;
        this.valueLabel = valueLabel;
        this.dataTypeLabel = dataTypeLabel;
        this.jQueryPopover = jQueryPopover;
        this.dataTypeLabel.setTextContent(translationService.getTranslation("NameAndDataTypePopover.DataTypeLabel"));
        this.monitor = new BootstrapSelectDropDownMonitor((ParameterizedCommand<Optional<String>>)((ParameterizedCommand)popoverTitle -> ValueAndDataTypePopoverViewImpl.super.show(popoverTitle)), () -> ValueAndDataTypePopoverViewImpl.super.hide());
    }

    public void init(ValueAndDataTypePopoverView.Presenter presenter) {
        this.presenter = presenter;
        this.typeRefEditor.addValueChangeHandler((ValueChangeHandler<QName>)((ValueChangeHandler)e -> {
            this.currentTypeRef = (QName)e.getValue();
        }));
        this.setKeyDownListeners();
    }

    public String getCurrentValue() {
        return this.currentValue;
    }

    public QName getCurrentTypeRef() {
        return this.currentTypeRef;
    }

    @Override
    protected void setKeyDownListeners() {
        super.setKeyDownListeners();
        Button manageButton = this.getManageButton();
        manageButton.addEventListener("keydown", this.getManageButtonKeyDownEventListener(), false);
        Button typeSelectorButton = this.getTypeSelectorButton();
        typeSelectorButton.addEventListener("keydown", this.getTypeSelectorKeyDownEventListener(), false);
    }

    @Override
    protected EventListener getKeyDownEventListener() {
        return super.getKeyDownEventListener();
    }

    EventListener getTypeSelectorKeyDownEventListener() {
        return e -> this.typeSelectorKeyDownEventListener(e);
    }

    EventListener getManageButtonKeyDownEventListener() {
        return e -> this.manageButtonKeyDownEventListener(e);
    }

    Button getTypeSelectorButton() {
        return (Button)this.getElement().querySelector(TYPE_SELECTOR_BUTTON_SELECTOR);
    }

    Button getManageButton() {
        return (Button)this.getElement().querySelector(MANAGE_BUTTON_SELECTOR);
    }

    void typeSelectorKeyDownEventListener(Object event) {
        if (event instanceof KeyboardEvent) {
            KeyboardEvent keyEvent = (KeyboardEvent)event;
            if (this.isEnterKeyPressed(keyEvent)) {
                this.hide(true);
                keyEvent.preventDefault();
                this.onClosedByKeyboard();
            } else if (this.isEscapeKeyPressed(keyEvent)) {
                this.reset();
                this.hide(false);
                this.onClosedByKeyboard();
            } else if (this.isTabKeyPressed(keyEvent)) {
                if (keyEvent.shiftKey) {
                    Button manageButton = this.getManageButton();
                    manageButton.focus();
                } else {
                    this.valueEditor.focus();
                }
                keyEvent.preventDefault();
            }
        }
    }

    void manageButtonKeyDownEventListener(Object event) {
        KeyboardEvent keyEvent;
        if (event instanceof KeyboardEvent && this.isEscapeKeyPressed(keyEvent = (KeyboardEvent)event)) {
            this.reset();
            this.hide(false);
            this.onClosedByKeyboard();
        }
    }

    boolean isTabKeyPressed(KeyboardEvent event) {
        return Objects.equals(event.key, TAB_KEY);
    }

    @Override
    public void setDMNModel(DMNModelInstrumentedBase dmnModel) {
        this.typeRefEditor.setDMNModel(dmnModel);
        this.previousTypeRef = this.typeRefEditor.getValue();
    }

    @Override
    public void initValue(String value) {
        this.valueEditor.setValue(value);
        this.currentValue = value;
        this.previousValue = value;
    }

    @Override
    public void initSelectedTypeRef(QName typeRef) {
        this.typeRefEditor.setValue(typeRef, false);
        this.currentTypeRef = typeRef;
        this.previousTypeRef = typeRef;
    }

    @Override
    public void show(Optional<String> popoverTitle) {
        this.valueLabel.setTextContent(this.presenter.getValueLabel());
        this.getMonitor().show(popoverTitle);
    }

    @Override
    protected void onShownFocus() {
        this.valueEditor.focus();
    }

    @Override
    public void hide() {
        this.hide(true);
    }

    public void hide(boolean applyChanges) {
        if (this.isVisible()) {
            this.valueEditor.blur();
            this.getMonitor().hide();
            if (applyChanges) {
                this.applyChanges();
            }
        }
    }

    BootstrapSelectDropDownMonitor getMonitor() {
        return this.monitor;
    }

    @EventHandler(value={"valueEditor"})
    void onValueChange(BlurEvent event) {
        String value = this.valueEditor.getValue();
        String normalisedValue = this.presenter.normaliseValue(value);
        if (!Objects.equals(normalisedValue, value)) {
            this.valueEditor.setValue(normalisedValue);
        }
        this.currentValue = normalisedValue;
    }

    void applyChanges() {
        this.presenter.setValue(this.currentValue);
        if (!Objects.isNull(this.currentTypeRef)) {
            this.presenter.setTypeRef(this.currentTypeRef);
        }
    }

    @Override
    public void reset() {
        this.valueEditor.setValue(this.previousValue);
        if (!Objects.isNull(this.previousTypeRef)) {
            this.typeRefEditor.setValue(this.previousTypeRef);
        }
        this.currentValue = this.previousValue;
        this.currentTypeRef = this.previousTypeRef;
    }

    @EventHandler(value={"valueEditor"})
    public void onValueEditorKeyDown(KeyDownEvent event) {
        if (this.isEnter(event)) {
            this.hide(true);
            this.onClosedByKeyboard();
        } else if (this.isEsc(event)) {
            this.reset();
            this.hide(false);
            this.onClosedByKeyboard();
        } else if (event.isShiftKeyDown() && this.isTab(event)) {
            Button typeSelectorButton = this.getTypeSelectorButton();
            typeSelectorButton.focus();
            event.preventDefault();
        }
    }

    boolean isTab(KeyDownEvent event) {
        return Objects.equals(event.getNativeKeyCode(), 9);
    }

    boolean isEsc(KeyDownEvent event) {
        return Objects.equals(event.getNativeKeyCode(), 27);
    }

    boolean isEnter(KeyDownEvent event) {
        return Objects.equals(event.getNativeKeyCode(), 13);
    }

    static class BootstrapSelectDropDownMonitor {
        static final String SELECT_ID = "#kieDataType";
        static final String BOOTSTRAP_SELECT_SHOWN_EVENT = "shown.bs.select";
        static final String BOOTSTRAP_SELECT_HIDDEN_EVENT = "hidden.bs.select";
        static final String OPEN_CLASS = "open";
        private final ParameterizedCommand<Optional<String>> commandShow;
        private final Command commandHide;

        BootstrapSelectDropDownMonitor(ParameterizedCommand<Optional<String>> commandShow, Command commandHide) {
            this.commandShow = commandShow;
            this.commandHide = commandHide;
        }

        void show(Optional<String> popoverTitle) {
            this.commandShow.execute(popoverTitle);
        }

        void hide() {
            this.kieDataTypeSelect().off(BOOTSTRAP_SELECT_SHOWN_EVENT);
            if (this.isDropDownVisible()) {
                this.kieDataTypeSelect().on(BOOTSTRAP_SELECT_HIDDEN_EVENT, event -> this.onHide());
            } else {
                this.onHide();
            }
        }

        void onHide() {
            this.kieDataTypeSelect().off(BOOTSTRAP_SELECT_HIDDEN_EVENT);
            this.commandHide.execute();
        }

        boolean isDropDownVisible() {
            Element menuElement = this.getMenuElement();
            return Optional.ofNullable(menuElement).map(element -> element.classList.contains(OPEN_CLASS)).orElse(false);
        }

        Element getMenuElement() {
            return DomGlobal.document.querySelector(ValueAndDataTypePopoverViewImpl.DROPDOWN_ELEMENT_SELECTOR);
        }

        JQuerySelectPicker kieDataTypeSelect() {
            return JQuerySelectPicker.$((String)SELECT_ID);
        }
    }
}

