/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.common;

import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.kie.workbench.common.dmn.api.property.dmn.types.BuiltInType;
import org.kie.workbench.common.dmn.client.editors.types.common.DataType;
import org.kie.workbench.common.dmn.client.editors.types.common.DataTypeKind;
import org.kie.workbench.common.dmn.client.editors.types.common.DataTypeManager;
import org.kie.workbench.common.dmn.client.editors.types.persistence.DataTypeStore;
import org.kie.workbench.common.dmn.client.graph.DMNGraphUtils;

@Dependent
public class DataTypeUtils {
    private final DataTypeStore dataTypeStore;
    private final DataTypeManager dataTypeManager;
    private final DMNGraphUtils dmnGraphUtils;

    @Inject
    public DataTypeUtils(DataTypeStore dataTypeStore, DataTypeManager dataTypeManager, DMNGraphUtils dmnGraphUtils) {
        this.dataTypeStore = dataTypeStore;
        this.dataTypeManager = dataTypeManager;
        this.dmnGraphUtils = dmnGraphUtils;
    }

    public DataType getTopLevelParent(DataType dataType) {
        String parentUUID = dataType.getParentUUID();
        Optional<DataType> parent = Optional.ofNullable(this.dataTypeStore.get(parentUUID));
        return parent.map(this::getTopLevelParent).orElse(dataType);
    }

    public List<DataType> defaultDataTypes() {
        return Stream.of(BuiltInType.values()).filter(builtInType -> !builtInType.equals((Object)BuiltInType.UNDEFINED)).map(bit -> this.dataTypeManager.from((BuiltInType)bit).get()).sorted(Comparator.comparing(DataType::getType)).collect(Collectors.toList());
    }

    public List<DataType> customDataTypes() {
        return this.dataTypeStore.getTopLevelDataTypes().stream().sorted(Comparator.comparing(DataType::getName)).collect(Collectors.toList());
    }

    public DataTypeKind getDataTypeKind(String typeName) {
        if (this.isIncludedType(typeName)) {
            return DataTypeKind.INCLUDED;
        }
        return this.findDataTypeByName(typeName).map(dataType -> this.isStructure((DataType)dataType) ? DataTypeKind.STRUCTURE : DataTypeKind.CUSTOM).orElse(DataTypeKind.BUILT_IN);
    }

    private Optional<DataType> findDataTypeByName(String typeName) {
        return this.dataTypeStore.getTopLevelDataTypes().stream().filter(dt -> dt.getName().equals(typeName)).findFirst();
    }

    private boolean isIncludedType(String typeName) {
        return this.getImportNames().stream().anyMatch(typeName::startsWith);
    }

    private boolean isStructure(DataType dataType) {
        return Objects.equals(this.dataTypeManager.structure(), dataType.getType());
    }

    private List<String> getImportNames() {
        return this.dmnGraphUtils.getModelDefinitions().getImport().stream().map(i -> i.getName().getValue()).collect(Collectors.toList());
    }
}

