/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.listview;

import com.google.gwt.event.dom.client.ClickEvent;
import elemental2.dom.Element;
import elemental2.dom.HTMLDivElement;
import elemental2.dom.HTMLElement;
import elemental2.dom.HTMLOptGroupElement;
import elemental2.dom.HTMLOptionElement;
import elemental2.dom.HTMLSelectElement;
import elemental2.dom.Node;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.dmn.api.editors.types.BuiltInTypeUtils;
import org.kie.workbench.common.dmn.client.editors.common.RemoveHelper;
import org.kie.workbench.common.dmn.client.editors.types.common.DataType;
import org.kie.workbench.common.dmn.client.editors.types.common.HiddenHelper;
import org.kie.workbench.common.dmn.client.editors.types.listview.DataTypeSelect;
import org.kie.workbench.common.dmn.client.editors.types.listview.tooltip.StructureTypesTooltip;
import org.uberfire.client.views.pfly.selectpicker.JQuerySelectPicker;
import org.uberfire.client.views.pfly.selectpicker.JQuerySelectPickerEvent;

@Dependent
@Templated
public class DataTypeSelectView
implements DataTypeSelect.View {
    static final String IS_BUILT_IN_TYPE_ATTR = "data-is-built-in-type";
    @DataField(value="type-text")
    private final HTMLDivElement typeText;
    @DataField(value="type-select")
    private final HTMLSelectElement typeSelect;
    @DataField(value="type-select-optgroup")
    private final HTMLOptGroupElement typeSelectOptGroup;
    @DataField(value="type-select-structure-optgroup")
    private final HTMLOptGroupElement typeSelectStructureOptGroup;
    @DataField(value="type-select-option")
    private final HTMLOptionElement typeSelectOption;
    private final TranslationService translationService;
    private final StructureTypesTooltip structureTypesTooltip;
    private DataTypeSelect presenter;
    private String value;

    @Inject
    public DataTypeSelectView(HTMLDivElement typeText, HTMLSelectElement typeSelect, HTMLOptGroupElement typeSelectOptGroup, HTMLOptionElement typeSelectOption, HTMLOptGroupElement typeSelectStructureOptGroup, TranslationService translationService, StructureTypesTooltip structureTypesTooltip) {
        this.typeText = typeText;
        this.typeSelect = typeSelect;
        this.typeSelectOptGroup = typeSelectOptGroup;
        this.typeSelectOption = typeSelectOption;
        this.typeSelectStructureOptGroup = typeSelectStructureOptGroup;
        this.translationService = translationService;
        this.structureTypesTooltip = structureTypesTooltip;
    }

    public void init(DataTypeSelect presenter) {
        this.presenter = presenter;
    }

    @Override
    public void setupDropdown() {
        this.setupDropdownItems();
        this.setupSelectPicker();
        this.hideSelectPicker();
        this.setupSelectPickerOnChangeHandler();
    }

    void setupDropdownItems() {
        RemoveHelper.removeChildren((Element)this.typeSelect);
        this.typeSelect.appendChild((Node)this.makeOptionStructureGroup());
        this.typeSelect.appendChild((Node)this.makeOptionGroup(this.defaultTitle(), this.presenter.getDefaultDataTypes(), DataType::getType));
        this.typeSelect.appendChild((Node)this.makeOptionGroup(this.customTitle(), this.presenter.getCustomDataTypes(), DataType::getName));
    }

    private String defaultTitle() {
        return this.translationService.format("DataTypeSelectView.DefaultTitle", new Object[0]);
    }

    private String customTitle() {
        return this.translationService.format("DataTypeSelectView.CustomTitle", new Object[0]);
    }

    HTMLOptGroupElement makeOptionGroup(String groupTitle, List<DataType> dataTypes, Function<DataType, String> dataTypeConsumer) {
        HTMLOptGroupElement optionGroup = this.makeHTMLOptGroupElement();
        optionGroup.label = groupTitle;
        dataTypes.stream().forEach(dataType -> {
            HTMLOptionElement option = this.makeOption((DataType)dataType, dataTypeConsumer);
            optionGroup.appendChild((Node)option);
        });
        return optionGroup;
    }

    HTMLOptGroupElement makeOptionStructureGroup() {
        return this.typeSelectStructureOptGroup;
    }

    HTMLOptionElement makeOption(DataType dataType, Function<DataType, String> dataTypeConsumer) {
        String optionValue = dataTypeConsumer.apply(dataType);
        HTMLOptionElement option = this.makeHTMLOptionElement();
        option.text = optionValue;
        option.value = optionValue;
        return option;
    }

    @Override
    public void enableEditMode() {
        HiddenHelper.hide((Element)this.typeText);
        this.showSelectPicker();
        this.setPickerValue(this.presenter.getDataType().getType());
    }

    @Override
    public void disableEditMode() {
        this.typeText.textContent = this.presenter.getDataType().getType();
        this.hideSelectPicker();
        HiddenHelper.show((Element)this.typeText);
    }

    @Override
    public void setDataType(DataType dataType) {
        String type = dataType.getType();
        this.typeText.setAttribute(IS_BUILT_IN_TYPE_ATTR, this.isBuiltInType(type));
        this.typeText.textContent = type;
        this.value = type;
    }

    public void onSelectChange(JQuerySelectPickerEvent event) {
        String newValue = event.target.value;
        if (!Objects.equals(newValue, this.getValue())) {
            this.setPickerValue(newValue);
            this.presenter.clearDataTypesList();
        }
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @EventHandler(value={"type-text"})
    public void onTypeTextClick(ClickEvent event) {
        String type = this.presenter.getDataType().getType();
        HTMLElement element = this.getElement();
        if (!this.isBuiltInType(type)) {
            this.structureTypesTooltip.show(element, type);
        }
        this.skipClickListeners(event);
    }

    private void skipClickListeners(ClickEvent event) {
        event.preventDefault();
        event.stopPropagation();
    }

    void setPickerValue(String value) {
        this.setPickerValue(this.getSelectPicker(), value);
        this.value = value;
    }

    HTMLOptionElement makeHTMLOptionElement() {
        return (HTMLOptionElement)this.typeSelectOption.cloneNode(false);
    }

    HTMLOptGroupElement makeHTMLOptGroupElement() {
        return (HTMLOptGroupElement)this.typeSelectOptGroup.cloneNode(false);
    }

    void setupSelectPickerOnChangeHandler() {
        this.setupOnChangeHandler(this.getSelectPicker());
    }

    void hideSelectPicker() {
        this.triggerPickerAction(this.getSelectPicker(), "destroy");
        this.triggerPickerAction(this.getSelectPicker(), "hide");
    }

    void showSelectPicker() {
        this.triggerPickerAction(this.getSelectPicker(), "show");
    }

    void setupSelectPicker() {
        this.triggerPickerAction(this.getSelectPicker(), "refresh");
    }

    Element getSelectPicker() {
        return this.getElement().querySelector("[data-field='type-select']");
    }

    void triggerPickerAction(Element element, String method) {
        JQuerySelectPicker.$((Element)element).selectpicker(method);
    }

    void setPickerValue(Element element, String value) {
        JQuerySelectPicker.$((Element)element).selectpicker("val", value);
    }

    void setupOnChangeHandler(Element element) {
        JQuerySelectPicker.$((Element)element).on("hidden.bs.select", this::onSelectChange);
    }

    private boolean isBuiltInType(String type) {
        return BuiltInTypeUtils.isBuiltInType((String)type) || Objects.equals(this.presenter.structure(), type);
    }
}

