/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.listview.constraint.enumeration;

import com.google.gwt.core.client.Scheduler;
import elemental2.dom.Element;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.jboss.errai.ui.client.local.api.elemental2.IsElement;
import org.kie.workbench.common.dmn.client.editors.types.common.ScrollHelper;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.DataTypeConstraintComponent;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.DataTypeConstraintParserWarningEvent;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.enumeration.item.DataTypeConstraintEnumerationItem;
import org.kie.workbench.common.dmn.client.service.DMNClientServicesProxy;
import org.kie.workbench.common.stunner.core.client.service.ClientRuntimeError;
import org.kie.workbench.common.stunner.core.client.service.ServiceCallback;
import org.kie.workbench.common.stunner.core.util.StringUtils;
import org.uberfire.client.mvp.UberElemental;
import org.uberfire.mvp.Command;

@Dependent
public class DataTypeConstraintEnumeration
implements DataTypeConstraintComponent {
    private static final String SEPARATOR = ", ";
    private final View view;
    private final DMNClientServicesProxy clientServicesProxy;
    private final ScrollHelper scrollHelper;
    private final Event<DataTypeConstraintParserWarningEvent> parserWarningEvent;
    private final ManagedInstance<DataTypeConstraintEnumerationItem> enumerationItemInstances;
    private List<DataTypeConstraintEnumerationItem> enumerationItems = new ArrayList<DataTypeConstraintEnumerationItem>();
    private String constraintValueType;
    private Command onCompleteCallback = this.defaultOnCompleteCallback();

    @Inject
    public DataTypeConstraintEnumeration(View view, DMNClientServicesProxy clientServicesProxy, ScrollHelper scrollHelper, Event<DataTypeConstraintParserWarningEvent> parserWarningEvent, ManagedInstance<DataTypeConstraintEnumerationItem> enumerationItemInstances) {
        this.view = view;
        this.clientServicesProxy = clientServicesProxy;
        this.scrollHelper = scrollHelper;
        this.parserWarningEvent = parserWarningEvent;
        this.enumerationItemInstances = enumerationItemInstances;
    }

    @PostConstruct
    void setup() {
        this.view.init(this);
    }

    @Override
    public String getValue() {
        this.refreshEnumerationItemsOrder();
        return this.getEnumerationItems().stream().map(DataTypeConstraintEnumerationItem::getValue).distinct().filter(itemValue -> !StringUtils.isEmpty((String)itemValue)).collect(Collectors.joining(SEPARATOR));
    }

    @Override
    public void setValue(String value) {
        this.clientServicesProxy.parseFEELList(value, new ServiceCallback<List<String>>(){

            public void onSuccess(List<String> item) {
                DataTypeConstraintEnumeration.this.loadConstraintValues(item);
                DataTypeConstraintEnumeration.this.executeOnCompleteCallback();
            }

            public void onError(ClientRuntimeError error) {
                DataTypeConstraintEnumeration.this.showWarningMessage();
                DataTypeConstraintEnumeration.this.loadConstraintValues(Collections.emptyList());
                DataTypeConstraintEnumeration.this.executeOnCompleteCallback();
            }
        });
    }

    @Override
    public void setConstraintValueType(String type) {
        this.constraintValueType = type;
    }

    public void refreshView() {
        this.setValue(this.getValue());
    }

    public void refreshView(Command onCompleteCallback) {
        this.registerOnCompleteCallback(onCompleteCallback);
        this.setValue(this.getValue());
    }

    void executeOnCompleteCallback() {
        this.onCompleteCallback.execute();
        this.registerOnCompleteCallback(this.defaultOnCompleteCallback());
    }

    void registerOnCompleteCallback(Command onCompleteCallback) {
        this.onCompleteCallback = onCompleteCallback;
    }

    private void showWarningMessage() {
        this.parserWarningEvent.fire((Object)new DataTypeConstraintParserWarningEvent());
    }

    private void loadConstraintValues(List<String> constraintValues) {
        this.setEnumerationItems(this.makeEnumerationItems(constraintValues));
        this.render();
        if (constraintValues.isEmpty()) {
            this.addEnumerationItem();
        }
    }

    @Override
    public Element getElement() {
        return this.view.getElement();
    }

    public void render() {
        this.scheduleRender(() -> {
            this.view.clear();
            this.getEnumerationItems().stream().sorted(Comparator.comparingInt(DataTypeConstraintEnumerationItem::getOrder)).forEach(enumerationItem -> this.view.addItem(enumerationItem.getElement()));
        });
    }

    void scheduleRender(Scheduler.ScheduledCommand command) {
        Scheduler.get().scheduleDeferred(command);
    }

    void addEnumerationItem() {
        DataTypeConstraintEnumerationItem enumerationItem = this.makeEnumerationItem("");
        enumerationItem.setOrder(this.getEnumerationItems().size());
        this.refreshEnumerationItemsOrder();
        this.getEnumerationItems().add(enumerationItem);
        this.render();
        this.scrollToBottom();
        enumerationItem.enableEditMode();
    }

    void refreshEnumerationItemsOrder() {
        this.setEnumerationItems(this.getEnumerationItems().stream().sorted(Comparator.comparingInt(DataTypeConstraintEnumerationItem::getOrder)).collect(Collectors.toList()));
    }

    DataTypeConstraintEnumerationItem makeEnumerationItem(String value) {
        DataTypeConstraintEnumerationItem enumerationItem = (DataTypeConstraintEnumerationItem)this.enumerationItemInstances.get();
        enumerationItem.setConstraintValueType(this.getConstraintValueType());
        enumerationItem.setValue(value);
        enumerationItem.setDataTypeConstraintEnumeration(this);
        return enumerationItem;
    }

    String getConstraintValueType() {
        return this.constraintValueType;
    }

    private List<DataTypeConstraintEnumerationItem> makeEnumerationItems(List<String> convert) {
        return convert.stream().map(this::makeEnumerationItem).collect(Collectors.toList());
    }

    public void scrollToPosition(int position) {
        this.getElementByPosition(position).ifPresent(element -> this.scrollHelper.scrollTo((Element)element, this.getElement()));
    }

    void scrollToBottom() {
        this.getLastEnumerationItem().ifPresent(last -> this.scrollToPosition(last.getOrder()));
    }

    private Optional<DataTypeConstraintEnumerationItem> getLastEnumerationItem() {
        return this.getEnumerationItems().stream().reduce((prev, next) -> next);
    }

    void setEnumerationItems(List<DataTypeConstraintEnumerationItem> enumerationItems) {
        this.enumerationItems = enumerationItems;
    }

    public List<DataTypeConstraintEnumerationItem> getEnumerationItems() {
        return this.enumerationItems;
    }

    private Optional<Element> getElementByPosition(int position) {
        return Optional.ofNullable(this.getElement().querySelector("[data-position=\"" + position + "\""));
    }

    Command defaultOnCompleteCallback() {
        return this::scrollToBottom;
    }

    public static interface View
    extends UberElemental<DataTypeConstraintEnumeration>,
    IsElement {
        public void clear();

        public void addItem(Element var1);
    }
}

