/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.persistence.handlers;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.kie.workbench.common.dmn.client.editors.types.common.DataType;
import org.kie.workbench.common.dmn.client.editors.types.common.DataTypeManager;
import org.kie.workbench.common.dmn.client.editors.types.persistence.DataTypeStore;
import org.kie.workbench.common.dmn.client.editors.types.persistence.handlers.DataTypeHandler;

@Dependent
public class DataTypeDestroyHandler
extends DataTypeHandler {
    @Inject
    public DataTypeDestroyHandler(DataTypeStore dataTypeStore, DataTypeManager dataTypeManager) {
        super(dataTypeStore, dataTypeManager);
    }

    public void destroy(DataType dataType) {
        Optional<DataType> dataTypeParent = Optional.ofNullable(this.parent(dataType));
        dataTypeParent.ifPresent(parent -> parent.getSubDataTypes().remove(dataType));
        this.unIndex(dataType);
    }

    public List<DataType> refreshDependentDataTypes(DataType dataType) {
        ArrayList<DataType> affectedDataTypes = new ArrayList<DataType>();
        affectedDataTypes.addAll(this.handleTopLevelDataTypes(dataType));
        affectedDataTypes.addAll(this.handleNestedDataTypes(dataType));
        return affectedDataTypes;
    }

    List<DataType> handleTopLevelDataTypes(DataType dataType) {
        ArrayList<DataType> affected = new ArrayList<DataType>();
        if (!dataType.isTopLevel()) {
            return affected;
        }
        List<DataType> dataTypesByType = this.getSubDataTypesByType(dataType.getName());
        for (DataType dt : dataTypesByType) {
            Optional<DataType> dataTypeParent = Optional.ofNullable(this.parent(dt));
            this.recordEngine.doDestroy(dt);
            affected.add(dataTypeParent.orElse(dt));
        }
        affected.add(dataType);
        return affected;
    }

    List<DataType> handleNestedDataTypes(DataType dataType) {
        ArrayList<DataType> affectedDataTypes = new ArrayList<DataType>();
        this.getClosestTopLevelDataType(dataType).ifPresent(topLevel -> {
            String type = topLevel.getName();
            affectedDataTypes.add((DataType)topLevel);
            if (!this.isStructure((DataType)topLevel)) {
                this.forEachSubDataTypesByTypeOrName(topLevel.getType(), affectedDataTypes::add);
            }
            this.forEachSubDataTypesByType(type, affectedDataTypes::add);
        });
        return affectedDataTypes;
    }

    private void unIndex(DataType dataType) {
        String uuid = dataType.getUUID();
        List<DataType> subDataTypes = dataType.getSubDataTypes();
        this.dataTypeStore.unIndex(uuid);
        subDataTypes.forEach(this::unIndex);
    }
}

