/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.persistence.handlers.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.kie.workbench.common.dmn.api.definition.HasExpression;
import org.kie.workbench.common.dmn.api.definition.HasTypeRef;
import org.kie.workbench.common.dmn.api.definition.HasVariable;
import org.kie.workbench.common.dmn.api.definition.model.common.HasTypeRefHelper;
import org.kie.workbench.common.dmn.api.property.dmn.QName;
import org.kie.workbench.common.stunner.core.client.api.SessionManager;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.event.selection.CanvasSelectionEvent;
import org.kie.workbench.common.stunner.core.client.canvas.event.selection.DomainObjectSelectionEvent;
import org.kie.workbench.common.stunner.core.client.session.ClientSession;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.view.ViewImpl;
import org.kie.workbench.common.stunner.forms.client.event.RefreshFormPropertiesEvent;

@ApplicationScoped
public class PropertiesPanelNotifier {
    private final Event<RefreshFormPropertiesEvent> refreshFormPropertiesEvent;
    private final SessionManager sessionManager;
    private String oldLocalPart;
    private QName newQName;
    private String selectedElementUUID = null;

    @Inject
    public PropertiesPanelNotifier(Event<RefreshFormPropertiesEvent> refreshFormPropertiesEvent, SessionManager sessionManager) {
        this.refreshFormPropertiesEvent = refreshFormPropertiesEvent;
        this.sessionManager = sessionManager;
    }

    public PropertiesPanelNotifier withOldLocalPart(String oldLocalPart) {
        this.oldLocalPart = oldLocalPart;
        return this;
    }

    public PropertiesPanelNotifier withNewQName(QName newQName) {
        this.newQName = newQName;
        return this;
    }

    public void notifyPanel() {
        for (Node node : this.getNodes()) {
            Object definition = this.getDefinition(node);
            this.notifyVariables(node, definition);
            this.notifyExpressions(node, definition);
        }
    }

    void onCanvasSelectionEvent(@Observes CanvasSelectionEvent event) {
        Collection identifiers = event.getIdentifiers();
        if (identifiers.size() > 0) {
            this.setSelectedElementUUID((String)identifiers.iterator().next());
        }
    }

    void onDomainObjectSelectionEvent(@Observes DomainObjectSelectionEvent event) {
        this.setSelectedElementUUID(event.getDomainObject().getDomainObjectUUID());
    }

    void notifyExpressions(Node node, Object definition) {
        if (definition instanceof HasExpression) {
            HasExpression hasExpression = this.asHasExpression(definition);
            List hasTypeRefs = HasTypeRefHelper.getNotNullHasTypeRefs((HasTypeRef)hasExpression.getExpression());
            for (HasTypeRef hasTypeRef : hasTypeRefs) {
                this.notifyOutdatedElement(node, hasTypeRef);
            }
        }
    }

    void notifyVariables(Node node, Object definition) {
        if (definition instanceof HasVariable) {
            this.notifyOutdatedElement(node, (HasTypeRef)this.asHasVariable(definition).getVariable());
        }
    }

    void notifyOutdatedElement(Node node, HasTypeRef elementTypeRef) {
        Optional<QName> typeRef = Optional.ofNullable(elementTypeRef.getTypeRef());
        boolean isOutdated = typeRef.map(type -> Objects.equals(type.getLocalPart(), this.oldLocalPart)).orElse(false);
        if (isOutdated) {
            elementTypeRef.setTypeRef(this.newQName);
            this.refreshFormProperties(node);
        }
    }

    void refreshFormProperties(Node node) {
        ClientSession currentSession = this.getCurrentSession().orElseThrow(UnsupportedOperationException::new);
        String uuid = node.getUUID();
        this.getSelectedElementUUID().ifPresent(selectedElementUUID -> {
            if (Objects.equals(uuid, selectedElementUUID)) {
                this.refreshFormPropertiesEvent.fire((Object)new RefreshFormPropertiesEvent(currentSession, uuid));
            }
        });
    }

    Object getDefinition(Node node) {
        ViewImpl content = (ViewImpl)node.getContent();
        return content.getDefinition();
    }

    List<Node> getNodes() {
        ArrayList<Node> nodes = new ArrayList<Node>();
        this.getGraph().ifPresent(graph -> graph.nodes().forEach(nodes::add));
        return nodes;
    }

    Optional<Graph<?, Node>> getGraph() {
        Optional<CanvasHandler> canvasHandler = this.getCurrentSession().map(ClientSession::getCanvasHandler);
        Optional<Diagram> diagram = canvasHandler.map(CanvasHandler::getDiagram);
        return diagram.map(Diagram::getGraph);
    }

    void setSelectedElementUUID(String selectedElementUUID) {
        this.selectedElementUUID = selectedElementUUID;
    }

    Optional<String> getSelectedElementUUID() {
        return Optional.ofNullable(this.selectedElementUUID);
    }

    private Optional<ClientSession> getCurrentSession() {
        return Optional.ofNullable(this.sessionManager.getCurrentSession());
    }

    private HasExpression asHasExpression(Object definition) {
        return (HasExpression)definition;
    }

    private HasVariable asHasVariable(Object definition) {
        return (HasVariable)definition;
    }
}

