/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.graph;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.kie.workbench.common.dmn.api.definition.model.DRGElement;
import org.kie.workbench.common.dmn.api.definition.model.Definitions;
import org.kie.workbench.common.dmn.api.graph.DMNDiagramUtils;
import org.kie.workbench.common.dmn.client.docks.navigator.drds.DMNDiagramsSession;
import org.kie.workbench.common.stunner.core.client.api.SessionManager;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasHandler;
import org.kie.workbench.common.stunner.core.client.session.ClientSession;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.graph.Node;

@Dependent
public class DMNGraphUtils {
    private static CanvasHandler NO_CANVAS_HANDLER = null;
    private SessionManager sessionManager;
    private DMNDiagramUtils dmnDiagramUtils;
    private DMNDiagramsSession dmnDiagramsSession;

    public DMNGraphUtils() {
    }

    @Inject
    public DMNGraphUtils(SessionManager sessionManager, DMNDiagramUtils dmnDiagramUtils, DMNDiagramsSession dmnDiagramsSession) {
        this.sessionManager = sessionManager;
        this.dmnDiagramUtils = dmnDiagramUtils;
        this.dmnDiagramsSession = dmnDiagramsSession;
    }

    public Definitions getModelDefinitions() {
        return Optional.ofNullable(this.dmnDiagramsSession.getDRGDiagram()).map(e -> this.dmnDiagramUtils.getDefinitions(e)).orElse(null);
    }

    public List<DRGElement> getModelDRGElements() {
        return Optional.ofNullable(this.dmnDiagramsSession.getModelDRGElements()).orElse(new ArrayList());
    }

    public Definitions getDefinitions(Diagram diagram) {
        return this.dmnDiagramUtils.getDefinitions(diagram);
    }

    public List<DRGElement> getDRGElements(Diagram diagram) {
        return this.dmnDiagramUtils.getDRGElements(diagram);
    }

    public Stream<Node> getNodeStream(Diagram diagram) {
        return this.dmnDiagramUtils.getNodeStream(diagram);
    }

    public Optional<ClientSession> getCurrentSession() {
        return Optional.ofNullable(this.sessionManager.getCurrentSession());
    }

    private Optional<CanvasHandler> getCanvasHandler(ClientSession session) {
        return Optional.ofNullable(session.getCanvasHandler());
    }

    public Stream<Node> getNodeStream() {
        return this.getNodeStream(this.dmnDiagramsSession.getCurrentGraphDiagram());
    }

    public CanvasHandler getCanvasHandler() {
        return this.getCurrentSession().map(clientSession -> this.getCanvasHandler((ClientSession)clientSession).orElse(NO_CANVAS_HANDLER)).orElse(NO_CANVAS_HANDLER);
    }
}

