/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.marshaller;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONString;
import com.google.gwt.json.client.JSONValue;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import javax.xml.namespace.QName;
import jsinterop.base.Js;
import org.guvnor.common.services.project.client.context.WorkspaceProjectContext;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.kie.workbench.common.dmn.api.DMNDefinitionSet;
import org.kie.workbench.common.dmn.api.definition.model.DMNDiagram;
import org.kie.workbench.common.dmn.api.definition.model.DMNDiagramElement;
import org.kie.workbench.common.dmn.api.factory.DMNDiagramFactory;
import org.kie.workbench.common.dmn.client.DMNShapeSet;
import org.kie.workbench.common.dmn.client.docks.navigator.drds.DMNDiagramSelected;
import org.kie.workbench.common.dmn.client.docks.navigator.drds.DMNDiagramsSession;
import org.kie.workbench.common.dmn.client.docks.navigator.drds.DRGDiagramUtils;
import org.kie.workbench.common.dmn.client.marshaller.common.DMNGraphUtils;
import org.kie.workbench.common.dmn.client.marshaller.marshall.DMNMarshaller;
import org.kie.workbench.common.dmn.client.marshaller.unmarshall.DMNUnmarshaller;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.MainJs;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.callbacks.DMN12MarshallCallback;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.callbacks.DMN12UnmarshallCallback;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.DMN12;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITDefinitions;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.mapper.JSIName;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.mapper.JsUtils;
import org.kie.workbench.common.stunner.core.api.DefinitionManager;
import org.kie.workbench.common.stunner.core.client.service.ClientRuntimeError;
import org.kie.workbench.common.stunner.core.client.service.ServiceCallback;
import org.kie.workbench.common.stunner.core.definition.adapter.binding.BindableAdapterUtils;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.DiagramParsingException;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.diagram.MetadataImpl;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.util.StringUtils;
import org.uberfire.backend.vfs.Path;
import org.uberfire.backend.vfs.PathFactory;
import org.uberfire.client.promise.Promises;

@Dependent
public class DMNMarshallerService {
    private static final String ROOT = "default://master@system/stunner/diagrams";
    private final DMNUnmarshaller dmnUnmarshaller;
    private final DMNMarshaller dmnMarshaller;
    private final DMNDiagramFactory dmnDiagramFactory;
    private final DefinitionManager definitionManager;
    private final Promises promises;
    private final DMNDiagramsSession dmnDiagramsSession;
    private final WorkspaceProjectContext projectContext;
    private ServiceCallback<Diagram> onDiagramLoad = this.emptyService();
    private Metadata metadata;

    @Inject
    public DMNMarshallerService(DMNUnmarshaller dmnUnmarshaller, DMNMarshaller dmnMarshaller, DMNDiagramFactory dmnDiagramFactory, DefinitionManager definitionManager, Promises promises, DMNDiagramsSession dmnDiagramsSession, WorkspaceProjectContext projectContext) {
        this.dmnUnmarshaller = dmnUnmarshaller;
        this.dmnMarshaller = dmnMarshaller;
        this.dmnDiagramFactory = dmnDiagramFactory;
        this.definitionManager = definitionManager;
        this.promises = promises;
        this.dmnDiagramsSession = dmnDiagramsSession;
        this.projectContext = projectContext;
    }

    public void unmarshall(Path path, String xml, ServiceCallback<Diagram> callback) {
        this.unmarshall(this.buildMetadataInstance(path), xml, callback);
    }

    public void unmarshall(Metadata metadata, String xml, ServiceCallback<Diagram> callback) {
        this.setOnDiagramLoad(callback);
        this.setMetadata(metadata);
        try {
            DMN12UnmarshallCallback jsCallback = dmn12 -> {
                JSITDefinitions definitions = (JSITDefinitions)Js.uncheckedCast((Object)JsUtils.getUnwrappedElement((Object)dmn12));
                this.dmnUnmarshaller.unmarshall(this.getMetadata(), definitions).then(graph -> {
                    String fileName = this.getMetadata().getPath().getFileName();
                    this.onDiagramLoad(this.dmnDiagramFactory.build(fileName, this.getMetadata(), graph));
                    return this.promises.resolve();
                });
            };
            MainJs.unmarshall((String)xml, (String)"", (DMN12UnmarshallCallback)jsCallback);
        }
        catch (Exception e) {
            GWT.log((String)e.getMessage(), (Throwable)e);
            callback.onError(new ClientRuntimeError((Throwable)new DiagramParsingException(this.getMetadata(), xml)));
        }
    }

    public void marshall(Diagram diagram, ServiceCallback<String> contentServiceCallback) {
        DMN12MarshallCallback jsCallback = result -> {
            String prefix = "<?xml version=\"1.0\" ?>";
            String xml = result.startsWith("<?xml version=\"1.0\" ?>") ? result : "<?xml version=\"1.0\" ?>" + result;
            contentServiceCallback.onSuccess((Object)xml);
        };
        if (Objects.isNull(diagram)) {
            contentServiceCallback.onError(new ClientRuntimeError("The Diagram cannot be null."));
            return;
        }
        Graph graph = diagram.getGraph();
        if (Objects.isNull(graph)) {
            contentServiceCallback.onError(new ClientRuntimeError("The Diagram graph cannot be null."));
            return;
        }
        try {
            JSITDefinitions jsitDefinitions = this.dmnMarshaller.marshall();
            DMN12 dmn12 = (DMN12)Js.uncheckedCast((Object)JsUtils.newWrappedInstance());
            JsUtils.setNameOnWrapped((Object)dmn12, (JSIName)this.makeJSINameForDMN12());
            JsUtils.setValueOnWrapped((Object)dmn12, (Object)jsitDefinitions);
            JavaScriptObject namespaces = this.createNamespaces(jsitDefinitions.getOtherAttributes(), jsitDefinitions.getNamespace());
            MainJs.marshall((DMN12)dmn12, (JavaScriptObject)namespaces, (DMN12MarshallCallback)jsCallback);
        }
        catch (Exception e) {
            contentServiceCallback.onError(new ClientRuntimeError("Error during the marshaller: " + e.getMessage()));
        }
    }

    public void registerDiagramInstance(Diagram diagram, String title, String shapeSetId) {
        this.registerMetadata(diagram, title, shapeSetId);
        Node<?, ?> dmnDiagramRoot = DMNGraphUtils.findDMNDiagramRoot(diagram.getGraph());
        DMNDiagram definition = (DMNDiagram)((View)dmnDiagramRoot.getContent()).getDefinition();
        DMNDiagramElement drgDiagram = DRGDiagramUtils.newDRGInstance();
        String diagramId = drgDiagram.getId().getValue();
        HashMap<String, Diagram> diagramsByDiagramElementId = new HashMap<String, Diagram>();
        HashMap<String, DMNDiagramElement> dmnDiagramsByDiagramElementId = new HashMap<String, DMNDiagramElement>();
        definition.getDefinitions().getDiagramElements().add(drgDiagram);
        diagramsByDiagramElementId.put(diagramId, diagram);
        dmnDiagramsByDiagramElementId.put(diagramId, drgDiagram);
        this.dmnDiagramsSession.setState(this.getMetadata(), diagramsByDiagramElementId, dmnDiagramsByDiagramElementId);
    }

    private JavaScriptObject createNamespaces(Map<QName, String> otherAttributes, String defaultNamespace) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put(defaultNamespace, (JSONValue)new JSONString(""));
        otherAttributes.forEach((key, value) -> jsonObject.put(value, (JSONValue)new JSONString(key.getLocalPart())));
        return jsonObject.getJavaScriptObject();
    }

    private JSIName makeJSINameForDMN12() {
        JSIName jsiName = JSITDefinitions.getJSIName();
        jsiName.setPrefix("dmn");
        jsiName.setLocalPart("definitions");
        String key = "{" + jsiName.getNamespaceURI() + "}" + jsiName.getLocalPart();
        String keyString = "{" + jsiName.getNamespaceURI() + "}" + jsiName.getPrefix() + ":" + jsiName.getLocalPart();
        jsiName.setKey(key);
        jsiName.setString(keyString);
        return jsiName;
    }

    public void onDiagramSelected(@Observes DMNDiagramSelected selected) {
        DMNDiagramElement dmnDiagramElement = selected.getDiagramElement();
        if (this.isActiveService()) {
            String diagramId = dmnDiagramElement.getId().getValue();
            Diagram stunnerDiagram = this.dmnDiagramsSession.getDiagram(diagramId);
            Metadata metadata = this.dmnDiagramsSession.getDRGDiagram().getMetadata();
            String fileName = metadata.getPath().getFileName();
            Diagram diagram = this.dmnDiagramFactory.build(fileName, metadata, stunnerDiagram.getGraph());
            this.onDiagramLoad(diagram);
        }
    }

    private boolean isActiveService() {
        String serviceKey = this.dmnDiagramsSession.getSessionKey(this.getMetadata());
        String currentKey = this.dmnDiagramsSession.getCurrentSessionKey();
        return Objects.equals(serviceKey, currentKey);
    }

    private Metadata buildMetadataInstance(Path path) {
        String defSetId = BindableAdapterUtils.getDefinitionSetId(DMNDefinitionSet.class);
        String shapeSetId = BindableAdapterUtils.getShapeSetId(DMNShapeSet.class);
        Path root = this.getRoot();
        return new MetadataImpl.MetadataImplBuilder(defSetId, this.definitionManager).setRoot(root).setPath(path).setShapeSetId(shapeSetId).build();
    }

    private Path getRoot() {
        WorkspaceProject workspaceProject = this.getWorkspaceProject();
        return workspaceProject == null ? PathFactory.newPath((String)".", (String)ROOT) : workspaceProject.getRootPath();
    }

    private WorkspaceProject getWorkspaceProject() {
        return this.projectContext.getActiveWorkspaceProject().orElse(null);
    }

    private void updateClientShapeSetId(Diagram diagram) {
        Metadata metadata;
        if (Objects.nonNull(diagram) && Objects.nonNull(metadata = diagram.getMetadata()) && StringUtils.isEmpty((String)metadata.getShapeSetId())) {
            String shapeSetId = BindableAdapterUtils.getShapeSetId(DMNShapeSet.class);
            metadata.setShapeSetId(shapeSetId);
        }
    }

    private void registerMetadata(Diagram diagram, String title, String shapeSetId) {
        Metadata metadata = diagram.getMetadata();
        metadata.setShapeSetId(shapeSetId);
        metadata.setTitle(title);
        this.setMetadata(metadata);
    }

    private void setMetadata(Metadata metadata) {
        this.metadata = metadata;
    }

    private Metadata getMetadata() {
        return this.metadata;
    }

    public void setOnDiagramLoad(ServiceCallback<Diagram> onDiagramLoad) {
        this.onDiagramLoad = onDiagramLoad;
    }

    private void onDiagramLoad(Diagram diagram) {
        this.updateClientShapeSetId(diagram);
        this.onDiagramLoad.onSuccess((Object)diagram);
    }

    private ServiceCallback<Diagram> emptyService() {
        return new ServiceCallback<Diagram>(){

            public void onSuccess(Diagram item) {
            }

            public void onError(ClientRuntimeError error) {
            }
        };
    }
}

