/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.marshaller.converters;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import jsinterop.base.Js;
import org.kie.workbench.common.dmn.api.definition.model.DMNModelInstrumentedBase;
import org.kie.workbench.common.dmn.api.definition.model.DRGElement;
import org.kie.workbench.common.dmn.api.definition.model.InformationItemPrimary;
import org.kie.workbench.common.dmn.api.definition.model.InputData;
import org.kie.workbench.common.dmn.api.property.dimensions.GeneralRectangleDimensionsSet;
import org.kie.workbench.common.dmn.api.property.dmn.Description;
import org.kie.workbench.common.dmn.api.property.dmn.Id;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.dmn.api.property.styling.StylingSet;
import org.kie.workbench.common.dmn.client.marshaller.converters.DMNExternalLinksToExtensionElements;
import org.kie.workbench.common.dmn.client.marshaller.converters.DescriptionPropertyConverter;
import org.kie.workbench.common.dmn.client.marshaller.converters.IdPropertyConverter;
import org.kie.workbench.common.dmn.client.marshaller.converters.InformationItemPrimaryPropertyConverter;
import org.kie.workbench.common.dmn.client.marshaller.converters.NodeConverter;
import org.kie.workbench.common.dmn.client.marshaller.unmarshall.nodes.NodeEntry;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITDRGElement;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITInformationItem;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITInputData;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.kie.JSITComponentWidths;
import org.kie.workbench.common.stunner.core.api.FactoryManager;
import org.kie.workbench.common.stunner.core.definition.adapter.binding.BindableAdapterUtils;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.util.DefinitionUtils;

public class InputDataConverter
implements NodeConverter<JSITInputData, InputData> {
    private FactoryManager factoryManager;

    public InputDataConverter(FactoryManager factoryManager) {
        this.factoryManager = factoryManager;
    }

    @Override
    public Node<View<InputData>, ?> nodeFromDMN(NodeEntry nodeEntry) {
        JSITInputData dmn = (JSITInputData)Js.uncheckedCast((Object)nodeEntry.getDmnElement());
        Node node = this.factoryManager.newElement(nodeEntry.getId(), BindableAdapterUtils.getDefinitionId(InputData.class)).asNode();
        Id id = IdPropertyConverter.wbFromDMN(dmn.getId());
        Description description = DescriptionPropertyConverter.wbFromDMN(dmn.getDescription());
        Name name = new Name(dmn.getName());
        InformationItemPrimary informationItem = InformationItemPrimaryPropertyConverter.wbFromDMN(dmn.getVariable(), dmn);
        InputData inputData = new InputData(id, description, name, informationItem, new StylingSet(), new GeneralRectangleDimensionsSet());
        inputData.setDiagramId(nodeEntry.getDiagramId());
        ((View)node.getContent()).setDefinition((Object)inputData);
        if (Objects.nonNull(informationItem)) {
            informationItem.setParent((DMNModelInstrumentedBase)inputData);
        }
        DMNExternalLinksToExtensionElements.loadExternalLinksFromExtensionElements((JSITDRGElement)dmn, (DRGElement)inputData);
        return node;
    }

    @Override
    public JSITInputData dmnFromNode(Node<View<InputData>, ?> node, Consumer<JSITComponentWidths> componentWidthsConsumer) {
        InputData source = (InputData)DefinitionUtils.getElementDefinition(node);
        JSITInputData result = new JSITInputData();
        result.setId(source.getId().getValue());
        Optional<String> description = Optional.ofNullable(DescriptionPropertyConverter.dmnFromWB(source.getDescription()));
        description.ifPresent(arg_0 -> ((JSITInputData)result).setDescription(arg_0));
        result.setName(source.getName().getValue());
        JSITInformationItem variable = InformationItemPrimaryPropertyConverter.dmnFromWB(source.getVariable(), (DMNModelInstrumentedBase)source);
        result.setVariable(variable);
        DMNExternalLinksToExtensionElements.loadExternalLinksIntoExtensionElements((DRGElement)source, (JSITDRGElement)result);
        return result;
    }
}

