/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.marshaller.converters;

import java.util.Objects;
import org.kie.workbench.common.dmn.api.definition.model.DMNModelInstrumentedBase;
import org.kie.workbench.common.dmn.api.definition.model.ImportedValues;
import org.kie.workbench.common.dmn.api.definition.model.IsLiteralExpression;
import org.kie.workbench.common.dmn.api.definition.model.LiteralExpression;
import org.kie.workbench.common.dmn.api.property.dmn.Description;
import org.kie.workbench.common.dmn.api.property.dmn.ExpressionLanguage;
import org.kie.workbench.common.dmn.api.property.dmn.Id;
import org.kie.workbench.common.dmn.api.property.dmn.QName;
import org.kie.workbench.common.dmn.api.property.dmn.Text;
import org.kie.workbench.common.dmn.client.marshaller.converters.DescriptionPropertyConverter;
import org.kie.workbench.common.dmn.client.marshaller.converters.ExpressionLanguagePropertyConverter;
import org.kie.workbench.common.dmn.client.marshaller.converters.IdPropertyConverter;
import org.kie.workbench.common.dmn.client.marshaller.converters.ImportedValuesConverter;
import org.kie.workbench.common.dmn.client.marshaller.converters.QNamePropertyConverter;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITImportedValues;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITLiteralExpression;
import org.kie.workbench.common.stunner.core.util.StringUtils;

public class LiteralExpressionPropertyConverter {
    static JSITLiteralExpressionFactory LITERAL_EXPRESSION_PROVIDER = new JSITLiteralExpressionFactory();

    public static LiteralExpression wbFromDMN(JSITLiteralExpression dmn) {
        if (Objects.isNull(dmn)) {
            return null;
        }
        Id id = IdPropertyConverter.wbFromDMN(dmn.getId());
        Description description = DescriptionPropertyConverter.wbFromDMN(dmn.getDescription());
        QName typeRef = QNamePropertyConverter.wbFromDMN(dmn.getTypeRef());
        Text text = new Text(Objects.nonNull(dmn.getText()) ? dmn.getText() : "");
        ExpressionLanguage expressionLanguage = ExpressionLanguagePropertyConverter.wbFromDMN(dmn.getExpressionLanguage());
        ImportedValues importedValues = ImportedValuesConverter.wbFromDMN(dmn.getImportedValues());
        LiteralExpression result = new LiteralExpression(id, description, typeRef, text, importedValues, expressionLanguage);
        if (Objects.nonNull(importedValues)) {
            importedValues.setParent((DMNModelInstrumentedBase)result);
        }
        return result;
    }

    public static JSITLiteralExpression dmnFromWB(IsLiteralExpression wb) {
        String expressionLanguage;
        if (Objects.isNull(wb)) {
            return null;
        }
        JSITLiteralExpression result = LITERAL_EXPRESSION_PROVIDER.make();
        result.setId(wb.getId().getValue());
        String description = wb.getDescription().getValue();
        if (StringUtils.nonEmpty((String)description)) {
            result.setDescription(description);
        }
        if (wb instanceof LiteralExpression && StringUtils.nonEmpty((String)(expressionLanguage = ((LiteralExpression)wb).getExpressionLanguage().getValue()))) {
            result.setExpressionLanguage(expressionLanguage);
        }
        QNamePropertyConverter.setDMNfromWB(wb.getTypeRef(), arg_0 -> ((JSITLiteralExpression)result).setTypeRef(arg_0));
        result.setText(wb.getText().getValue());
        JSITImportedValues importedValues = ImportedValuesConverter.dmnFromWB(wb.getImportedValues());
        if (Objects.nonNull(importedValues)) {
            result.setImportedValues(importedValues);
        }
        return result;
    }

    static class JSITLiteralExpressionFactory {
        JSITLiteralExpressionFactory() {
        }

        JSITLiteralExpression make() {
            return new JSITLiteralExpression();
        }
    }
}

