/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.marshaller.converters;

import java.util.Objects;
import java.util.Optional;
import org.kie.workbench.common.dmn.api.definition.model.DMNModelInstrumentedBase;
import org.kie.workbench.common.dmn.api.definition.model.OutputClause;
import org.kie.workbench.common.dmn.api.definition.model.OutputClauseLiteralExpression;
import org.kie.workbench.common.dmn.api.definition.model.OutputClauseUnaryTests;
import org.kie.workbench.common.dmn.api.property.dmn.Description;
import org.kie.workbench.common.dmn.api.property.dmn.Id;
import org.kie.workbench.common.dmn.api.property.dmn.QName;
import org.kie.workbench.common.dmn.client.marshaller.converters.DescriptionPropertyConverter;
import org.kie.workbench.common.dmn.client.marshaller.converters.IdPropertyConverter;
import org.kie.workbench.common.dmn.client.marshaller.converters.OutputClauseLiteralExpressionPropertyConverter;
import org.kie.workbench.common.dmn.client.marshaller.converters.OutputClauseUnaryTestsPropertyConverter;
import org.kie.workbench.common.dmn.client.marshaller.converters.QNamePropertyConverter;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITLiteralExpression;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITOutputClause;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITUnaryTests;
import org.kie.workbench.common.stunner.core.util.StringUtils;

public class OutputClausePropertyConverter {
    public static OutputClause wbFromDMN(JSITOutputClause dmn) {
        Id id = IdPropertyConverter.wbFromDMN(dmn.getId());
        Description description = DescriptionPropertyConverter.wbFromDMN(dmn.getDescription());
        OutputClauseUnaryTests outputValues = OutputClauseUnaryTestsPropertyConverter.wbFromDMN(dmn.getOutputValues());
        OutputClauseLiteralExpression defaultOutputEntry = OutputClauseLiteralExpressionPropertyConverter.wbFromDMN(dmn.getDefaultOutputEntry());
        QName typeRef = QNamePropertyConverter.wbFromDMN(dmn.getTypeRef());
        OutputClause result = new OutputClause();
        result.setId(id);
        result.setName(dmn.getName());
        result.setDescription(description);
        result.setOutputValues(outputValues);
        result.setDefaultOutputEntry(defaultOutputEntry);
        result.setTypeRef(typeRef);
        if (Objects.nonNull(outputValues)) {
            outputValues.setParent((DMNModelInstrumentedBase)result);
        }
        if (Objects.nonNull(defaultOutputEntry)) {
            defaultOutputEntry.setParent((DMNModelInstrumentedBase)result);
        }
        return result;
    }

    public static JSITOutputClause dmnFromWB(OutputClause wb) {
        JSITLiteralExpression defaultOutputEntry;
        JSITOutputClause result = new JSITOutputClause();
        result.setId(wb.getId().getValue());
        result.setName(wb.getName());
        Optional<String> description = Optional.ofNullable(DescriptionPropertyConverter.dmnFromWB(wb.getDescription()));
        description.ifPresent(arg_0 -> ((JSITOutputClause)result).setDescription(arg_0));
        JSITUnaryTests outputValues = OutputClauseUnaryTestsPropertyConverter.dmnFromWB(wb.getOutputValues());
        if (Objects.nonNull(outputValues) && StringUtils.nonEmpty((String)outputValues.getText())) {
            result.setOutputValues(outputValues);
        }
        if (Objects.nonNull(defaultOutputEntry = OutputClauseLiteralExpressionPropertyConverter.dmnFromWB(wb.getDefaultOutputEntry())) && StringUtils.nonEmpty((String)defaultOutputEntry.getText())) {
            result.setDefaultOutputEntry(defaultOutputEntry);
        }
        QNamePropertyConverter.setDMNfromWB(wb.getTypeRef(), arg_0 -> ((JSITOutputClause)result).setTypeRef(arg_0));
        return result;
    }
}

