/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.widgets.grid.controls.list;

import java.util.function.Consumer;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.common.client.dom.DOMTokenList;
import org.jboss.errai.common.client.dom.ListItem;
import org.jboss.errai.common.client.dom.Span;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.list.ListSelectorTextItemView;
import org.uberfire.client.workbench.ouia.OuiaAttribute;
import org.uberfire.client.workbench.ouia.OuiaComponentIdAttribute;
import org.uberfire.client.workbench.ouia.OuiaComponentTypeAttribute;
import org.uberfire.mvp.Command;

@Templated
@Dependent
public class ListSelectorTextItemViewImpl
implements ListSelectorTextItemView {
    private static final String TEXT_MUTED = "text-muted";
    @DataField(value="item")
    private ListItem item;
    @DataField
    private Span text;

    public ListSelectorTextItemViewImpl() {
    }

    @Inject
    public ListSelectorTextItemViewImpl(ListItem item, Span text) {
        this.item = item;
        this.text = text;
        this.initOuiaComponentAttributes();
    }

    @Override
    public void setText(String text) {
        this.text.setTextContent(text);
        this.ouiaAttributeRenderer().accept((OuiaAttribute)this.ouiaComponentId());
    }

    @Override
    public void setEnabled(boolean enabled) {
        DOMTokenList classList = this.text.getClassList();
        if (enabled) {
            classList.remove(TEXT_MUTED);
        } else {
            classList.add(TEXT_MUTED);
        }
    }

    @Override
    public void addClickHandler(Command command) {
        this.item.addEventListener("click", e -> command.execute(), false);
    }

    public OuiaComponentTypeAttribute ouiaComponentType() {
        return new OuiaComponentTypeAttribute("dmn-grid-context-menu-item");
    }

    public OuiaComponentIdAttribute ouiaComponentId() {
        return new OuiaComponentIdAttribute("dmn-grid-context-menu-item-" + this.text.getTextContent());
    }

    public Consumer<OuiaAttribute> ouiaAttributeRenderer() {
        return ouiaAttribute -> this.item.setAttribute(ouiaAttribute.getName(), ouiaAttribute.getValue());
    }
}

