/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.widgets.grid.handlers;

import com.ait.lienzo.client.core.event.AbstractNodeMouseEvent;
import com.ait.lienzo.client.core.types.Point2D;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.kie.workbench.common.dmn.client.editors.expressions.util.DynamicReadOnlyUtils;
import org.kie.workbench.common.dmn.client.widgets.grid.model.GridCellTuple;
import org.uberfire.ext.wires.core.grids.client.model.GridCell;
import org.uberfire.ext.wires.core.grids.client.model.GridCellEditAction;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.grid.impl.DefaultGridWidgetEditCellMouseEventHandler;

public class DelegatingGridWidgetEditCellMouseEventHandler
extends DefaultGridWidgetEditCellMouseEventHandler {
    private final Supplier<GridCellTuple> parentSupplier;
    private final Supplier<Integer> nestingSupplier;

    public DelegatingGridWidgetEditCellMouseEventHandler(Supplier<GridCellTuple> parentSupplier, Supplier<Integer> nestingSupplier) {
        this.parentSupplier = parentSupplier;
        this.nestingSupplier = nestingSupplier;
    }

    public boolean onNodeMouseEvent(GridWidget gridWidget, Point2D relativeLocation, Optional<Integer> uiHeaderRowIndex, Optional<Integer> uiHeaderColumnIndex, Optional<Integer> uiRowIndex, Optional<Integer> uiColumnIndex, AbstractNodeMouseEvent event) {
        if (DynamicReadOnlyUtils.isOnlyVisualChangeAllowed(gridWidget)) {
            return false;
        }
        if (this.nestingSupplier.get() == 0) {
            return this.doSuperOnNodeMouseEvent(gridWidget, relativeLocation, uiHeaderRowIndex, uiHeaderColumnIndex, uiRowIndex, uiColumnIndex, event);
        }
        boolean isHandled = false;
        if (uiRowIndex.isPresent() && uiColumnIndex.isPresent()) {
            isHandled = this.delegatedHandleBodyCell(gridWidget, relativeLocation, uiRowIndex.get(), uiColumnIndex.get(), event);
        }
        return isHandled;
    }

    boolean doSuperOnNodeMouseEvent(GridWidget gridWidget, Point2D relativeLocation, Optional<Integer> uiHeaderRowIndex, Optional<Integer> uiHeaderColumnIndex, Optional<Integer> uiRowIndex, Optional<Integer> uiColumnIndex, AbstractNodeMouseEvent event) {
        return super.onNodeMouseEvent(gridWidget, relativeLocation, uiHeaderRowIndex, uiHeaderColumnIndex, uiRowIndex, uiColumnIndex, event);
    }

    private boolean delegatedHandleBodyCell(GridWidget gridWidget, Point2D relativeLocation, int uiRowIndex, int uiColumnIndex, AbstractNodeMouseEvent event) {
        GridCellTuple parent = this.parentSupplier.get();
        GridWidget parentGridWidget = parent.getGridWidget();
        GridData parentGridData = parentGridWidget.getModel();
        if (parentGridData.getSelectedCells().size() == 1) {
            GridCellEditAction cellEditAction;
            GridData gridData = gridWidget.getModel();
            GridCell cell = gridData.getCell(uiRowIndex, uiColumnIndex);
            GridCellEditAction gridCellEditAction = cellEditAction = cell == null ? GridCell.DEFAULT_EDIT_ACTION : cell.getSupportedEditAction();
            if (this.isEventHandled(cellEditAction, event)) {
                return gridWidget.startEditingCell(relativeLocation);
            }
        }
        return false;
    }

    boolean isEventHandled(GridCellEditAction cellEditAction, AbstractNodeMouseEvent event) {
        return Objects.equals(cellEditAction, GridCellEditAction.getSupportedEditAction((AbstractNodeMouseEvent)event));
    }
}

