/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.canvas.controls.actions;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.model.DMNDiagram;
import org.kie.workbench.common.dmn.api.definition.model.Definitions;
import org.kie.workbench.common.dmn.api.definition.model.TextAnnotation;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.dmn.api.property.dmn.NameHolder;
import org.kie.workbench.common.dmn.client.canvas.controls.actions.DMNDiagramTextPropertyProviderImpl;
import org.kie.workbench.common.dmn.client.commands.factory.DefaultCanvasCommandFactory;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.controls.actions.TextPropertyProvider;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommand;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandManager;
import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;
import org.kie.workbench.common.stunner.core.util.DefinitionUtils;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.Silent.class)
public class DMNDiagramTextPropertyProviderImplTest {
    private static final String NAME_FIELD = "name";
    private static final String NAME_VALUE = "text";
    private static final String NAME_VALUE_WITH_WHITESPACE = "   text   ";
    @Mock
    private DefinitionUtils definitionUtils;
    @Mock
    private DefaultCanvasCommandFactory canvasCommandFactory;
    @Mock
    private Element<Definition> element;
    @Mock
    private Definition content;
    @Mock
    private DMNDiagram definition;
    @Mock
    private Definitions definitions;
    @Mock
    private Name name;
    @Mock
    private NameHolder nameHolder;
    @Mock
    private AbstractCanvasHandler canvasHandler;
    @Mock
    private CanvasCommandManager<AbstractCanvasHandler> commandManager;
    @Mock
    private CanvasCommand<AbstractCanvasHandler> command;
    @Captor
    private ArgumentCaptor<Name> nameArgumentCaptor;
    private TextPropertyProvider provider;

    @Before
    public void setup() {
        this.provider = new DMNDiagramTextPropertyProviderImpl(this.canvasCommandFactory, this.definitionUtils);
        Mockito.when((Object)((Definition)this.element.getContent())).thenReturn((Object)this.content);
        Mockito.when((Object)this.content.getDefinition()).thenReturn((Object)this.definition);
        Mockito.when((Object)this.definition.getDefinitions()).thenReturn((Object)this.definitions);
        Mockito.when((Object)this.definitions.getName()).thenReturn((Object)this.name);
        Mockito.when((Object)this.definitions.getNameHolder()).thenReturn((Object)this.nameHolder);
        Mockito.when((Object)this.nameHolder.getValue()).thenReturn((Object)this.name);
        Mockito.when((Object)this.definitionUtils.getNameIdentifier((Object)((Definitions)ArgumentMatchers.eq((Object)this.definitions)))).thenReturn((Object)NAME_FIELD);
        Mockito.when((Object)this.canvasCommandFactory.updatePropertyValue((Element)ArgumentMatchers.eq(this.element), (String)Mockito.any(), Mockito.any())).thenReturn(this.command);
    }

    @Test
    public void checkPriorityLessThanCatchAll() {
        Assert.assertTrue((this.provider.getPriority() < Integer.MAX_VALUE ? 1 : 0) != 0);
    }

    @Test
    public void checkSupportsDMNDiagram() {
        Assert.assertTrue((boolean)this.provider.supports(this.element));
        Element other = (Element)Mockito.mock(Element.class);
        Definition otherContent = (Definition)Mockito.mock(Definition.class);
        TextAnnotation otherDefinition = (TextAnnotation)Mockito.mock(TextAnnotation.class);
        Mockito.when((Object)other.getContent()).thenReturn((Object)otherContent);
        Mockito.when((Object)otherContent.getDefinition()).thenReturn((Object)otherDefinition);
        Assert.assertFalse((boolean)this.provider.supports(other));
    }

    @Test
    public void checkReadGetsTextFromNameProperty() {
        this.provider.getText(this.element);
        ((Definitions)Mockito.verify((Object)this.definitions)).getNameHolder();
        ((NameHolder)Mockito.verify((Object)this.nameHolder)).getValue();
    }

    @Test
    public void checkWriteUsesCommandToUpdateTextProperty() {
        this.provider.setText(this.canvasHandler, this.commandManager, this.element, NAME_VALUE);
        ((DefaultCanvasCommandFactory)Mockito.verify((Object)this.canvasCommandFactory)).updatePropertyValue((Element)ArgumentMatchers.eq(this.element), (String)ArgumentMatchers.eq((Object)NAME_FIELD), this.nameArgumentCaptor.capture());
        Assert.assertEquals((Object)NAME_VALUE, (Object)((Name)this.nameArgumentCaptor.getValue()).getValue());
        ((CanvasCommandManager)Mockito.verify(this.commandManager)).execute((Object)((AbstractCanvasHandler)ArgumentMatchers.eq((Object)this.canvasHandler)), (Command)ArgumentMatchers.eq(this.command));
    }

    @Test
    public void checkWriteUsesCommandToUpdateTextPropertyWithWhitespace() {
        this.provider.setText(this.canvasHandler, this.commandManager, this.element, NAME_VALUE_WITH_WHITESPACE);
        ((DefaultCanvasCommandFactory)Mockito.verify((Object)this.canvasCommandFactory)).updatePropertyValue((Element)ArgumentMatchers.eq(this.element), (String)ArgumentMatchers.eq((Object)NAME_FIELD), this.nameArgumentCaptor.capture());
        Assert.assertEquals((Object)NAME_VALUE, (Object)((Name)this.nameArgumentCaptor.getValue()).getValue());
        ((CanvasCommandManager)Mockito.verify(this.commandManager)).execute((Object)((AbstractCanvasHandler)ArgumentMatchers.eq((Object)this.canvasHandler)), (Command)ArgumentMatchers.eq(this.command));
    }
}

