/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.canvas.controls.toolbox;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Collection;
import java.util.Collections;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.canvas.controls.toolbox.DMNDeleteNodeToolboxAction;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.command.DefaultCanvasCommandFactory;
import org.kie.workbench.common.stunner.core.client.canvas.controls.DeleteNodeConfirmation;
import org.kie.workbench.common.stunner.core.client.canvas.event.selection.CanvasClearSelectionEvent;
import org.kie.workbench.common.stunner.core.client.command.SessionCommandManager;
import org.kie.workbench.common.stunner.core.client.i18n.ClientTranslationService;
import org.kie.workbench.common.stunner.core.client.shape.view.event.MouseClickEvent;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.processing.index.Index;
import org.kie.workbench.common.stunner.core.util.DefinitionUtils;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.mvp.Command;

@RunWith(value=GwtMockitoTestRunner.class)
public class DMNDeleteNodeToolboxActionTest {
    private DMNDeleteNodeToolboxAction toolboxAction;
    @Mock
    private ClientTranslationService translationService;
    @Mock
    private SessionCommandManager<AbstractCanvasHandler> sessionCommandManager;
    @Mock
    private ManagedInstance<DefaultCanvasCommandFactory> commandFactories;
    @Mock
    private DefinitionUtils definitionUtils;
    @Mock
    private EventSourceMock<CanvasClearSelectionEvent> clearSelectionEvent;
    @Mock
    private DeleteNodeConfirmation deleteNodeConfirmation;
    @Mock
    private AbstractCanvasHandler canvasHandler;
    @Mock
    private Index graphIndex;

    @Before
    public void setup() {
        this.toolboxAction = (DMNDeleteNodeToolboxAction)Mockito.spy((Object)new DMNDeleteNodeToolboxAction(this.translationService, this.sessionCommandManager, this.commandFactories, this.definitionUtils, this.clearSelectionEvent, this.deleteNodeConfirmation));
        ((DMNDeleteNodeToolboxAction)Mockito.doNothing().when((Object)this.toolboxAction)).superOnMouseClick((AbstractCanvasHandler)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (MouseClickEvent)ArgumentMatchers.any());
        Mockito.when((Object)this.canvasHandler.getGraphIndex()).thenReturn((Object)this.graphIndex);
    }

    @Test
    public void testOnMouseClickWhenNodeRequiresDeletionConfirmation() {
        String nodeUuid = "node uuid";
        Element element = (Element)Mockito.mock(Element.class);
        Node node = (Node)Mockito.mock(Node.class);
        MouseClickEvent event = new MouseClickEvent(0.0, 0.0, 0.0, 0.0);
        Mockito.when((Object)element.asNode()).thenReturn((Object)node);
        Mockito.when((Object)this.graphIndex.get("node uuid")).thenReturn((Object)element);
        Mockito.when((Object)this.deleteNodeConfirmation.requiresDeletionConfirmation(Collections.singleton(node))).thenReturn((Object)true);
        this.toolboxAction.onMouseClick(this.canvasHandler, "node uuid", event);
        ((DeleteNodeConfirmation)Mockito.verify((Object)this.deleteNodeConfirmation)).confirmDeletion((Command)ArgumentMatchers.any(), (Command)ArgumentMatchers.any(), (Collection)ArgumentMatchers.any());
        ((DMNDeleteNodeToolboxAction)Mockito.verify((Object)this.toolboxAction, (VerificationMode)Mockito.never())).superOnMouseClick(this.canvasHandler, "node uuid", event);
    }

    @Test
    public void testOnMouseClickWhenNodeDoesNotRequiresDeletionConfirmation() {
        String nodeUuid = "node uuid";
        Element element = (Element)Mockito.mock(Element.class);
        Node node = (Node)Mockito.mock(Node.class);
        MouseClickEvent event = new MouseClickEvent(0.0, 0.0, 0.0, 0.0);
        Mockito.when((Object)element.asNode()).thenReturn((Object)node);
        Mockito.when((Object)this.graphIndex.get("node uuid")).thenReturn((Object)element);
        Mockito.when((Object)this.deleteNodeConfirmation.requiresDeletionConfirmation(Collections.singleton(node))).thenReturn((Object)false);
        this.toolboxAction.onMouseClick(this.canvasHandler, "node uuid", event);
        ((DeleteNodeConfirmation)Mockito.verify((Object)this.deleteNodeConfirmation, (VerificationMode)Mockito.never())).confirmDeletion((Command)ArgumentMatchers.any(), (Command)ArgumentMatchers.any(), (Collection)ArgumentMatchers.any());
        ((DMNDeleteNodeToolboxAction)Mockito.verify((Object)this.toolboxAction)).superOnMouseClick(this.canvasHandler, "node uuid", event);
    }
}

