/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.commands.expressions.types.context;

import java.util.Optional;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.HasExpression;
import org.kie.workbench.common.dmn.api.definition.model.Context;
import org.kie.workbench.common.dmn.api.definition.model.ContextEntry;
import org.kie.workbench.common.dmn.api.definition.model.InformationItem;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.dmn.client.commands.expressions.types.context.AddContextEntryCommand;
import org.kie.workbench.common.dmn.client.editors.expressions.types.ExpressionEditorDefinitions;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.ContextEntryDefaultValueUtilities;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.ContextUIModelMapper;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.ExpressionCellValue;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.ExpressionEditorColumn;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.InformationItemCell;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.NameColumn;
import org.kie.workbench.common.dmn.client.editors.expressions.types.undefined.UndefinedExpressionEditorDefinition;
import org.kie.workbench.common.dmn.client.widgets.grid.BaseExpressionGrid;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.list.ListSelectorView;
import org.kie.workbench.common.dmn.client.widgets.grid.model.GridCellTuple;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandResultBuilder;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandExecutionContext;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandResultBuilder;
import org.kie.workbench.common.stunner.core.rule.RuleManager;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.wires.core.grids.client.model.GridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridData;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridRow;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.grid.columns.RowNumberColumn;
import org.uberfire.mvp.Command;

@RunWith(value=MockitoJUnitRunner.Silent.class)
public class AddContextEntryCommandTest {
    @Mock
    private GridWidget gridWidget;
    @Mock
    private RowNumberColumn uiRowNumberColumn;
    @Mock
    private NameColumn uiNameColumn;
    @Mock
    private ExpressionEditorColumn uiExpressionEditorColumn;
    @Mock
    private ListSelectorView.Presenter listSelector;
    @Mock
    private Command canvasOperation;
    @Mock
    private AbstractCanvasHandler handler;
    @Mock
    private GraphCommandExecutionContext gce;
    @Mock
    private RuleManager ruleManager;
    @Mock
    private GridCellTuple parent;
    @Mock
    private UndefinedExpressionEditorDefinition undefinedExpressionEditorDefinition;
    @Mock
    private BaseExpressionGrid undefinedExpressionEditor;
    private Context context;
    private ContextEntry defaultResultContextEntry;
    private ContextEntry contextEntry;
    private GridData uiModel;
    private GridRow uiModelRow;
    private GridRow uiDefaultResultModelRow;
    private ContextUIModelMapper uiModelMapper;
    private AddContextEntryCommand command;

    @Before
    public void setup() {
        this.context = new Context();
        this.contextEntry = new ContextEntry(){
            {
                this.setVariable(new InformationItem(){
                    {
                        this.setName(new Name("variable"));
                    }
                });
            }
        };
        this.defaultResultContextEntry = new ContextEntry();
        this.context.getContextEntry().add(this.defaultResultContextEntry);
        this.uiModel = new BaseGridData();
        this.uiModelRow = new BaseGridRow();
        this.uiDefaultResultModelRow = new BaseGridRow();
        this.uiModel.appendRow(this.uiDefaultResultModelRow);
        this.uiModel.appendColumn((GridColumn)this.uiRowNumberColumn);
        this.uiModel.appendColumn((GridColumn)this.uiNameColumn);
        this.uiModel.appendColumn((GridColumn)this.uiExpressionEditorColumn);
        ((GridWidget)Mockito.doReturn((Object)this.uiModel).when((Object)this.gridWidget)).getModel();
        ((AbstractCanvasHandler)Mockito.doReturn((Object)this.ruleManager).when((Object)this.handler)).getRuleManager();
        ((RowNumberColumn)Mockito.doReturn((Object)0).when((Object)this.uiRowNumberColumn)).getIndex();
        ((NameColumn)Mockito.doReturn((Object)1).when((Object)this.uiNameColumn)).getIndex();
        ((ExpressionEditorColumn)Mockito.doReturn((Object)2).when((Object)this.uiExpressionEditorColumn)).getIndex();
        this.uiModel.setCellValue(0, 2, (GridCellValue)new ExpressionCellValue(Optional.of(this.undefinedExpressionEditor)));
        ExpressionEditorDefinitions expressionEditorDefinitions = new ExpressionEditorDefinitions();
        expressionEditorDefinitions.add((Object)this.undefinedExpressionEditorDefinition);
        ((BaseExpressionGrid)Mockito.doReturn((Object)this.parent).when((Object)this.undefinedExpressionEditor)).getParentInformation();
        ((UndefinedExpressionEditorDefinition)Mockito.doReturn(Optional.empty()).when((Object)this.undefinedExpressionEditorDefinition)).getModelClass();
        ((UndefinedExpressionEditorDefinition)Mockito.doReturn(Optional.of(this.undefinedExpressionEditor)).when((Object)this.undefinedExpressionEditorDefinition)).getEditor((GridCellTuple)ArgumentMatchers.any(GridCellTuple.class), (Optional)ArgumentMatchers.any(Optional.class), (HasExpression)ArgumentMatchers.any(HasExpression.class), (Optional)ArgumentMatchers.any(Optional.class), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyInt());
        this.uiModelMapper = new ContextUIModelMapper(this.gridWidget, () -> this.uiModel, () -> Optional.of(this.context), () -> false, () -> expressionEditorDefinitions, this.listSelector, 0);
    }

    private void makeCommand() {
        this.command = (AddContextEntryCommand)Mockito.spy((Object)new AddContextEntryCommand(this.context, this.contextEntry, this.uiModel, this.uiModelRow, this.context.getContextEntry().size() - 1, this.uiModelMapper, this.canvasOperation));
    }

    @Test
    public void testGraphCommandAllow() {
        this.makeCommand();
        org.kie.workbench.common.stunner.core.command.Command c = this.command.newGraphCommand(this.handler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)c.allow((Object)this.gce));
    }

    @Test
    public void testGraphCommandExecute() {
        this.makeCommand();
        org.kie.workbench.common.stunner.core.command.Command c = this.command.newGraphCommand(this.handler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)c.execute((Object)this.gce));
        Assert.assertEquals((long)2L, (long)this.context.getContextEntry().size());
        Assert.assertEquals((Object)this.contextEntry, this.context.getContextEntry().get(0));
        Assert.assertEquals((Object)(ContextEntryDefaultValueUtilities.PREFIX + "1"), (Object)this.contextEntry.getVariable().getName().getValue());
        Assert.assertEquals((Object)this.defaultResultContextEntry, this.context.getContextEntry().get(1));
        Assert.assertEquals((Object)this.context, (Object)this.contextEntry.getParent());
        Assert.assertEquals((Object)this.contextEntry, (Object)this.contextEntry.getVariable().getParent());
    }

    @Test
    public void testGraphCommandExecuteMultipleEntriesPresent() {
        String EXISTING_ENTRY_NAME = "old one";
        ContextEntry firstEntry = new ContextEntry(){
            {
                this.setVariable(new InformationItem(){
                    {
                        this.setName(new Name("old one"));
                    }
                });
            }
        };
        this.context.getContextEntry().add(0, firstEntry);
        this.makeCommand();
        org.kie.workbench.common.stunner.core.command.Command c = this.command.newGraphCommand(this.handler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)c.execute((Object)this.gce));
        Assert.assertEquals((long)3L, (long)this.context.getContextEntry().size());
        Assert.assertEquals((Object)firstEntry, this.context.getContextEntry().get(0));
        Assert.assertEquals((Object)"old one", (Object)firstEntry.getVariable().getName().getValue());
        Assert.assertEquals((Object)this.contextEntry, this.context.getContextEntry().get(1));
        Assert.assertEquals((Object)(ContextEntryDefaultValueUtilities.PREFIX + "1"), (Object)this.contextEntry.getVariable().getName().getValue());
        Assert.assertEquals((Object)this.defaultResultContextEntry, this.context.getContextEntry().get(2));
        Assert.assertEquals((Object)this.context, (Object)this.contextEntry.getParent());
        Assert.assertEquals((Object)this.contextEntry, (Object)this.contextEntry.getVariable().getParent());
    }

    @Test
    public void testGraphCommandUndo() {
        this.makeCommand();
        org.kie.workbench.common.stunner.core.command.Command c = this.command.newGraphCommand(this.handler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)c.execute((Object)this.gce));
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)c.undo((Object)this.gce));
        Assert.assertEquals((long)1L, (long)this.context.getContextEntry().size());
        Assert.assertEquals((Object)this.defaultResultContextEntry, this.context.getContextEntry().get(0));
    }

    @Test
    public void testGraphCommandUndoMultipleEntriesPresent() {
        ContextEntry firstEntry = new ContextEntry(){
            {
                this.setVariable(new InformationItem(){
                    {
                        this.setName(new Name("old one"));
                    }
                });
            }
        };
        this.context.getContextEntry().add(0, firstEntry);
        this.makeCommand();
        org.kie.workbench.common.stunner.core.command.Command c = this.command.newGraphCommand(this.handler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)c.execute((Object)this.gce));
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)c.undo((Object)this.gce));
        Assert.assertEquals((long)2L, (long)this.context.getContextEntry().size());
        Assert.assertEquals((Object)firstEntry, this.context.getContextEntry().get(0));
        Assert.assertEquals((Object)this.defaultResultContextEntry, this.context.getContextEntry().get(1));
    }

    @Test
    public void testCanvasCommandAllow() {
        this.makeCommand();
        org.kie.workbench.common.stunner.core.command.Command c = this.command.newCanvasCommand(this.handler);
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)c.allow((Object)this.handler));
    }

    @Test
    public void testCanvasCommandExecute() {
        this.makeCommand();
        this.command.newGraphCommand(this.handler).execute((Object)this.gce);
        org.kie.workbench.common.stunner.core.command.Command cc = this.command.newCanvasCommand(this.handler);
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)cc.execute((Object)this.handler));
        Assert.assertEquals((long)2L, (long)this.uiModel.getRowCount());
        Assert.assertEquals((Object)this.uiModelRow, this.uiModel.getRows().get(0));
        Assert.assertEquals((Object)this.uiDefaultResultModelRow, this.uiModel.getRows().get(1));
        Assert.assertEquals((long)3L, (long)this.uiModel.getColumnCount());
        Assert.assertEquals((Object)this.uiRowNumberColumn, this.uiModel.getColumns().get(0));
        Assert.assertEquals((Object)this.uiNameColumn, this.uiModel.getColumns().get(1));
        Assert.assertEquals((Object)this.uiExpressionEditorColumn, this.uiModel.getColumns().get(2));
        Assert.assertEquals((long)3L, (long)((GridRow)this.uiModel.getRows().get(0)).getCells().size());
        Assert.assertEquals((Object)1, (Object)this.uiModel.getCell(0, 0).getValue().getValue());
        Assert.assertEquals((Object)(ContextEntryDefaultValueUtilities.PREFIX + "1"), (Object)((InformationItemCell.HasNameAndDataTypeCell)this.uiModel.getCell(0, 1).getValue().getValue()).getName().getValue());
        Assert.assertTrue((boolean)(this.uiModel.getCell(0, 2).getValue() instanceof ExpressionCellValue));
        Assert.assertEquals((long)1L, (long)((GridRow)this.uiModel.getRows().get(1)).getCells().size());
        Assert.assertTrue((boolean)(this.uiModel.getCell(1, 2).getValue() instanceof ExpressionCellValue));
        ((AddContextEntryCommand)Mockito.verify((Object)this.command)).updateRowNumbers();
        ((AddContextEntryCommand)Mockito.verify((Object)this.command)).updateParentInformation();
        ((Command)Mockito.verify((Object)this.canvasOperation)).execute();
    }

    @Test
    public void testCanvasCommandExecuteMultipleEntries() {
        this.makeCommand();
        this.command.newGraphCommand(this.handler).execute((Object)this.gce);
        org.kie.workbench.common.stunner.core.command.Command firstEntryCanvasCommand = this.command.newCanvasCommand(this.handler);
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)firstEntryCanvasCommand.execute((Object)this.handler));
        ((AddContextEntryCommand)Mockito.verify((Object)this.command)).updateRowNumbers();
        ((AddContextEntryCommand)Mockito.verify((Object)this.command)).updateParentInformation();
        ContextEntry secondRowEntry = new ContextEntry(){
            {
                this.setVariable(new InformationItem());
            }
        };
        BaseGridRow uiSecondModelRow = new BaseGridRow();
        this.command = (AddContextEntryCommand)Mockito.spy((Object)new AddContextEntryCommand(this.context, secondRowEntry, this.uiModel, (GridRow)uiSecondModelRow, this.context.getContextEntry().size() - 1, this.uiModelMapper, this.canvasOperation));
        this.command.newGraphCommand(this.handler).execute((Object)this.gce);
        org.kie.workbench.common.stunner.core.command.Command secondEntryCanvasCommand = this.command.newCanvasCommand(this.handler);
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)secondEntryCanvasCommand.execute((Object)this.handler));
        ((AddContextEntryCommand)Mockito.verify((Object)this.command)).updateRowNumbers();
        ((AddContextEntryCommand)Mockito.verify((Object)this.command)).updateParentInformation();
        Assert.assertEquals((long)3L, (long)this.uiModel.getRowCount());
        Assert.assertEquals((Object)this.uiModelRow, this.uiModel.getRows().get(0));
        Assert.assertEquals((Object)uiSecondModelRow, this.uiModel.getRows().get(1));
        Assert.assertEquals((Object)this.uiDefaultResultModelRow, this.uiModel.getRows().get(2));
        Assert.assertEquals((long)3L, (long)this.uiModel.getColumnCount());
        Assert.assertEquals((Object)this.uiRowNumberColumn, this.uiModel.getColumns().get(0));
        Assert.assertEquals((Object)this.uiNameColumn, this.uiModel.getColumns().get(1));
        Assert.assertEquals((Object)this.uiExpressionEditorColumn, this.uiModel.getColumns().get(2));
        Assert.assertEquals((long)3L, (long)((GridRow)this.uiModel.getRows().get(0)).getCells().size());
        Assert.assertEquals((Object)1, (Object)this.uiModel.getCell(0, 0).getValue().getValue());
        Assert.assertEquals((Object)(ContextEntryDefaultValueUtilities.PREFIX + "1"), (Object)((InformationItemCell.HasNameAndDataTypeCell)this.uiModel.getCell(0, 1).getValue().getValue()).getName().getValue());
        Assert.assertTrue((boolean)(this.uiModel.getCell(0, 2).getValue() instanceof ExpressionCellValue));
        Assert.assertEquals((long)3L, (long)((GridRow)this.uiModel.getRows().get(1)).getCells().size());
        Assert.assertEquals((Object)2, (Object)this.uiModel.getCell(1, 0).getValue().getValue());
        Assert.assertEquals((Object)(ContextEntryDefaultValueUtilities.PREFIX + "2"), (Object)((InformationItemCell.HasNameAndDataTypeCell)this.uiModel.getCell(1, 1).getValue().getValue()).getName().getValue());
        Assert.assertTrue((boolean)(this.uiModel.getCell(1, 2).getValue() instanceof ExpressionCellValue));
        Assert.assertEquals((long)1L, (long)((GridRow)this.uiModel.getRows().get(2)).getCells().size());
        Assert.assertTrue((boolean)(this.uiModel.getCell(2, 2).getValue() instanceof ExpressionCellValue));
        ((Command)Mockito.verify((Object)this.canvasOperation, (VerificationMode)Mockito.times((int)2))).execute();
    }

    @Test
    public void testCanvasCommandUndo() {
        this.makeCommand();
        this.command.newGraphCommand(this.handler).execute((Object)this.gce);
        org.kie.workbench.common.stunner.core.command.Command cc = this.command.newCanvasCommand(this.handler);
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)cc.execute((Object)this.handler));
        Mockito.reset((Object[])new Object[]{this.command, this.canvasOperation});
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)cc.undo((Object)this.handler));
        Assert.assertEquals((long)3L, (long)this.uiModel.getColumnCount());
        Assert.assertEquals((Object)this.uiRowNumberColumn, this.uiModel.getColumns().get(0));
        Assert.assertEquals((Object)this.uiNameColumn, this.uiModel.getColumns().get(1));
        Assert.assertEquals((Object)this.uiExpressionEditorColumn, this.uiModel.getColumns().get(2));
        Assert.assertEquals((long)1L, (long)this.uiModel.getRowCount());
        Assert.assertNull((Object)this.uiModel.getCell(0, 0));
        Assert.assertNull((Object)this.uiModel.getCell(0, 1));
        ((AddContextEntryCommand)Mockito.verify((Object)this.command)).updateRowNumbers();
        ((AddContextEntryCommand)Mockito.verify((Object)this.command)).updateParentInformation();
        ((Command)Mockito.verify((Object)this.canvasOperation)).execute();
    }
}

