/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.commands.expressions.types.list;

import java.util.Collections;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.HasExpression;
import org.kie.workbench.common.dmn.api.definition.model.DMNModelInstrumentedBase;
import org.kie.workbench.common.dmn.api.definition.model.Expression;
import org.kie.workbench.common.dmn.api.definition.model.List;
import org.kie.workbench.common.dmn.api.definition.model.LiteralExpression;
import org.kie.workbench.common.dmn.client.commands.expressions.types.list.MoveRowsCommand;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.ExpressionEditorColumn;
import org.kie.workbench.common.dmn.client.widgets.grid.model.DMNGridData;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandResultBuilder;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandExecutionContext;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandResultBuilder;
import org.kie.workbench.common.stunner.core.rule.RuleManager;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.uberfire.ext.wires.core.grids.client.model.GridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridRow;
import org.uberfire.ext.wires.core.grids.client.widget.grid.columns.RowNumberColumn;
import org.uberfire.mvp.Command;

@RunWith(value=MockitoJUnitRunner.Silent.class)
public class MoveRowsCommandTest {
    private static final String TEXT1 = "text1";
    private static final String TEXT2 = "text2";
    private static final String TEXT3 = "text3";
    @Mock
    private RowNumberColumn uiRowNumberColumn;
    @Mock
    private ExpressionEditorColumn uiExpressionEditorColumn;
    @Mock
    private Command canvasOperation;
    @Mock
    private AbstractCanvasHandler handler;
    @Mock
    private GraphCommandExecutionContext gce;
    @Mock
    private RuleManager ruleManager;
    private List list;
    private DMNGridData uiModel;
    private MoveRowsCommand command;

    @Before
    public void setup() {
        this.list = new List();
        this.uiModel = new DMNGridData();
        ((AbstractCanvasHandler)Mockito.doReturn((Object)this.ruleManager).when((Object)this.handler)).getRuleManager();
        Mockito.when((Object)this.uiRowNumberColumn.getIndex()).thenReturn((Object)0);
        Mockito.when((Object)this.uiExpressionEditorColumn.getIndex()).thenReturn((Object)1);
        this.addHasExpression(TEXT1);
        this.addHasExpression(TEXT2);
        this.addUiModelColumn((GridColumn<?>)this.uiRowNumberColumn);
        this.addUiModelColumn((GridColumn<?>)this.uiExpressionEditorColumn);
        this.addUiModelRow(0);
        this.addUiModelRow(1);
    }

    private void addHasExpression(final String expressionText) {
        this.list.getExpression().add(HasExpression.wrap((DMNModelInstrumentedBase)this.list, (Expression)new LiteralExpression(){
            {
                this.getText().setValue(MoveRowsCommandTest.this.makeLiteralExpression(expressionText, MoveRowsCommandTest.this.list.getExpression().size()));
            }
        }));
    }

    private String makeLiteralExpression(String base, int index) {
        return base + "e" + index;
    }

    protected void addUiModelColumn(GridColumn<?> uiColumn) {
        this.uiModel.appendColumn(uiColumn);
    }

    protected void addUiModelRow(int rowIndex) {
        BaseGridRow uiRow = new BaseGridRow();
        this.uiModel.appendRow((GridRow)uiRow);
        this.uiModel.setCellValue(rowIndex, 0, (GridCellValue)new BaseGridCellValue((Object)(rowIndex + 1)));
        this.uiModel.setCellValue(rowIndex, 1, (GridCellValue)new BaseGridCellValue((Object)("editor" + rowIndex)));
    }

    private void setupCommand(int index, GridRow uiModelRow) {
        this.command = (MoveRowsCommand)Mockito.spy((Object)new MoveRowsCommand(this.list, this.uiModel, index, Collections.singletonList(uiModelRow), this.canvasOperation));
    }

    @Test
    public void testGraphCommandAllow() {
        this.setupCommand(0, this.uiModel.getRow(0));
        org.kie.workbench.common.stunner.core.command.Command c = this.command.newGraphCommand(this.handler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)c.allow((Object)this.gce));
    }

    @Test
    public void testGraphCommandExecuteMoveUp() {
        this.setupCommand(0, this.uiModel.getRow(1));
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)this.command.newGraphCommand(this.handler).execute((Object)this.gce));
        this.assertHasExpressionDefinitions(new int[]{1, 0});
    }

    @Test
    public void testGraphCommandExecuteMoveUpThreeRows() {
        this.addHasExpression(TEXT3);
        this.addUiModelRow(2);
        this.setupCommand(0, this.uiModel.getRow(2));
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)this.command.newGraphCommand(this.handler).execute((Object)this.gce));
        this.assertHasExpressionDefinitions(new int[]{1, 2, 0});
    }

    @Test
    public void testGraphCommandExecuteMoveDown() {
        this.setupCommand(1, this.uiModel.getRow(0));
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)this.command.newGraphCommand(this.handler).execute((Object)this.gce));
        this.assertHasExpressionDefinitions(new int[]{1, 0});
    }

    @Test
    public void testGraphCommandExecuteMoveDownThreeRows() {
        this.addHasExpression(TEXT3);
        this.addUiModelRow(2);
        this.setupCommand(2, this.uiModel.getRow(0));
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)this.command.newGraphCommand(this.handler).execute((Object)this.gce));
        this.assertHasExpressionDefinitions(new int[]{2, 0, 1});
    }

    @Test
    public void testGraphCommandUndoMoveUp() {
        this.setupCommand(0, this.uiModel.getRow(1));
        org.kie.workbench.common.stunner.core.command.Command gc = this.command.newGraphCommand(this.handler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)gc.execute((Object)this.gce));
        this.command.newCanvasCommand(this.handler).execute((Object)this.handler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)gc.undo((Object)this.gce));
        this.assertHasExpressionDefinitions(new int[]{0, 1});
    }

    @Test
    public void testGraphCommandUndoMoveDown() {
        this.setupCommand(1, this.uiModel.getRow(0));
        org.kie.workbench.common.stunner.core.command.Command gc = this.command.newGraphCommand(this.handler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)gc.execute((Object)this.gce));
        this.command.newCanvasCommand(this.handler).execute((Object)this.handler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)gc.undo((Object)this.gce));
        this.assertHasExpressionDefinitions(new int[]{0, 1});
    }

    private void assertHasExpressionDefinitions(int[] iiRowIndexes) {
        String[] rowValueBases = new String[]{TEXT1, TEXT2, TEXT3};
        int iiRowIndexIterator = 0;
        for (int iiRowIndex : iiRowIndexes) {
            Assert.assertEquals((Object)this.makeLiteralExpression(rowValueBases[iiRowIndexIterator], iiRowIndexIterator), (Object)((LiteralExpression)((HasExpression)this.list.getExpression().get(iiRowIndex)).getExpression()).getText().getValue());
            ++iiRowIndexIterator;
        }
    }

    @Test
    public void testCanvasCommandAllow() {
        this.setupCommand(0, this.uiModel.getRow(0));
        org.kie.workbench.common.stunner.core.command.Command c = this.command.newCanvasCommand(this.handler);
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)c.allow((Object)this.handler));
    }

    @Test
    public void testCanvasCommandExecuteMoveUp() {
        this.setupCommand(0, this.uiModel.getRow(1));
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)this.command.newCanvasCommand(this.handler).execute((Object)this.handler));
        ((MoveRowsCommand)Mockito.verify((Object)this.command)).updateRowNumbers();
        ((MoveRowsCommand)Mockito.verify((Object)this.command)).updateParentInformation();
        this.assertUiModelDefinition(new int[]{1, 0});
    }

    @Test
    public void testCanvasCommandExecuteMoveUpThreeRows() {
        this.addHasExpression(TEXT3);
        this.addUiModelRow(2);
        this.setupCommand(0, this.uiModel.getRow(2));
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)this.command.newCanvasCommand(this.handler).execute((Object)this.handler));
        ((MoveRowsCommand)Mockito.verify((Object)this.command)).updateRowNumbers();
        ((MoveRowsCommand)Mockito.verify((Object)this.command)).updateParentInformation();
        this.assertUiModelDefinition(new int[]{2, 0, 1});
    }

    @Test
    public void testCanvasCommandExecuteMoveDown() {
        this.setupCommand(1, this.uiModel.getRow(0));
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)this.command.newCanvasCommand(this.handler).execute((Object)this.handler));
        ((MoveRowsCommand)Mockito.verify((Object)this.command)).updateRowNumbers();
        ((MoveRowsCommand)Mockito.verify((Object)this.command)).updateParentInformation();
        this.assertUiModelDefinition(new int[]{1, 0});
    }

    @Test
    public void testCanvasCommandExecuteMoveDownThreeRows() {
        this.addHasExpression(TEXT3);
        this.addUiModelRow(2);
        this.setupCommand(2, this.uiModel.getRow(0));
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)this.command.newCanvasCommand(this.handler).execute((Object)this.handler));
        ((MoveRowsCommand)Mockito.verify((Object)this.command)).updateRowNumbers();
        ((MoveRowsCommand)Mockito.verify((Object)this.command)).updateParentInformation();
        this.assertUiModelDefinition(new int[]{1, 2, 0});
    }

    @Test
    public void testCanvasCommandUndoMoveUp() {
        this.setupCommand(0, this.uiModel.getRow(1));
        org.kie.workbench.common.stunner.core.command.Command cc = this.command.newCanvasCommand(this.handler);
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)cc.execute((Object)this.handler));
        Mockito.reset((Object[])new MoveRowsCommand[]{this.command});
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)cc.undo((Object)this.handler));
        ((MoveRowsCommand)Mockito.verify((Object)this.command)).updateRowNumbers();
        ((MoveRowsCommand)Mockito.verify((Object)this.command)).updateParentInformation();
        this.assertUiModelDefinition(new int[]{0, 1});
    }

    @Test
    public void testCanvasCommandUndoMoveDown() {
        this.setupCommand(1, this.uiModel.getRow(0));
        org.kie.workbench.common.stunner.core.command.Command cc = this.command.newCanvasCommand(this.handler);
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)cc.execute((Object)this.handler));
        Mockito.reset((Object[])new MoveRowsCommand[]{this.command});
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)cc.undo((Object)this.handler));
        ((MoveRowsCommand)Mockito.verify((Object)this.command)).updateRowNumbers();
        ((MoveRowsCommand)Mockito.verify((Object)this.command)).updateParentInformation();
        this.assertUiModelDefinition(new int[]{0, 1});
    }

    private void assertUiModelDefinition(int[] rowIndexes) {
        int rowIndexesIterator = 0;
        for (int rowIndex : rowIndexes) {
            Assert.assertEquals((Object)(rowIndexesIterator + 1), (Object)this.uiModel.getCell(rowIndexesIterator, 0).getValue().getValue());
            Assert.assertEquals((Object)("editor" + rowIndexes[rowIndexesIterator]), (Object)this.uiModel.getCell(rowIndexesIterator, 1).getValue().getValue());
            ++rowIndexesIterator;
        }
    }
}

