/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.commands.expressions.types.relation;

import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.HasExpression;
import org.kie.workbench.common.dmn.api.definition.model.Relation;
import org.kie.workbench.common.dmn.client.commands.expressions.types.relation.BaseMoveCommandsTest;
import org.kie.workbench.common.dmn.client.commands.expressions.types.relation.MoveColumnsCommand;
import org.kie.workbench.common.dmn.client.editors.expressions.types.relation.RelationColumn;
import org.kie.workbench.common.dmn.client.widgets.grid.model.DMNGridData;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.command.AbstractCanvasGraphCommand;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandResultBuilder;
import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandResultBuilder;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.uberfire.ext.wires.core.grids.client.model.GridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridRow;
import org.uberfire.ext.wires.core.grids.client.widget.grid.columns.RowNumberColumn;

@RunWith(value=MockitoJUnitRunner.Silent.class)
public class MoveColumnsCommandTest
extends BaseMoveCommandsTest<MoveColumnsCommand> {
    @Before
    public void setup() {
        this.relation = new Relation();
        this.uiModel = new DMNGridData();
        ((AbstractCanvasHandler)Mockito.doReturn((Object)this.ruleManager).when((Object)this.handler)).getRuleManager();
        ((RowNumberColumn)Mockito.doReturn((Object)0).when((Object)this.uiRowNumberColumn)).getIndex();
        ((RelationColumn)Mockito.doReturn((Object)1).when((Object)this.uiModelColumn1)).getIndex();
        ((RelationColumn)Mockito.doReturn((Object)2).when((Object)this.uiModelColumn2)).getIndex();
        this.addRelationColumn("ii1");
        this.addRelationColumn("ii2");
        this.addRelationRow("ii1");
        this.addRelationRow("ii2");
        this.addUiModelColumn((GridColumn<?>)this.uiRowNumberColumn);
        this.addUiModelColumn((GridColumn<?>)this.uiModelColumn1);
        this.addUiModelColumn((GridColumn<?>)this.uiModelColumn2);
        this.addUiModelRow(0);
        this.addUiModelRow(1);
    }

    @Override
    protected void addUiModelRow(int rowIndex) {
        BaseGridRow uiRow = new BaseGridRow();
        this.uiModel.appendRow((GridRow)uiRow);
        this.uiModel.setCellValue(rowIndex, 0, (GridCellValue)new BaseGridCellValue((Object)(rowIndex + 1)));
        this.uiModel.setCellValue(rowIndex, 1, (GridCellValue)new BaseGridCellValue((Object)"value0"));
        this.uiModel.setCellValue(rowIndex, 2, (GridCellValue)new BaseGridCellValue((Object)"value1"));
    }

    private void setupCommand(int index, GridColumn<?> uiModelColumn) {
        this.command = (AbstractCanvasGraphCommand)Mockito.spy((Object)new MoveColumnsCommand(this.relation, this.uiModel, index, Collections.singletonList(uiModelColumn), this.canvasOperation));
    }

    @Test
    public void testGraphCommandAllow() {
        this.setupCommand(0, (GridColumn)this.uiModel.getColumns().get(0));
        Command c = ((MoveColumnsCommand)this.command).newGraphCommand(this.handler);
        Assert.assertEquals((Object)CommandResult.Type.ERROR, (Object)c.allow((Object)this.gce).getType());
    }

    @Test
    public void testGraphCommandExecuteMoveLeft() {
        this.setupCommand(1, (GridColumn)this.uiModel.getColumns().get(2));
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)((MoveColumnsCommand)this.command).newGraphCommand(this.handler).execute((Object)this.gce));
        this.assertRelationDefinition(1, 0);
    }

    @Test
    public void testGraphCommandExecuteMoveRight() {
        this.setupCommand(2, (GridColumn)this.uiModel.getColumns().get(1));
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)((MoveColumnsCommand)this.command).newGraphCommand(this.handler).execute((Object)this.gce));
        this.assertRelationDefinition(1, 0);
    }

    @Test
    public void testGraphCommandUndoMoveLeft() {
        this.setupCommand(1, (GridColumn)this.uiModel.getColumns().get(2));
        Command gc = ((MoveColumnsCommand)this.command).newGraphCommand(this.handler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)gc.execute((Object)this.gce));
        ((MoveColumnsCommand)this.command).newCanvasCommand(this.handler).execute((Object)this.handler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)gc.undo((Object)this.gce));
        this.assertRelationDefinition(0, 1);
    }

    @Test
    public void testGraphCommandUndoMoveRight() {
        this.setupCommand(2, (GridColumn)this.uiModel.getColumns().get(1));
        Command gc = ((MoveColumnsCommand)this.command).newGraphCommand(this.handler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)gc.execute((Object)this.gce));
        ((MoveColumnsCommand)this.command).newCanvasCommand(this.handler).execute((Object)this.handler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)gc.undo((Object)this.gce));
        this.assertRelationDefinition(0, 1);
    }

    private void assertRelationDefinition(int ii1ColumnIndex, int ii2ColumnIndex) {
        Assert.assertEquals((Object)this.makeIdentifier("ii1", 0), (Object)((HasExpression)((org.kie.workbench.common.dmn.api.definition.model.List)this.relation.getRow().get(0)).getExpression().get(ii1ColumnIndex)).getExpression().getId().getValue());
        Assert.assertEquals((Object)this.makeIdentifier("ii2", 0), (Object)((HasExpression)((org.kie.workbench.common.dmn.api.definition.model.List)this.relation.getRow().get(1)).getExpression().get(ii1ColumnIndex)).getExpression().getId().getValue());
        Assert.assertEquals((Object)this.makeIdentifier("ii1", 1), (Object)((HasExpression)((org.kie.workbench.common.dmn.api.definition.model.List)this.relation.getRow().get(0)).getExpression().get(ii2ColumnIndex)).getExpression().getId().getValue());
        Assert.assertEquals((Object)this.makeIdentifier("ii2", 1), (Object)((HasExpression)((org.kie.workbench.common.dmn.api.definition.model.List)this.relation.getRow().get(1)).getExpression().get(ii2ColumnIndex)).getExpression().getId().getValue());
    }

    @Test
    public void testCanvasCommandAllow() {
        this.setupCommand(0, (GridColumn)this.uiModel.getColumns().get(0));
        Command c = ((MoveColumnsCommand)this.command).newCanvasCommand(this.handler);
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)c.allow((Object)this.handler));
    }

    @Test
    public void testCanvasCommandExecuteMoveLeft() {
        this.setupCommand(1, (GridColumn)this.uiModel.getColumns().get(2));
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)((MoveColumnsCommand)this.command).newCanvasCommand(this.handler).execute((Object)this.handler));
        ((MoveColumnsCommand)Mockito.verify((Object)((MoveColumnsCommand)this.command))).updateParentInformation();
        this.assertUiModelDefinition(new int[]{1, 0});
    }

    @Test
    public void testCanvasCommandExecuteMoveRight() {
        this.setupCommand(2, (GridColumn)this.uiModel.getColumns().get(1));
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)((MoveColumnsCommand)this.command).newCanvasCommand(this.handler).execute((Object)this.handler));
        ((MoveColumnsCommand)Mockito.verify((Object)((MoveColumnsCommand)this.command))).updateParentInformation();
        this.assertUiModelDefinition(new int[]{1, 0});
    }

    @Test
    public void testCanvasCommandUndoMoveLeft() {
        this.setupCommand(1, (GridColumn)this.uiModel.getColumns().get(2));
        Command cc = ((MoveColumnsCommand)this.command).newCanvasCommand(this.handler);
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)cc.execute((Object)this.handler));
        Mockito.reset((Object[])new MoveColumnsCommand[]{(MoveColumnsCommand)this.command});
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)cc.undo((Object)this.handler));
        ((MoveColumnsCommand)Mockito.verify((Object)((MoveColumnsCommand)this.command))).updateParentInformation();
        this.assertUiModelDefinition(new int[]{0, 1});
    }

    @Test
    public void testCanvasCommandUndoMoveRight() {
        this.setupCommand(2, (GridColumn)this.uiModel.getColumns().get(1));
        Command cc = ((MoveColumnsCommand)this.command).newCanvasCommand(this.handler);
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)cc.execute((Object)this.handler));
        Mockito.reset((Object[])new MoveColumnsCommand[]{(MoveColumnsCommand)this.command});
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)cc.undo((Object)this.handler));
        ((MoveColumnsCommand)Mockito.verify((Object)((MoveColumnsCommand)this.command))).updateParentInformation();
        this.assertUiModelDefinition(new int[]{0, 1});
    }

    private void assertUiModelDefinition(int[] columnIndexes) {
        Assert.assertEquals((Object)1, (Object)this.uiModel.getCell(0, 0).getValue().getValue());
        Assert.assertEquals((Object)("value" + columnIndexes[0]), (Object)this.uiModel.getCell(0, 1).getValue().getValue());
        Assert.assertEquals((Object)("value" + columnIndexes[1]), (Object)this.uiModel.getCell(0, 2).getValue().getValue());
        Assert.assertEquals((Object)2, (Object)this.uiModel.getCell(1, 0).getValue().getValue());
        Assert.assertEquals((Object)("value" + columnIndexes[0]), (Object)this.uiModel.getCell(1, 1).getValue().getValue());
        Assert.assertEquals((Object)("value" + columnIndexes[1]), (Object)this.uiModel.getCell(1, 2).getValue().getValue());
    }

    @Test
    public void testComponentWidths() {
        this.setupCommand(1, (GridColumn)this.uiModel.getColumns().get(2));
        List componentWidths = this.relation.getComponentWidths();
        componentWidths.set(1, 10.0);
        componentWidths.set(2, 20.0);
        Command graphCommand = ((MoveColumnsCommand)this.command).newGraphCommand(this.handler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)graphCommand.execute((Object)this.gce));
        Assert.assertEquals((long)this.relation.getRequiredComponentWidthCount(), (long)this.relation.getComponentWidths().size());
        Assert.assertEquals((double)20.0, (double)((Double)this.relation.getComponentWidths().get(1)), (double)0.0);
        Assert.assertEquals((double)10.0, (double)((Double)this.relation.getComponentWidths().get(2)), (double)0.0);
        ((MoveColumnsCommand)this.command).newCanvasCommand(this.handler).execute((Object)this.handler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)graphCommand.undo((Object)this.gce));
        Assert.assertEquals((long)this.relation.getRequiredComponentWidthCount(), (long)this.relation.getComponentWidths().size());
        Assert.assertEquals((double)10.0, (double)((Double)this.relation.getComponentWidths().get(1)), (double)0.0);
        Assert.assertEquals((double)20.0, (double)((Double)this.relation.getComponentWidths().get(2)), (double)0.0);
    }
}

