/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.commands.expressions.types.relation;

import java.util.Collections;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.HasExpression;
import org.kie.workbench.common.dmn.api.definition.model.List;
import org.kie.workbench.common.dmn.api.definition.model.Relation;
import org.kie.workbench.common.dmn.client.commands.expressions.types.relation.BaseMoveCommandsTest;
import org.kie.workbench.common.dmn.client.commands.expressions.types.relation.MoveRowsCommand;
import org.kie.workbench.common.dmn.client.editors.expressions.types.relation.RelationColumn;
import org.kie.workbench.common.dmn.client.widgets.grid.model.DMNGridData;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.command.AbstractCanvasGraphCommand;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandResultBuilder;
import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandResultBuilder;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.uberfire.ext.wires.core.grids.client.model.GridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridRow;
import org.uberfire.ext.wires.core.grids.client.widget.grid.columns.RowNumberColumn;

@RunWith(value=MockitoJUnitRunner.Silent.class)
public class MoveRowsCommandTest
extends BaseMoveCommandsTest<MoveRowsCommand> {
    @Before
    public void setup() {
        this.relation = new Relation();
        this.uiModel = new DMNGridData();
        ((AbstractCanvasHandler)Mockito.doReturn((Object)this.ruleManager).when((Object)this.handler)).getRuleManager();
        ((RowNumberColumn)Mockito.doReturn((Object)0).when((Object)this.uiRowNumberColumn)).getIndex();
        ((RelationColumn)Mockito.doReturn((Object)1).when((Object)this.uiModelColumn1)).getIndex();
        this.addRelationColumn("ii1");
        this.addRelationColumn("ii2");
        this.addRelationRow("ii1");
        this.addRelationRow("ii2");
        this.addUiModelColumn((GridColumn<?>)this.uiRowNumberColumn);
        this.addUiModelColumn((GridColumn<?>)this.uiModelColumn1);
        this.addUiModelRow(0);
        this.addUiModelRow(1);
    }

    @Override
    protected void addUiModelRow(int rowIndex) {
        BaseGridRow uiRow = new BaseGridRow();
        this.uiModel.appendRow((GridRow)uiRow);
        this.uiModel.setCellValue(rowIndex, 0, (GridCellValue)new BaseGridCellValue((Object)(rowIndex + 1)));
        this.uiModel.setCellValue(rowIndex, 1, (GridCellValue)new BaseGridCellValue((Object)("value" + rowIndex)));
    }

    private void setupCommand(int index, GridRow uiModelRow) {
        this.command = (AbstractCanvasGraphCommand)Mockito.spy((Object)new MoveRowsCommand(this.relation, this.uiModel, index, Collections.singletonList(uiModelRow), this.canvasOperation));
    }

    @Test
    public void testGraphCommandAllow() {
        this.setupCommand(0, this.uiModel.getRow(0));
        Command c = ((MoveRowsCommand)this.command).newGraphCommand(this.handler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)c.allow((Object)this.gce));
    }

    @Test
    public void testGraphCommandExecuteMoveUp() {
        this.setupCommand(0, this.uiModel.getRow(1));
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)((MoveRowsCommand)this.command).newGraphCommand(this.handler).execute((Object)this.gce));
        this.assertRelationDefinition(1, 0);
    }

    @Test
    public void testGraphCommandExecuteMoveDown() {
        this.setupCommand(1, this.uiModel.getRow(0));
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)((MoveRowsCommand)this.command).newGraphCommand(this.handler).execute((Object)this.gce));
        this.assertRelationDefinition(1, 0);
    }

    @Test
    public void testGraphCommandUndoMoveUp() {
        this.setupCommand(0, this.uiModel.getRow(1));
        Command gc = ((MoveRowsCommand)this.command).newGraphCommand(this.handler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)gc.execute((Object)this.gce));
        ((MoveRowsCommand)this.command).newCanvasCommand(this.handler).execute((Object)this.handler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)gc.undo((Object)this.gce));
        this.assertRelationDefinition(0, 1);
    }

    @Test
    public void testGraphCommandUndoMoveDown() {
        this.setupCommand(1, this.uiModel.getRow(0));
        Command gc = ((MoveRowsCommand)this.command).newGraphCommand(this.handler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)gc.execute((Object)this.gce));
        ((MoveRowsCommand)this.command).newCanvasCommand(this.handler).execute((Object)this.handler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)gc.undo((Object)this.gce));
        this.assertRelationDefinition(0, 1);
    }

    private void assertRelationDefinition(int ii1RowIndex, int ii2RowIndex) {
        Assert.assertEquals((Object)this.makeIdentifier("ii1", 0), (Object)((HasExpression)((List)this.relation.getRow().get(ii1RowIndex)).getExpression().get(0)).getExpression().getId().getValue());
        Assert.assertEquals((Object)this.makeIdentifier("ii1", 1), (Object)((HasExpression)((List)this.relation.getRow().get(ii1RowIndex)).getExpression().get(1)).getExpression().getId().getValue());
        Assert.assertEquals((Object)this.makeIdentifier("ii2", 0), (Object)((HasExpression)((List)this.relation.getRow().get(ii2RowIndex)).getExpression().get(0)).getExpression().getId().getValue());
        Assert.assertEquals((Object)this.makeIdentifier("ii2", 1), (Object)((HasExpression)((List)this.relation.getRow().get(ii2RowIndex)).getExpression().get(1)).getExpression().getId().getValue());
    }

    @Test
    public void testCanvasCommandAllow() {
        this.setupCommand(0, this.uiModel.getRow(0));
        Command c = ((MoveRowsCommand)this.command).newCanvasCommand(this.handler);
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)c.allow((Object)this.handler));
    }

    @Test
    public void testCanvasCommandExecuteMoveUp() {
        this.setupCommand(0, this.uiModel.getRow(1));
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)((MoveRowsCommand)this.command).newCanvasCommand(this.handler).execute((Object)this.handler));
        ((MoveRowsCommand)Mockito.verify((Object)((MoveRowsCommand)this.command))).updateRowNumbers();
        ((MoveRowsCommand)Mockito.verify((Object)((MoveRowsCommand)this.command))).updateParentInformation();
        this.assertUiModelDefinition(new int[]{1, 0});
    }

    @Test
    public void testCanvasCommandExecuteMoveDown() {
        this.setupCommand(1, this.uiModel.getRow(0));
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)((MoveRowsCommand)this.command).newCanvasCommand(this.handler).execute((Object)this.handler));
        ((MoveRowsCommand)Mockito.verify((Object)((MoveRowsCommand)this.command))).updateRowNumbers();
        ((MoveRowsCommand)Mockito.verify((Object)((MoveRowsCommand)this.command))).updateParentInformation();
        this.assertUiModelDefinition(new int[]{1, 0});
    }

    @Test
    public void testCanvasCommandUndoMoveUp() {
        this.setupCommand(0, this.uiModel.getRow(1));
        Command cc = ((MoveRowsCommand)this.command).newCanvasCommand(this.handler);
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)cc.execute((Object)this.handler));
        Mockito.reset((Object[])new MoveRowsCommand[]{(MoveRowsCommand)this.command});
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)cc.undo((Object)this.handler));
        ((MoveRowsCommand)Mockito.verify((Object)((MoveRowsCommand)this.command))).updateRowNumbers();
        ((MoveRowsCommand)Mockito.verify((Object)((MoveRowsCommand)this.command))).updateParentInformation();
        this.assertUiModelDefinition(new int[]{0, 1});
    }

    @Test
    public void testCanvasCommandUndoMoveDown() {
        this.setupCommand(1, this.uiModel.getRow(0));
        Command cc = ((MoveRowsCommand)this.command).newCanvasCommand(this.handler);
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)cc.execute((Object)this.handler));
        Mockito.reset((Object[])new MoveRowsCommand[]{(MoveRowsCommand)this.command});
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)cc.undo((Object)this.handler));
        ((MoveRowsCommand)Mockito.verify((Object)((MoveRowsCommand)this.command))).updateRowNumbers();
        ((MoveRowsCommand)Mockito.verify((Object)((MoveRowsCommand)this.command))).updateParentInformation();
        this.assertUiModelDefinition(new int[]{0, 1});
    }

    private void assertUiModelDefinition(int[] rowIndexes) {
        Assert.assertEquals((Object)1, (Object)this.uiModel.getCell(0, 0).getValue().getValue());
        Assert.assertEquals((Object)("value" + rowIndexes[0]), (Object)this.uiModel.getCell(0, 1).getValue().getValue());
        Assert.assertEquals((Object)2, (Object)this.uiModel.getCell(1, 0).getValue().getValue());
        Assert.assertEquals((Object)("value" + rowIndexes[1]), (Object)this.uiModel.getCell(1, 1).getValue().getValue());
    }
}

