/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.commands.factory.canvas;

import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.commands.factory.canvas.SetComponentWidthCanvasCommand;
import org.kie.workbench.common.dmn.client.commands.factory.canvas.SetComponentWidthCommand;
import org.kie.workbench.common.dmn.client.commands.general.NoOperationGraphCommand;
import org.kie.workbench.common.dmn.client.widgets.grid.BaseGrid;
import org.kie.workbench.common.dmn.client.widgets.grid.model.DMNGridColumn;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandResultBuilder;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class SetComponentWidthCommandTest {
    private static final double WIDTH = 100.0;
    private static final double OLD_WIDTH = 200.0;
    @Mock
    private DMNGridColumn uiColumn;
    @Mock
    private AbstractCanvasHandler canvasHandler;
    @Mock
    private BaseGrid uiGridWidget;
    private SetComponentWidthCommand command;

    @Before
    public void setup() {
        this.command = new SetComponentWidthCommand(this.uiColumn, 200.0, 100.0);
        Mockito.when((Object)this.uiColumn.getGridWidget()).thenReturn((Object)this.uiGridWidget);
    }

    @Test
    public void testTypes() {
        Assertions.assertThat((Object)this.command.newGraphCommand(this.canvasHandler)).isInstanceOf(NoOperationGraphCommand.class);
        Assertions.assertThat((Object)this.command.newCanvasCommand(this.canvasHandler)).isInstanceOf(SetComponentWidthCanvasCommand.class);
    }

    @Test
    public void testExecute() {
        Assertions.assertThat((Object)this.command.getCanvasCommand(this.canvasHandler).execute((Object)this.canvasHandler)).isEqualTo((Object)CanvasCommandResultBuilder.SUCCESS);
        ((DMNGridColumn)Mockito.verify((Object)this.uiColumn)).setWidth(100.0);
        ((BaseGrid)Mockito.verify((Object)this.uiGridWidget)).batch();
    }

    @Test
    public void testExecuteThenUndo() {
        Assertions.assertThat((Object)this.command.getCanvasCommand(this.canvasHandler).execute((Object)this.canvasHandler)).isEqualTo((Object)CanvasCommandResultBuilder.SUCCESS);
        ((DMNGridColumn)Mockito.verify((Object)this.uiColumn)).setWidth(100.0);
        ((BaseGrid)Mockito.verify((Object)this.uiGridWidget)).batch();
        Assertions.assertThat((Object)this.command.getCanvasCommand(this.canvasHandler).undo((Object)this.canvasHandler)).isEqualTo((Object)CanvasCommandResultBuilder.SUCCESS);
        ((DMNGridColumn)Mockito.verify((Object)this.uiColumn)).setWidth(200.0);
        ((BaseGrid)Mockito.verify((Object)this.uiGridWidget, (VerificationMode)Mockito.times((int)2))).batch();
    }
}

