/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.commands.util;

import com.ait.lienzo.test.LienzoMockitoTestRunner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.IntStream;
import org.assertj.core.api.Assertions;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.model.DecisionRule;
import org.kie.workbench.common.dmn.api.definition.model.Expression;
import org.kie.workbench.common.dmn.api.property.dmn.Id;
import org.kie.workbench.common.dmn.client.commands.factory.DefaultCanvasCommandFactory;
import org.kie.workbench.common.dmn.client.commands.util.CommandUtils;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.ExpressionCellValue;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.ExpressionEditorColumn;
import org.kie.workbench.common.dmn.client.widgets.grid.BaseExpressionGrid;
import org.kie.workbench.common.dmn.client.widgets.grid.BaseGrid;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.container.CellEditorControlsView;
import org.kie.workbench.common.dmn.client.widgets.grid.model.DMNGridData;
import org.kie.workbench.common.dmn.client.widgets.grid.model.GridCellTuple;
import org.kie.workbench.common.dmn.client.widgets.layer.DMNGridLayer;
import org.kie.workbench.common.stunner.core.client.api.SessionManager;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.event.selection.DomainObjectSelectionEvent;
import org.kie.workbench.common.stunner.core.client.command.SessionCommandManager;
import org.kie.workbench.common.stunner.forms.client.event.RefreshFormPropertiesEvent;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.commons.data.Pair;
import org.uberfire.ext.wires.core.grids.client.model.GridCell;
import org.uberfire.ext.wires.core.grids.client.model.GridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridRow;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseHeaderMetaData;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.grid.columns.RowNumberColumn;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.GridRenderer;
import org.uberfire.ext.wires.core.grids.client.widget.layer.GridWidgetRegistry;
import org.uberfire.mocks.EventSourceMock;

@RunWith(value=LienzoMockitoTestRunner.class)
public class CommandUtilsTest {
    private static final int ROW_COUNT = 10;
    @Mock
    private DMNGridLayer gridLayer;
    @Mock
    private GridRenderer renderer;
    @Mock
    private SessionManager sessionManager;
    @Mock
    private SessionCommandManager<AbstractCanvasHandler> sessionCommandManager;
    @Mock
    private DefaultCanvasCommandFactory canvasCommandFactory;
    @Mock
    private EventSourceMock<RefreshFormPropertiesEvent> refreshFormPropertiesEvent;
    @Mock
    private EventSourceMock<DomainObjectSelectionEvent> domainObjectSelectionEvent;
    @Mock
    private CellEditorControlsView.Presenter cellEditorControls;
    @Mock
    private TranslationService translationService;
    private DecisionRule decisionRuleOne;
    private DecisionRule decisionRuleTwo;
    private DecisionRule decisionRuleThree;
    private List<Object> allRows = new ArrayList<Object>();
    private List<Object> rowsToMove = new ArrayList<Object>();
    private DMNGridData gridData;
    private BaseGrid<Expression> gridWidget;

    @Before
    public void setUp() {
        this.decisionRuleOne = new DecisionRule();
        this.decisionRuleTwo = new DecisionRule();
        this.decisionRuleThree = new DecisionRule();
        this.decisionRuleOne.setId(new Id("1"));
        this.decisionRuleTwo.setId(new Id("2"));
        this.decisionRuleThree.setId(new Id("3"));
        this.allRows.clear();
        this.allRows.add(this.decisionRuleOne);
        this.allRows.add(this.decisionRuleTwo);
        this.allRows.add(this.decisionRuleThree);
        this.rowsToMove.clear();
        this.gridData = new DMNGridData();
        this.gridWidget = new BaseGrid<Expression>(this.gridLayer, (GridData)this.gridData, this.renderer, this.sessionManager, this.sessionCommandManager, this.canvasCommandFactory, this.refreshFormPropertiesEvent, this.domainObjectSelectionEvent, this.cellEditorControls, this.translationService){};
    }

    @Test
    public void testMoveOneRowUp() {
        CommandUtils.moveRows(this.allRows, Collections.singletonList(this.decisionRuleThree), (int)0);
        Assertions.assertThat(this.allRows).containsSequence(new Object[]{this.decisionRuleThree, this.decisionRuleOne, this.decisionRuleTwo});
    }

    @Test
    public void testMoveOneRowUpMiddle() {
        CommandUtils.moveRows(this.allRows, Collections.singletonList(this.decisionRuleThree), (int)1);
        Assertions.assertThat(this.allRows).containsSequence(new Object[]{this.decisionRuleOne, this.decisionRuleThree, this.decisionRuleTwo});
    }

    @Test
    public void testMoveOneRowDown() {
        CommandUtils.moveRows(this.allRows, Collections.singletonList(this.decisionRuleOne), (int)2);
        Assertions.assertThat(this.allRows).containsSequence(new Object[]{this.decisionRuleTwo, this.decisionRuleThree, this.decisionRuleOne});
    }

    @Test
    public void testMoveOneRowDownMiddle() {
        CommandUtils.moveRows(this.allRows, Collections.singletonList(this.decisionRuleOne), (int)1);
        Assertions.assertThat(this.allRows).containsSequence(new Object[]{this.decisionRuleTwo, this.decisionRuleOne, this.decisionRuleThree});
    }

    @Test
    public void testMoveTwoRowsUp() {
        CommandUtils.moveRows(this.allRows, Arrays.asList(this.decisionRuleTwo, this.decisionRuleThree), (int)0);
        Assertions.assertThat(this.allRows).containsSequence(new Object[]{this.decisionRuleTwo, this.decisionRuleThree, this.decisionRuleOne});
    }

    @Test
    public void testMoveTwoRowsDown() {
        CommandUtils.moveRows(this.allRows, Arrays.asList(this.decisionRuleOne, this.decisionRuleTwo), (int)2);
        Assertions.assertThat(this.allRows).containsSequence(new Object[]{this.decisionRuleThree, this.decisionRuleOne, this.decisionRuleTwo});
    }

    @Test
    public void testUpdateRowNumbers() {
        this.setupUiModel(Pair.newPair((Object)new RowNumberColumn(), rowIndex -> new BaseGridCellValue((Object)(rowIndex + 1))));
        this.assertRowNumberValues();
        this.gridData.moveRowTo(0, this.gridData.getRow(9));
        CommandUtils.updateRowNumbers((GridData)this.gridData, (IntStream)IntStream.range(0, 10));
        this.assertRowNumberValues();
    }

    private void assertRowNumberValues() {
        IntStream.range(0, 10).forEach(rowIndex -> Assert.assertEquals((Object)(rowIndex + 1), (Object)this.gridData.getCell(rowIndex, 0).getValue().getValue()));
    }

    @Test
    public void testUpdateParentInformation_WithExpressionColumn() {
        this.setupUiModel(Pair.newPair((Object)new ExpressionEditorColumn((GridWidgetRegistry)this.gridLayer, (GridColumn.HeaderMetaData)new BaseHeaderMetaData("column"), 200.0, this.gridWidget), rowIndex -> {
            BaseExpressionGrid grid = (BaseExpressionGrid)Mockito.mock(BaseExpressionGrid.class);
            GridCellTuple gct = new GridCellTuple(rowIndex.intValue(), 0, (GridWidget)Mockito.mock(GridWidget.class));
            Mockito.when((Object)grid.getParentInformation()).thenReturn((Object)gct);
            return new ExpressionCellValue(Optional.of(grid));
        }));
        this.assertParentInformationValues(0);
        this.gridData.moveRowTo(0, this.gridData.getRow(9));
        CommandUtils.updateParentInformation((GridData)this.gridData);
        this.assertParentInformationValues(0);
    }

    @Test
    public void testUpdateParentInformation_WithExpressionColumnNullValues() {
        this.setupUiModelNullValues(Pair.newPair((Object)new ExpressionEditorColumn((GridWidgetRegistry)this.gridLayer, (GridColumn.HeaderMetaData)new BaseHeaderMetaData("column"), 200.0, this.gridWidget), rowIndex -> {
            BaseExpressionGrid grid = (BaseExpressionGrid)Mockito.mock(BaseExpressionGrid.class);
            GridCellTuple gct = new GridCellTuple(rowIndex.intValue(), 0, (GridWidget)Mockito.mock(GridWidget.class));
            Mockito.when((Object)grid.getParentInformation()).thenReturn((Object)gct);
            return new ExpressionCellValue(Optional.of(grid));
        }));
        try {
            CommandUtils.updateParentInformation((GridData)this.gridData);
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test
    public void testUpdateParentInformation_WithMultipleColumns() {
        this.setupUiModel(Pair.newPair((Object)new ExpressionEditorColumn((GridWidgetRegistry)this.gridLayer, (GridColumn.HeaderMetaData)new BaseHeaderMetaData("column"), 200.0, this.gridWidget), rowIndex -> {
            BaseExpressionGrid grid = (BaseExpressionGrid)Mockito.mock(BaseExpressionGrid.class);
            GridCellTuple gct = new GridCellTuple(rowIndex.intValue(), 0, (GridWidget)Mockito.mock(GridWidget.class));
            Mockito.when((Object)grid.getParentInformation()).thenReturn((Object)gct);
            return new ExpressionCellValue(Optional.of(grid));
        }), Pair.newPair((Object)new RowNumberColumn(), rowIndex -> new BaseGridCellValue((Object)(rowIndex + 1))));
        this.assertParentInformationValues(0);
        this.gridData.moveColumnTo(0, (GridColumn)this.gridData.getColumns().get(1));
        CommandUtils.updateParentInformation((GridData)this.gridData);
        this.assertParentInformationValues(1);
    }

    @Test
    public void testExtractCellValueNoValue() {
        int rowIndex = 123;
        int columnIndex = 456;
        GridData gridData = (GridData)Mockito.mock(GridData.class);
        GridWidget gridWidget = (GridWidget)Mockito.mock(GridWidget.class);
        GridCellTuple cellTuple = new GridCellTuple(123, 456, gridWidget);
        ((GridWidget)Mockito.doReturn((Object)gridData).when((Object)gridWidget)).getModel();
        ((GridData)Mockito.doReturn(null).when((Object)gridData)).getCell(123, 456);
        Assertions.assertThat((Optional)CommandUtils.extractGridCellValue((GridCellTuple)cellTuple)).isEmpty();
    }

    @Test
    public void testExtractCellValue() {
        int rowIndex = 123;
        int columnIndex = 456;
        GridCellValue gridCellValue = (GridCellValue)Mockito.mock(GridCellValue.class);
        GridCell gridCell = (GridCell)Mockito.mock(GridCell.class);
        GridData gridData = (GridData)Mockito.mock(GridData.class);
        GridWidget gridWidget = (GridWidget)Mockito.mock(GridWidget.class);
        GridCellTuple cellTuple = new GridCellTuple(123, 456, gridWidget);
        ((GridWidget)Mockito.doReturn((Object)gridData).when((Object)gridWidget)).getModel();
        ((GridData)Mockito.doReturn((Object)gridCell).when((Object)gridData)).getCell(123, 456);
        ((GridCell)Mockito.doReturn((Object)gridCellValue).when((Object)gridCell)).getValue();
        Assertions.assertThat((Optional)CommandUtils.extractGridCellValue((GridCellTuple)cellTuple)).hasValue((Object)gridCellValue);
    }

    private void assertParentInformationValues(int expressionColumnIndex) {
        IntStream.range(0, 10).forEach(rowIndex -> {
            ExpressionCellValue ecv = (ExpressionCellValue)this.gridData.getCell(rowIndex, expressionColumnIndex).getValue();
            BaseExpressionGrid grid = (BaseExpressionGrid)((Optional)ecv.getValue()).get();
            Assert.assertEquals((long)rowIndex, (long)grid.getParentInformation().getRowIndex());
            Assert.assertEquals((long)expressionColumnIndex, (long)grid.getParentInformation().getColumnIndex());
        });
    }

    @SafeVarargs
    private final void setupUiModel(Pair<GridColumn, Function<Integer, GridCellValue>> ... columns) {
        this.setupUiModelNullValues(columns);
        Arrays.asList(columns).forEach(column -> IntStream.range(0, 10).forEach(rowIndex -> this.gridData.setCellValue(rowIndex, this.gridData.getColumns().indexOf(column.getK1()), (GridCellValue)((Function)column.getK2()).apply(rowIndex))));
    }

    @SafeVarargs
    private final void setupUiModelNullValues(Pair<GridColumn, Function<Integer, GridCellValue>> ... columns) {
        Arrays.asList(columns).forEach(column -> this.gridData.appendColumn((GridColumn)column.getK1()));
        IntStream.range(0, 10).forEach(rowIndex -> this.gridData.appendRow((GridRow)new BaseGridRow()));
    }
}

