/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.components.palette;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.function.Consumer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.components.palette.DMNPaletteDefinitionBuilder;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.components.palette.CollapsedPaletteDefinitionBuilder;
import org.kie.workbench.common.stunner.core.client.components.palette.DefaultPaletteDefinition;
import org.kie.workbench.common.stunner.core.i18n.StunnerTranslationService;
import org.kie.workbench.common.stunner.core.profile.DomainProfileManager;
import org.kie.workbench.common.stunner.core.registry.impl.DefinitionsCacheRegistry;
import org.kie.workbench.common.stunner.core.util.DefinitionUtils;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class DMNPaletteDefinitionBuilderTest {
    @Mock
    private DefinitionUtils definitionUtils;
    @Mock
    private DomainProfileManager profileFunctions;
    @Mock
    private DefinitionsCacheRegistry definitionsRegistry;
    @Mock
    private StunnerTranslationService translationService;
    @Mock
    private AbstractCanvasHandler canvasHandler;
    @Mock
    private DefaultPaletteDefinition paletteDefinition;
    private DMNPaletteDefinitionBuilder tested;
    private CollapsedPaletteDefinitionBuilder collapsedPaletteBuilder;

    @Before
    public void setup() {
        this.collapsedPaletteBuilder = (CollapsedPaletteDefinitionBuilder)Mockito.spy((Object)new CollapsedPaletteDefinitionBuilder(this.definitionUtils, this.profileFunctions, this.definitionsRegistry, this.translationService));
        ((CollapsedPaletteDefinitionBuilder)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocationOnMock) throws Throwable {
                Consumer c = (Consumer)invocationOnMock.getArguments()[1];
                c.accept(DMNPaletteDefinitionBuilderTest.this.paletteDefinition);
                return null;
            }
        }).when((Object)this.collapsedPaletteBuilder)).build((AbstractCanvasHandler)ArgumentMatchers.eq((Object)this.canvasHandler), (Consumer)ArgumentMatchers.any(Consumer.class));
        this.tested = new DMNPaletteDefinitionBuilder(this.collapsedPaletteBuilder);
        this.tested.init();
    }

    @Test
    public void testFilters() {
        Assert.assertTrue((boolean)this.tested.getPaletteDefinitionBuilder().getCategoryFilter().test("DMNNodes"));
        Assert.assertFalse((boolean)this.tested.getPaletteDefinitionBuilder().getCategoryFilter().test("DMNDiagram"));
        Assert.assertFalse((boolean)this.tested.getPaletteDefinitionBuilder().getCategoryFilter().test("DMNConnectors"));
        Assert.assertFalse((boolean)this.tested.getPaletteDefinitionBuilder().getCategoryFilter().test("DMNMiscellaneousObjects"));
        Assert.assertFalse((boolean)this.tested.getPaletteDefinitionBuilder().getCategoryFilter().test("DMNDomainObjects"));
    }

    @Test
    public void testBuild() {
        Consumer paletteConsumer = (Consumer)Mockito.mock(Consumer.class);
        this.tested.build(this.canvasHandler, paletteConsumer);
        ((CollapsedPaletteDefinitionBuilder)Mockito.verify((Object)this.collapsedPaletteBuilder, (VerificationMode)Mockito.times((int)1))).build((AbstractCanvasHandler)ArgumentMatchers.eq((Object)this.canvasHandler), (Consumer)ArgumentMatchers.any(Consumer.class));
        ((Consumer)Mockito.verify((Object)paletteConsumer, (VerificationMode)Mockito.times((int)1))).accept((DefaultPaletteDefinition)ArgumentMatchers.eq((Object)this.paletteDefinition));
    }
}

