/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.docks.navigator;

import java.util.Collections;
import java.util.TreeSet;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;
import org.kie.workbench.common.dmn.client.docks.navigator.DecisionNavigatorItem;
import org.kie.workbench.common.dmn.client.docks.navigator.DecisionNavigatorItemBuilder;
import org.mockito.Mockito;
import org.uberfire.mvp.Command;

public class DecisionNavigatorItemTest {
    @Test
    public void testEqualsWhenItemsAreEqual() {
        DecisionNavigatorItem item1 = new DecisionNavigatorItemBuilder().withUUID("123").build();
        DecisionNavigatorItem item2 = new DecisionNavigatorItemBuilder().withUUID("123").build();
        Assert.assertEquals((Object)item1, (Object)item2);
    }

    @Test
    public void testEqualsWhenItemsHaveDifferentUUIDs() {
        DecisionNavigatorItem item1 = new DecisionNavigatorItemBuilder().withUUID("123").build();
        DecisionNavigatorItem item2 = new DecisionNavigatorItemBuilder().withUUID("456").build();
        Assert.assertNotEquals((Object)item1, (Object)item2);
    }

    @Test
    public void testEqualsWhenItemsHaveDifferentParentUUIDs() {
        DecisionNavigatorItem item1 = new DecisionNavigatorItemBuilder().withUUID("123").withParentUUID("456").build();
        DecisionNavigatorItem item2 = new DecisionNavigatorItemBuilder().withUUID("123").withParentUUID("789").build();
        Assert.assertNotEquals((Object)item1, (Object)item2);
    }

    @Test
    public void testEqualsWhenItemsHaveDifferentTypes() {
        DecisionNavigatorItem item1 = new DecisionNavigatorItemBuilder().withUUID("123").withType(DecisionNavigatorItem.Type.ITEM).build();
        DecisionNavigatorItem item2 = new DecisionNavigatorItemBuilder().withUUID("123").withType(DecisionNavigatorItem.Type.CONTEXT).build();
        Assert.assertNotEquals((Object)item1, (Object)item2);
    }

    @Test
    public void testEqualsWhenItemsHaveDifferentLabels() {
        DecisionNavigatorItem item1 = new DecisionNavigatorItemBuilder().withUUID("123").withLabel("Node1").build();
        DecisionNavigatorItem item2 = new DecisionNavigatorItemBuilder().withUUID("123").withLabel("Node0").build();
        Assert.assertNotEquals((Object)item1, (Object)item2);
    }

    @Test
    public void testOnClick() {
        Command command = (Command)Mockito.mock(Command.class);
        DecisionNavigatorItem item = new DecisionNavigatorItemBuilder().withUUID("uuid").withLabel("label").withType(DecisionNavigatorItem.Type.ITEM).withOnClick(command).build();
        item.onClick();
        ((Command)Mockito.verify((Object)command)).execute();
    }

    @Test
    public void testRemoveChild() {
        DecisionNavigatorItem item = new DecisionNavigatorItemBuilder().withUUID("uuid").build();
        DecisionNavigatorItem child = new DecisionNavigatorItemBuilder().withUUID("child").build();
        item.getChildren().add(child);
        item.removeChild(child);
        Assert.assertEquals(Collections.emptySet(), (Object)item.getChildren());
    }

    @Test
    public void testAddChild() {
        DecisionNavigatorItem item = new DecisionNavigatorItemBuilder().withUUID("uuid").build();
        final DecisionNavigatorItem child = new DecisionNavigatorItemBuilder().withUUID("child").build();
        TreeSet<DecisionNavigatorItem> expectedChildren = new TreeSet<DecisionNavigatorItem>(){
            {
                this.add(child);
            }
        };
        item.addChild(child);
        item.addChild(child);
        Assert.assertEquals((Object)expectedChildren, (Object)item.getChildren());
    }

    @Test
    public void testCompareToWhenObjectIsNotADecisionNavigatorItem() {
        Object object;
        DecisionNavigatorItem item = new DecisionNavigatorItemBuilder().withUUID("123").build();
        int result = item.compareTo(object = null);
        Assert.assertTrue((result > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testCompareToWhenItemAndObjectAreEqual() {
        DecisionNavigatorItem item = new DecisionNavigatorItemBuilder().withUUID("123").build();
        DecisionNavigatorItem object = new DecisionNavigatorItemBuilder().withUUID("123").build();
        int result = item.compareTo((Object)object);
        Assert.assertEquals((long)0L, (long)result);
    }

    @Test
    public void testCompareToWhenItemOrderingNameIsGreaterThanObjectOrderingName() {
        DecisionNavigatorItem object;
        DecisionNavigatorItem item = new DecisionNavigatorItemBuilder().withUUID("123").withLabel("Hat").build();
        int result = item.compareTo((Object)(object = new DecisionNavigatorItemBuilder().withUUID("456").withLabel("Red").build()));
        Assert.assertTrue((result < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testCompareToWhenItemOrderingNameIsLessThanObjectOrderingName() {
        DecisionNavigatorItem object;
        DecisionNavigatorItem item = new DecisionNavigatorItemBuilder().withUUID("123").withLabel("Red").build();
        int result = item.compareTo((Object)(object = new DecisionNavigatorItemBuilder().withUUID("456").withLabel("Hat").build()));
        Assert.assertTrue((result > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testTypeEnumWhenRetrievingByExistingItemClassName() {
        Assertions.assertThat((Comparable)DecisionNavigatorItem.Type.ofExpressionNodeClassName((String)"InputData")).isEqualTo((Object)DecisionNavigatorItem.Type.INPUT_DATA);
    }

    @Test
    public void testTypeEnumWhenRetrievingByNotExistingItemClassName() {
        Assertions.assertThat((Comparable)DecisionNavigatorItem.Type.ofExpressionNodeClassName((String)"NOT_EXISTING")).isEqualTo((Object)DecisionNavigatorItem.Type.ITEM);
    }

    @Test
    public void testTypeEnumWhenRetrievingByEmptyClassName() {
        Assertions.assertThat((Comparable)DecisionNavigatorItem.Type.ofExpressionNodeClassName((String)"")).isEqualTo((Object)DecisionNavigatorItem.Type.ITEM);
    }

    @Test
    public void testTypeEnumWhenRetrievingByNullClassName() {
        Assertions.assertThat((Comparable)DecisionNavigatorItem.Type.ofExpressionNodeClassName(null)).isEqualTo((Object)DecisionNavigatorItem.Type.ITEM);
    }
}

