/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.docks.navigator;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.model.BusinessKnowledgeModel;
import org.kie.workbench.common.dmn.api.definition.model.DMNDiagramElement;
import org.kie.workbench.common.dmn.api.definition.model.Decision;
import org.kie.workbench.common.dmn.api.definition.model.InputData;
import org.kie.workbench.common.dmn.api.definition.model.KnowledgeSource;
import org.kie.workbench.common.dmn.api.definition.model.TextAnnotation;
import org.kie.workbench.common.dmn.api.graph.DMNDiagramUtils;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.dmn.client.docks.navigator.DecisionNavigatorItem;
import org.kie.workbench.common.dmn.client.docks.navigator.DecisionNavigatorItemsProvider;
import org.kie.workbench.common.dmn.client.docks.navigator.drds.DMNDiagramTuple;
import org.kie.workbench.common.dmn.client.docks.navigator.drds.DMNDiagramsSession;
import org.kie.workbench.common.dmn.client.docks.navigator.factories.DecisionNavigatorItemFactory;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;
import org.mockito.Mock;
import org.mockito.Mockito;

@RunWith(value=GwtMockitoTestRunner.class)
public class DecisionNavigatorItemsProviderTest {
    @Mock
    private DecisionNavigatorItemFactory itemFactory;
    @Mock
    private DMNDiagramsSession dmnDiagramsSession;
    @Mock
    private DMNDiagramUtils dmnDiagramUtils;
    private DecisionNavigatorItemsProvider itemsProvider;

    @Before
    public void setup() {
        this.itemsProvider = new DecisionNavigatorItemsProvider(this.itemFactory, this.dmnDiagramsSession, this.dmnDiagramUtils);
    }

    @Test
    public void testGetItems() {
        Diagram stunnerDiagram1 = (Diagram)Mockito.mock(Diagram.class);
        Diagram stunnerDiagram2 = (Diagram)Mockito.mock(Diagram.class);
        DMNDiagramElement dmnDiagramElement1 = (DMNDiagramElement)Mockito.mock(DMNDiagramElement.class);
        DMNDiagramElement dmnDiagramElement2 = (DMNDiagramElement)Mockito.mock(DMNDiagramElement.class);
        DMNDiagramTuple dmnDiagramTuple1 = new DMNDiagramTuple(stunnerDiagram1, dmnDiagramElement1);
        DMNDiagramTuple dmnDiagramTuple2 = new DMNDiagramTuple(stunnerDiagram2, dmnDiagramElement2);
        DecisionNavigatorItem decisionNavigatorItem1 = (DecisionNavigatorItem)Mockito.mock(DecisionNavigatorItem.class);
        DecisionNavigatorItem decisionNavigatorItem2 = (DecisionNavigatorItem)Mockito.mock(DecisionNavigatorItem.class);
        DecisionNavigatorItem decisionNavigatorItem3 = (DecisionNavigatorItem)Mockito.mock(DecisionNavigatorItem.class);
        DecisionNavigatorItem decisionNavigatorItem4 = (DecisionNavigatorItem)Mockito.mock(DecisionNavigatorItem.class);
        DecisionNavigatorItem decisionNavigatorItem5 = (DecisionNavigatorItem)Mockito.mock(DecisionNavigatorItem.class);
        DecisionNavigatorItem decisionNavigatorItem6 = (DecisionNavigatorItem)Mockito.mock(DecisionNavigatorItem.class);
        DecisionNavigatorItem decisionNavigatorItem7 = (DecisionNavigatorItem)Mockito.mock(DecisionNavigatorItem.class);
        DecisionNavigatorItem decisionNavigatorItem8 = (DecisionNavigatorItem)Mockito.mock(DecisionNavigatorItem.class);
        DecisionNavigatorItem decisionNavigatorItem9 = (DecisionNavigatorItem)Mockito.mock(DecisionNavigatorItem.class);
        DecisionNavigatorItem decisionNavigatorItem10 = (DecisionNavigatorItem)Mockito.mock(DecisionNavigatorItem.class);
        List<DMNDiagramTuple> diagramTuples = Arrays.asList(dmnDiagramTuple1, dmnDiagramTuple2);
        Node node1 = this.mockNode(new Decision());
        Node node2 = this.mockNode(new InputData());
        Node node3 = this.mockNode(new TextAnnotation());
        Node node4 = this.mockNode(new BusinessKnowledgeModel());
        Node node5 = this.mockNode(new KnowledgeSource());
        Node node6 = this.mockNode(new TextAnnotation());
        Stream<Node> stunnerNodes1 = Stream.of(node1, node2, node3);
        Stream<Node> stunnerNodes2 = Stream.of(node4, node5, node6);
        Mockito.when((Object)dmnDiagramElement1.getName()).thenReturn((Object)new Name("DRD"));
        Mockito.when((Object)dmnDiagramElement2.getName()).thenReturn((Object)new Name("DRG"));
        Mockito.when((Object)this.dmnDiagramsSession.getDMNDiagrams()).thenReturn(diagramTuples);
        Mockito.when((Object)this.itemFactory.makeRoot(dmnDiagramTuple1)).thenReturn((Object)decisionNavigatorItem1);
        Mockito.when((Object)this.itemFactory.makeRoot(dmnDiagramTuple2)).thenReturn((Object)decisionNavigatorItem2);
        Mockito.when((Object)this.itemFactory.makeItem(node1)).thenReturn((Object)decisionNavigatorItem5);
        Mockito.when((Object)this.itemFactory.makeItem(node2)).thenReturn((Object)decisionNavigatorItem6);
        Mockito.when((Object)this.itemFactory.makeItem(node3)).thenReturn((Object)decisionNavigatorItem7);
        Mockito.when((Object)this.itemFactory.makeItem(node4)).thenReturn((Object)decisionNavigatorItem8);
        Mockito.when((Object)this.itemFactory.makeItem(node5)).thenReturn((Object)decisionNavigatorItem9);
        Mockito.when((Object)this.itemFactory.makeItem(node6)).thenReturn((Object)decisionNavigatorItem10);
        Mockito.when((Object)this.itemFactory.makeSeparator("DRG")).thenReturn((Object)decisionNavigatorItem3);
        Mockito.when((Object)this.itemFactory.makeSeparator("DRDs")).thenReturn((Object)decisionNavigatorItem4);
        Mockito.when((Object)this.dmnDiagramUtils.getNodeStream(stunnerDiagram1)).thenReturn(stunnerNodes1);
        Mockito.when((Object)this.dmnDiagramUtils.getNodeStream(stunnerDiagram2)).thenReturn(stunnerNodes2);
        List actualItems = this.itemsProvider.getItems();
        List<DecisionNavigatorItem> expectedItems = Arrays.asList(decisionNavigatorItem3, decisionNavigatorItem2, decisionNavigatorItem4, decisionNavigatorItem1);
        Assert.assertEquals(expectedItems, (Object)actualItems);
        ((DecisionNavigatorItem)Mockito.verify((Object)decisionNavigatorItem1)).addChild(decisionNavigatorItem5);
        ((DecisionNavigatorItem)Mockito.verify((Object)decisionNavigatorItem1)).addChild(decisionNavigatorItem6);
        ((DecisionNavigatorItem)Mockito.verify((Object)decisionNavigatorItem1)).addChild(decisionNavigatorItem7);
        ((DecisionNavigatorItem)Mockito.verify((Object)decisionNavigatorItem2)).addChild(decisionNavigatorItem8);
        ((DecisionNavigatorItem)Mockito.verify((Object)decisionNavigatorItem2)).addChild(decisionNavigatorItem9);
        ((DecisionNavigatorItem)Mockito.verify((Object)decisionNavigatorItem2)).addChild(decisionNavigatorItem10);
    }

    private Node mockNode(Object definition) {
        Node node = (Node)Mockito.mock(Node.class);
        Definition content = (Definition)Mockito.mock(Definition.class);
        Mockito.when((Object)node.getContent()).thenReturn((Object)content);
        Mockito.when((Object)content.getDefinition()).thenReturn(definition);
        return node;
    }
}

