/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.docks.navigator.drds;

import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.docks.navigator.drds.DMNDiagramsSession;
import org.kie.workbench.common.dmn.client.docks.navigator.drds.DMNGraphsProvider;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class DMNGraphsProviderTest {
    private DMNGraphsProvider provider;
    @Mock
    private DMNDiagramsSession diagramsSession;

    @Before
    public void setup() {
        this.provider = new DMNGraphsProvider(this.diagramsSession);
    }

    @Test
    public void testIsGlobalGraphSelected() {
        Mockito.when((Object)this.diagramsSession.isGlobalGraphSelected()).thenReturn((Object)true);
        boolean isGlobalGraphSelected = this.provider.isGlobalGraphSelected();
        ((DMNDiagramsSession)Mockito.verify((Object)this.diagramsSession)).isGlobalGraphSelected();
        Assert.assertTrue((boolean)isGlobalGraphSelected);
    }

    @Test
    public void testGetGraphs() {
        List graphs = (List)Mockito.mock(List.class);
        Mockito.when((Object)this.diagramsSession.getGraphs()).thenReturn((Object)graphs);
        List actual = this.provider.getGraphs();
        Assert.assertEquals((Object)graphs, (Object)actual);
    }

    @Test
    public void testGetNonGlobalGraphs() {
        List graphs = (List)Mockito.mock(List.class);
        Mockito.when((Object)this.diagramsSession.getNonGlobalGraphs()).thenReturn((Object)graphs);
        List actual = this.provider.getNonGlobalGraphs();
        Assert.assertEquals((Object)graphs, (Object)actual);
    }

    @Test
    public void testGetDiagram() {
        String diagramId = "diagram Id";
        Diagram diagram = (Diagram)Mockito.mock(Diagram.class);
        Mockito.when((Object)this.diagramsSession.getDiagram("diagram Id")).thenReturn((Object)diagram);
        Diagram actualDiagram = this.provider.getDiagram("diagram Id");
        Assert.assertEquals((Object)diagram, (Object)actualDiagram);
    }

    @Test
    public void testGetCurrentDiagramId() {
        String currentDiagramId = "currentDiagramId";
        Mockito.when((Object)this.diagramsSession.getCurrentDiagramId()).thenReturn((Object)"currentDiagramId");
        String actual = this.provider.getCurrentDiagramId();
        Assert.assertEquals((Object)"currentDiagramId", (Object)actual);
    }
}

