/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.docks.navigator.factories;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.model.DMNDiagram;
import org.kie.workbench.common.dmn.api.definition.model.DMNDiagramElement;
import org.kie.workbench.common.dmn.api.definition.model.DecisionService;
import org.kie.workbench.common.dmn.api.definition.model.Definitions;
import org.kie.workbench.common.dmn.api.property.dmn.Id;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.dmn.client.docks.navigator.DecisionNavigatorItem;
import org.kie.workbench.common.dmn.client.docks.navigator.drds.DMNDiagramSelected;
import org.kie.workbench.common.dmn.client.docks.navigator.drds.DMNDiagramTuple;
import org.kie.workbench.common.dmn.client.docks.navigator.drds.DMNDiagramsSession;
import org.kie.workbench.common.dmn.client.docks.navigator.factories.DecisionNavigatorBaseItemFactory;
import org.kie.workbench.common.dmn.client.docks.navigator.factories.DecisionNavigatorItemFactory;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.mocks.EventSourceMock;

@RunWith(value=GwtMockitoTestRunner.class)
public class DecisionNavigatorItemFactoryTest {
    @Mock
    private DecisionNavigatorBaseItemFactory baseItemFactory;
    @Mock
    private EventSourceMock<DMNDiagramSelected> selectedEvent;
    @Mock
    private DMNDiagramsSession dmnDiagramsSession;
    @Mock
    private Node<View, Edge> node;
    @Mock
    private View content;
    @Mock
    private DecisionNavigatorItem item;
    @Captor
    private ArgumentCaptor<DMNDiagramSelected> diagramSelectedArgumentCaptor;
    private DecisionNavigatorItemFactory factory;

    @Before
    public void setup() {
        this.factory = (DecisionNavigatorItemFactory)Mockito.spy((Object)new DecisionNavigatorItemFactory(this.baseItemFactory, this.selectedEvent, this.dmnDiagramsSession));
    }

    @Test
    public void testMakeRootWhenDMNDiagramElementIsDRG() {
        Diagram stunnerDiagram = (Diagram)Mockito.mock(Diagram.class);
        Graph graph = (Graph)Mockito.mock(Graph.class);
        Node node = (Node)Mockito.mock(Node.class);
        Definition definition = (Definition)Mockito.mock(Definition.class);
        String dmnDiagramId = "0000";
        String dmnModelName = "diagram-name";
        DMNDiagramElement dmnDiagramElement = new DMNDiagramElement(new Id("0000"), new Name("DRG"));
        DMNDiagramTuple diagramTuple = new DMNDiagramTuple(stunnerDiagram, dmnDiagramElement);
        Mockito.when((Object)stunnerDiagram.getGraph()).thenReturn((Object)graph);
        Mockito.when((Object)graph.nodes()).thenReturn(Collections.singletonList(node));
        Mockito.when((Object)node.getContent()).thenReturn((Object)definition);
        Mockito.when((Object)definition.getDefinition()).thenReturn((Object)new DMNDiagram());
        Mockito.when((Object)this.baseItemFactory.getLabel((Element)node)).thenReturn((Object)"diagram-name");
        DecisionNavigatorItem decisionNavigatorItem = this.factory.makeRoot(diagramTuple);
        Assert.assertEquals((Object)"diagram-name", (Object)decisionNavigatorItem.getLabel());
        Assert.assertEquals((Object)"0000", (Object)decisionNavigatorItem.getUUID());
        Assert.assertEquals((Object)DecisionNavigatorItem.Type.ROOT, (Object)decisionNavigatorItem.getType());
        Assert.assertNull((Object)decisionNavigatorItem.getParentUUID());
    }

    @Test
    public void testMakeRootWhenDMNDiagramElementIsNotDRG() {
        Diagram stunnerDiagram = (Diagram)Mockito.mock(Diagram.class);
        Graph graph = (Graph)Mockito.mock(Graph.class);
        Node node = (Node)Mockito.mock(Node.class);
        Definition definition = (Definition)Mockito.mock(Definition.class);
        String drdName = "DRD 1";
        String dmnDiagramId = "0000";
        DMNDiagramElement dmnDiagramElement = new DMNDiagramElement(new Id("0000"), new Name("DRD 1"));
        DMNDiagramTuple diagramTuple = new DMNDiagramTuple(stunnerDiagram, dmnDiagramElement);
        Mockito.when((Object)stunnerDiagram.getGraph()).thenReturn((Object)graph);
        Mockito.when((Object)graph.nodes()).thenReturn(Collections.singletonList(node));
        Mockito.when((Object)node.getContent()).thenReturn((Object)definition);
        Mockito.when((Object)definition.getDefinition()).thenReturn((Object)new DMNDiagram());
        Mockito.when((Object)this.baseItemFactory.getLabel((Element)node)).thenReturn((Object)"diagram-name");
        DecisionNavigatorItem decisionNavigatorItem = this.factory.makeRoot(diagramTuple);
        Assert.assertEquals((Object)"DRD 1", (Object)decisionNavigatorItem.getLabel());
        Assert.assertEquals((Object)"0000", (Object)decisionNavigatorItem.getUUID());
        Assert.assertEquals((Object)DecisionNavigatorItem.Type.ROOT, (Object)decisionNavigatorItem.getType());
        Assert.assertNull((Object)decisionNavigatorItem.getParentUUID());
    }

    @Test
    public void testMakeSeparator() {
        String drds = "DRDs";
        DecisionNavigatorItem drdSeparator = this.factory.makeSeparator("DRDs");
        Assert.assertEquals((Object)"DRDs", (Object)drdSeparator.getLabel());
        Assert.assertEquals((Object)DecisionNavigatorItem.Type.SEPARATOR, (Object)drdSeparator.getType());
        Assert.assertNotNull((Object)drdSeparator.getUUID());
        Assert.assertNull((Object)drdSeparator.getParentUUID());
    }

    @Test
    public void testGetOnClickAction() {
        DMNDiagramElement dmnDiagramElement = (DMNDiagramElement)Mockito.mock(DMNDiagramElement.class);
        this.factory.getOnClickAction(dmnDiagramElement).execute();
        ((EventSourceMock)Mockito.verify(this.selectedEvent)).fire((Object)((DMNDiagramSelected)this.diagramSelectedArgumentCaptor.capture()));
        Assert.assertEquals((Object)dmnDiagramElement, (Object)((DMNDiagramSelected)this.diagramSelectedArgumentCaptor.getValue()).getDiagramElement());
    }

    @Test
    public void testGetOnUpdate() {
        DMNDiagramElement dmnDiagramElement = (DMNDiagramElement)Mockito.mock(DMNDiagramElement.class);
        DecisionNavigatorItem item = (DecisionNavigatorItem)Mockito.mock(DecisionNavigatorItem.class);
        Name dmnDiagramElementName = new Name();
        String newDiagramName = "New diagram name";
        Mockito.when((Object)item.getLabel()).thenReturn((Object)"New diagram name");
        Mockito.when((Object)dmnDiagramElement.getName()).thenReturn((Object)dmnDiagramElementName);
        this.factory.getOnUpdate(dmnDiagramElement).accept(item);
        ((EventSourceMock)Mockito.verify(this.selectedEvent)).fire((Object)((DMNDiagramSelected)this.diagramSelectedArgumentCaptor.capture()));
        DMNDiagramElement actualDiagram = ((DMNDiagramSelected)this.diagramSelectedArgumentCaptor.getValue()).getDiagramElement();
        Assert.assertEquals((Object)dmnDiagramElement, (Object)actualDiagram);
        Assert.assertEquals((Object)"New diagram name", (Object)actualDiagram.getName().getValue());
    }

    @Test
    public void testGetOnRemove() {
        DMNDiagramElement drgDiagramElement = new DMNDiagramElement();
        DMNDiagramElement drd1DiagramElement = new DMNDiagramElement();
        DMNDiagramElement drd2DiagramElement = new DMNDiagramElement();
        DMNDiagramElement drgElement = (DMNDiagramElement)Mockito.mock(DMNDiagramElement.class);
        Graph drgGraph = (Graph)Mockito.mock(Graph.class);
        Diagram drgDiagram = (Diagram)Mockito.mock(Diagram.class);
        DecisionNavigatorItem item = (DecisionNavigatorItem)Mockito.mock(DecisionNavigatorItem.class);
        Node node = (Node)Mockito.mock(Node.class);
        Definition definition = (Definition)Mockito.mock(Definition.class);
        DMNDiagram dmnDiagram = (DMNDiagram)Mockito.mock(DMNDiagram.class);
        Definitions dmnDefinitions = (Definitions)Mockito.mock(Definitions.class);
        ArrayList<DMNDiagramElement> diagramElements = new ArrayList<DMNDiagramElement>(Arrays.asList(drgDiagramElement, drd1DiagramElement, drd2DiagramElement));
        List<Node> nodes = Collections.singletonList(node);
        Mockito.when((Object)this.dmnDiagramsSession.getDRGDiagramElement()).thenReturn((Object)drgElement);
        Mockito.when((Object)this.dmnDiagramsSession.getDRGDiagram()).thenReturn((Object)drgDiagram);
        Mockito.when((Object)drgDiagram.getGraph()).thenReturn((Object)drgGraph);
        Mockito.when((Object)drgGraph.nodes()).thenReturn(nodes);
        Mockito.when((Object)node.getContent()).thenReturn((Object)definition);
        Mockito.when((Object)definition.getDefinition()).thenReturn((Object)dmnDiagram);
        Mockito.when((Object)dmnDiagram.getDefinitions()).thenReturn((Object)dmnDefinitions);
        Mockito.when((Object)dmnDefinitions.getDiagramElements()).thenReturn(diagramElements);
        this.factory.getOnRemove(drd1DiagramElement).accept(item);
        ((DMNDiagramsSession)Mockito.verify((Object)this.dmnDiagramsSession)).remove(drd1DiagramElement);
        ((EventSourceMock)Mockito.verify(this.selectedEvent)).fire((Object)((DMNDiagramSelected)this.diagramSelectedArgumentCaptor.capture()));
        Assert.assertEquals((Object)drgElement, (Object)((DMNDiagramSelected)this.diagramSelectedArgumentCaptor.getValue()).getDiagramElement());
        Assert.assertEquals((long)2L, (long)diagramElements.size());
        Assert.assertTrue((boolean)diagramElements.contains(drgDiagramElement));
        Assert.assertFalse((boolean)diagramElements.contains(drd1DiagramElement));
        Assert.assertTrue((boolean)diagramElements.contains(drd2DiagramElement));
    }

    @Test
    public void testMakeItem() {
        Mockito.when((Object)this.baseItemFactory.makeItem(this.node, DecisionNavigatorItem.Type.ITEM)).thenReturn((Object)this.item);
        Assert.assertEquals((Object)this.item, (Object)this.factory.makeItem(this.node));
    }

    @Test
    public void testMakeItemWhenTypeIsDecisionService() {
        Mockito.when((Object)this.baseItemFactory.makeItem(this.node, DecisionNavigatorItem.Type.DECISION_SERVICE)).thenReturn((Object)this.item);
        Mockito.when((Object)((View)this.node.getContent())).thenReturn((Object)this.content);
        Mockito.when((Object)this.content.getDefinition()).thenReturn((Object)new DecisionService());
        Assert.assertEquals((Object)this.item, (Object)this.factory.makeItem(this.node));
    }

    @Test
    public void testMakeItemWhenTypeIsNotMapped() {
        Mockito.when((Object)this.baseItemFactory.makeItem(this.node, DecisionNavigatorItem.Type.ITEM)).thenReturn((Object)this.item);
        Mockito.when((Object)((View)this.node.getContent())).thenReturn((Object)this.content);
        Mockito.when((Object)this.content.getDefinition()).thenReturn(new Object());
        Assert.assertEquals((Object)this.item, (Object)this.factory.makeItem(this.node));
    }
}

