/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.documentation.common;

import com.ait.lienzo.client.core.shape.Viewport;
import com.ait.lienzo.shared.core.types.DataURLType;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ObjectAssert;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.HasExpression;
import org.kie.workbench.common.dmn.api.definition.model.Decision;
import org.kie.workbench.common.dmn.api.definition.model.InformationItemPrimary;
import org.kie.workbench.common.dmn.api.definition.model.InputData;
import org.kie.workbench.common.dmn.api.definition.model.LiteralExpression;
import org.kie.workbench.common.dmn.api.definition.model.TextAnnotation;
import org.kie.workbench.common.dmn.api.property.dmn.DMNExternalLink;
import org.kie.workbench.common.dmn.api.property.dmn.Description;
import org.kie.workbench.common.dmn.api.property.dmn.DocumentationLinksHolder;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.dmn.api.property.dmn.QName;
import org.kie.workbench.common.dmn.api.property.dmn.Text;
import org.kie.workbench.common.dmn.api.property.dmn.types.BuiltInType;
import org.kie.workbench.common.dmn.client.common.BoxedExpressionHelper;
import org.kie.workbench.common.dmn.client.editors.documentation.common.DMNDocumentationDRD;
import org.kie.workbench.common.dmn.client.editors.documentation.common.DMNDocumentationDRDsFactory;
import org.kie.workbench.common.dmn.client.editors.expressions.ExpressionContainerGrid;
import org.kie.workbench.common.dmn.client.editors.expressions.ExpressionEditorView;
import org.kie.workbench.common.dmn.client.editors.expressions.ExpressionEditorViewImpl;
import org.kie.workbench.common.dmn.client.editors.expressions.types.literal.LiteralExpressionUIModelMapper;
import org.kie.workbench.common.dmn.client.session.DMNSession;
import org.kie.workbench.common.dmn.client.widgets.grid.BaseExpressionGrid;
import org.kie.workbench.common.dmn.client.widgets.grid.model.DMNGridData;
import org.kie.workbench.common.stunner.core.client.api.SessionManager;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.graph.impl.NodeImpl;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.ext.wires.core.grids.client.model.GridData;

@RunWith(value=GwtMockitoTestRunner.class)
public class DMNDocumentationDRDsFactoryTest {
    @Mock
    private SessionManager sessionManager;
    @Mock
    private BoxedExpressionHelper expressionHelper;
    @Mock
    private Diagram diagram;
    @Mock
    private DMNSession dmnSession;
    @Mock
    private ExpressionEditorView.Presenter expressionEditor;
    @Mock
    private ExpressionEditorViewImpl editorView;
    @Mock
    private ExpressionContainerGrid expressionContainerGrid;
    @Mock
    private BaseExpressionGrid<LiteralExpression, DMNGridData, LiteralExpressionUIModelMapper> expressionGrid;
    @Mock
    private GridData gridData;
    @Mock
    private Graph graph;
    @Mock
    private Viewport viewport;
    private DMNDocumentationDRDsFactory factory;

    @Before
    public void setup() {
        Mockito.when((Object)this.sessionManager.getCurrentSession()).thenReturn((Object)this.dmnSession);
        Mockito.when((Object)this.dmnSession.getExpressionEditor()).thenReturn((Object)this.expressionEditor);
        Mockito.when((Object)this.expressionEditor.getView()).thenReturn((Object)this.editorView);
        Mockito.when((Object)this.editorView.getExpressionContainerGrid()).thenReturn((Object)this.expressionContainerGrid);
        Mockito.when((Object)this.expressionContainerGrid.getViewport()).thenReturn((Object)this.viewport);
        Mockito.when((Object)this.expressionContainerGrid.getBaseExpressionGrid()).thenReturn(Optional.of(this.expressionGrid));
        Mockito.when((Object)this.expressionGrid.getModel()).thenReturn((Object)this.gridData);
        Mockito.when((Object)this.diagram.getGraph()).thenReturn((Object)this.graph);
        this.factory = (DMNDocumentationDRDsFactory)Mockito.spy((Object)new DMNDocumentationDRDsFactory(this.sessionManager, this.expressionHelper));
    }

    @Test
    public void testCreate() {
        String nodeUUID1 = "1111-1111-1111-1111";
        String nodeUUID2 = "2222-2222-2222-2222";
        NodeImpl node1 = new NodeImpl("1111-1111-1111-1111");
        NodeImpl node2 = new NodeImpl("2222-2222-2222-2222");
        View view1 = (View)Mockito.mock(View.class);
        View view2 = (View)Mockito.mock(View.class);
        HasExpression hasExpression1 = (HasExpression)Mockito.mock(HasExpression.class);
        List<Node> nodes = Arrays.asList(node1, node2);
        Decision drgElement1 = new Decision();
        InputData drgElement2 = new InputData();
        String name1 = "Decision-1";
        String name2 = "Input-data-2";
        String description1 = "Description...";
        InformationItemPrimary variable1 = new InformationItemPrimary();
        QName typeRef1 = BuiltInType.BOOLEAN.asQName();
        String image1 = "<image1>";
        DMNExternalLink externalLink = new DMNExternalLink();
        DocumentationLinksHolder linksHolder = new DocumentationLinksHolder();
        linksHolder.getValue().addLink(externalLink);
        drgElement2.setLinksHolder(linksHolder);
        node1.setContent((Object)view1);
        node2.setContent((Object)view2);
        Mockito.when((Object)view1.getDefinition()).thenReturn((Object)drgElement1);
        Mockito.when((Object)view2.getDefinition()).thenReturn((Object)drgElement2);
        Mockito.when((Object)this.expressionHelper.getOptionalHasExpression((Node)node1)).thenReturn(Optional.ofNullable(hasExpression1));
        Mockito.when((Object)this.expressionHelper.getOptionalHasExpression((Node)node2)).thenReturn(Optional.empty());
        Mockito.when((Object)this.expressionContainerGrid.getNodeUUID()).thenReturn(Optional.of("2222-2222-2222-2222"));
        Mockito.when((Object)this.graph.nodes()).thenReturn(nodes);
        ((DMNDocumentationDRDsFactory)Mockito.doReturn((Object)"<image1>").when((Object)this.factory)).getNodeImage(this.diagram, (Node)node1);
        ((DMNDocumentationDRDsFactory)Mockito.doNothing().when((Object)this.factory)).setExpressionContainerGrid((Diagram)ArgumentMatchers.any(), (String)ArgumentMatchers.any());
        variable1.setTypeRef(typeRef1);
        drgElement1.setVariable(variable1);
        drgElement1.setDescription(new Description("Description..."));
        drgElement1.setName(new Name("Decision-1"));
        drgElement2.setName(new Name("Input-data-2"));
        List drds = this.factory.create(this.diagram);
        DMNDocumentationDRD documentationDRD1 = (DMNDocumentationDRD)drds.get(0);
        DMNDocumentationDRD documentationDRD2 = (DMNDocumentationDRD)drds.get(1);
        Assert.assertEquals((long)2L, (long)drds.size());
        Assert.assertEquals((Object)"Decision-1", (Object)documentationDRD1.getDrdName());
        Assert.assertEquals((Object)BuiltInType.BOOLEAN.getName(), (Object)documentationDRD1.getDrdType());
        Assert.assertEquals((Object)"Description...", (Object)documentationDRD1.getDrdDescription());
        Assert.assertEquals((Object)"<image1>", (Object)documentationDRD1.getDrdBoxedExpressionImage());
        Assert.assertEquals((Object)"", (Object)documentationDRD2.getDrdDescription());
        Assert.assertEquals((Object)BuiltInType.UNDEFINED.getName(), (Object)documentationDRD2.getDrdType());
        Assert.assertEquals((Object)"Input-data-2", (Object)documentationDRD2.getDrdName());
        Assert.assertEquals((Object)"", (Object)documentationDRD2.getDrdBoxedExpressionImage());
        ((DMNDocumentationDRDsFactory)Mockito.verify((Object)this.factory)).setExpressionContainerGrid(this.diagram, "2222-2222-2222-2222");
    }

    @Test
    public void testCreateTextAnnotation() {
        String nodeUUID1 = "1111-1111-1111-1111";
        NodeImpl node1 = new NodeImpl("1111-1111-1111-1111");
        View view1 = (View)Mockito.mock(View.class);
        List<Node> nodes = Arrays.asList(node1);
        TextAnnotation drgElement1 = new TextAnnotation();
        String name1 = "Text Annotation";
        String description1 = "Description...";
        node1.setContent((Object)view1);
        Mockito.when((Object)view1.getDefinition()).thenReturn((Object)drgElement1);
        Mockito.when((Object)this.graph.nodes()).thenReturn(nodes);
        drgElement1.setDescription(new Description("Description..."));
        drgElement1.setText(new Text("Text Annotation"));
        List drds = this.factory.create(this.diagram);
        ((ObjectAssert)((ListAssert)Assertions.assertThat((List)drds).hasSize(1)).first()).satisfies(ta -> {
            Assertions.assertThat((Object)ta).extracting("drdName").isEqualTo((Object)"Text Annotation");
            Assertions.assertThat((Object)ta).extracting("drdDescription").isEqualTo((Object)"Description...");
        });
    }

    @Test
    public void testGetNodeImage() {
        String uuid = "0000-1111-2222-3333";
        NodeImpl node = new NodeImpl("0000-1111-2222-3333");
        HasExpression hasExpression = (HasExpression)Mockito.mock(HasExpression.class);
        String expectedImage = "<image>";
        double wide = 800.0;
        double high = 600.0;
        ((DMNDocumentationDRDsFactory)Mockito.doNothing().when((Object)this.factory)).setExpressionContainerGrid((Diagram)ArgumentMatchers.any(), (String)ArgumentMatchers.any());
        Mockito.when((Object)this.expressionHelper.getOptionalHasExpression((Node)node)).thenReturn(Optional.of(hasExpression));
        Mockito.when((Object)this.expressionContainerGrid.getWidth()).thenReturn((Object)800.0);
        Mockito.when((Object)this.expressionContainerGrid.getHeight()).thenReturn((Object)600.0);
        Mockito.when((Object)this.viewport.toDataURL(DataURLType.PNG)).thenReturn((Object)"<image>");
        String actualImage = this.factory.getNodeImage(this.diagram, (Node)node);
        ((Viewport)Mockito.verify((Object)this.viewport)).setPixelSize(810, 610);
        ((DMNDocumentationDRDsFactory)Mockito.verify((Object)this.factory)).setExpressionContainerGrid(this.diagram, "0000-1111-2222-3333");
        Assert.assertEquals((Object)"<image>", (Object)actualImage);
    }

    @Test
    public void testSetExpressionContainerGrid() {
        String uuid = "0000-1111-2222-3333";
        String name = "Decision-1";
        NodeImpl node = new NodeImpl("0000-1111-2222-3333");
        Decision drgElement = new Decision();
        HasExpression hasExpression = (HasExpression)Mockito.mock(HasExpression.class);
        View view = (View)Mockito.mock(View.class);
        node.setContent((Object)view);
        drgElement.setName(new Name("Decision-1"));
        Mockito.when((Object)this.graph.nodes()).thenReturn(Collections.singletonList(node));
        Mockito.when((Object)view.getDefinition()).thenReturn((Object)drgElement);
        Mockito.when((Object)this.expressionHelper.getHasExpression((Node)node)).thenReturn((Object)hasExpression);
        this.factory.setExpressionContainerGrid(this.diagram, "0000-1111-2222-3333");
        ((ExpressionContainerGrid)Mockito.verify((Object)this.expressionContainerGrid)).setExpression("0000-1111-2222-3333", hasExpression, Optional.of(drgElement), false);
        ((DMNDocumentationDRDsFactory)Mockito.verify((Object)this.factory)).clearSelections(this.expressionContainerGrid);
    }

    @Test
    public void testClearSelections() {
        this.factory.clearSelections(this.expressionContainerGrid);
        ((GridData)Mockito.verify((Object)this.expressionGrid.getModel())).clearSelections();
        ((BaseExpressionGrid)Mockito.verify(this.expressionGrid)).draw();
    }

    @Test
    public void testGetNodeImageWhenNodeDoesNotHaveExpression() {
        String uuid = "0000-1111-2222-3333";
        NodeImpl node = new NodeImpl("0000-1111-2222-3333");
        Mockito.when((Object)this.expressionHelper.getOptionalHasExpression((Node)node)).thenReturn(Optional.empty());
        String image = this.factory.getNodeImage(this.diagram, (Node)node);
        Assert.assertEquals((Object)"", (Object)image);
    }
}

