/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.documentation.common;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.jboss.errai.security.shared.api.identity.User;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.model.DRGElement;
import org.kie.workbench.common.dmn.api.definition.model.Definitions;
import org.kie.workbench.common.dmn.api.definition.model.ItemDefinition;
import org.kie.workbench.common.dmn.api.definition.model.UnaryTests;
import org.kie.workbench.common.dmn.api.property.dmn.Description;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.dmn.api.property.dmn.QName;
import org.kie.workbench.common.dmn.api.property.dmn.Text;
import org.kie.workbench.common.dmn.client.editors.documentation.common.DMNDocumentation;
import org.kie.workbench.common.dmn.client.editors.documentation.common.DMNDocumentationDRDsFactory;
import org.kie.workbench.common.dmn.client.editors.documentation.common.DMNDocumentationDataType;
import org.kie.workbench.common.dmn.client.editors.documentation.common.DMNDocumentationFactory;
import org.kie.workbench.common.dmn.client.editors.documentation.common.DMNDocumentationI18n;
import org.kie.workbench.common.dmn.client.graph.DMNGraphUtils;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.util.CanvasFileExport;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.views.pfly.widgets.Moment;
import org.uberfire.rpc.SessionInfo;

@RunWith(value=GwtMockitoTestRunner.class)
public class DMNDocumentationFactoryTest {
    @Mock
    private CanvasFileExport canvasFileExport;
    @Mock
    private TranslationService translationService;
    @Mock
    private DMNDocumentationDRDsFactory drdsFactory;
    @Mock
    private SessionInfo sessionInfo;
    @Mock
    private DMNGraphUtils graphUtils;
    @Mock
    private Diagram diagram;
    @Mock
    private Metadata metadata;
    @Mock
    private Definitions definitions;
    @Mock
    private Path path;
    @Mock
    private User user;
    @Mock
    private Moment moment;
    @Mock
    private DMNDocumentationI18n i18n;
    private DMNDocumentationFactory documentationFactory;

    @Before
    public void setup() {
        this.documentationFactory = (DMNDocumentationFactory)Mockito.spy((Object)new DMNDocumentationFactory(this.canvasFileExport, this.translationService, this.drdsFactory, this.sessionInfo, this.graphUtils));
        Mockito.when((Object)this.translationService.format("DMNDocumentationFactory.Constraints", new Object[0])).thenReturn((Object)"Constraints:");
        Mockito.when((Object)this.translationService.format("DMNDocumentationFactory.ListYes", new Object[0])).thenReturn((Object)"List: Yes");
        Mockito.when((Object)this.translationService.format("DMNDocumentationFactory.Structure", new Object[0])).thenReturn((Object)"Structure");
    }

    @Test
    public void testCreate() {
        String diagramName = "Diagram name";
        String diagramDescription = "Diagram description";
        String image = "<image>";
        String admin = "admin";
        String currentDate = "2 January 1992";
        String namespace = "://namespace";
        String expectedDroolsLogo = "droolsLogo";
        String expectedSupportedByRedHatLogo = "supportedByRedHatLogo";
        List<DRGElement> drgElements = Collections.singletonList((DRGElement)Mockito.mock(DRGElement.class));
        ItemDefinition uuid = this.makeItemDefinition("tUUID", "String", new ItemDefinition[0]);
        ItemDefinition id = this.makeItemDefinition("id", "tUUID", new ItemDefinition[0]);
        ItemDefinition name = this.makeItemDefinition("name", "String", new ItemDefinition[0]);
        ItemDefinition person = this.makeItemDefinition("tPerson", null, id, name);
        List<ItemDefinition> itemDefinitions = Arrays.asList(uuid, person);
        UnaryTests unaryTests = new UnaryTests();
        unaryTests.setText(new Text("[1, 2, 3]"));
        id.setAllowedValues(unaryTests);
        id.setIsCollection(Boolean.valueOf(true));
        ((DMNDocumentationFactory)Mockito.doReturn((Object)"<image>").when((Object)this.documentationFactory)).getDiagramImage();
        ((DMNDocumentationFactory)Mockito.doReturn((Object)this.i18n).when((Object)this.documentationFactory)).getDocumentationI18n();
        ((DMNDocumentationFactory)Mockito.doReturn((Object)this.moment).when((Object)this.documentationFactory)).moment();
        Mockito.when((Object)this.definitions.getNamespace()).thenReturn((Object)new Text("://namespace"));
        Mockito.when((Object)this.graphUtils.getDefinitions(this.diagram)).thenReturn((Object)this.definitions);
        Mockito.when((Object)this.definitions.getName()).thenReturn((Object)new Name("Diagram name"));
        Mockito.when((Object)this.definitions.getDescription()).thenReturn((Object)new Description("Diagram description"));
        Mockito.when((Object)this.graphUtils.getDRGElements(this.diagram)).thenReturn(drgElements);
        Mockito.when((Object)this.definitions.getItemDefinition()).thenReturn(itemDefinitions);
        Mockito.when((Object)this.sessionInfo.getIdentity()).thenReturn((Object)this.user);
        Mockito.when((Object)this.user.getIdentifier()).thenReturn((Object)"admin");
        Mockito.when((Object)this.moment.format("D MMMM YYYY")).thenReturn((Object)"2 January 1992");
        DMNDocumentation documentation = this.documentationFactory.create(this.diagram);
        Assert.assertEquals((Object)"://namespace", (Object)documentation.getNamespace());
        Assert.assertEquals((Object)"Diagram name", (Object)documentation.getDiagramName());
        Assert.assertEquals((Object)"Diagram description", (Object)documentation.getDiagramDescription());
        Assert.assertEquals((Object)"<image>", (Object)documentation.getDiagramImage());
        Assert.assertEquals((Object)"admin", (Object)documentation.getCurrentUser());
        Assert.assertEquals((Object)"2 January 1992", (Object)documentation.getCurrentDate());
        Assert.assertEquals((Object)"droolsLogo", (Object)documentation.getDroolsLogoURI());
        Assert.assertEquals((Object)"supportedByRedHatLogo", (Object)documentation.getSupportedByRedHatLogoURI());
        Assert.assertEquals((Object)this.i18n, (Object)documentation.getI18n());
        Assert.assertNotNull((Object)documentation.getModuleName());
        Assert.assertNotNull((Object)documentation.getDataTypes());
        Assert.assertTrue((boolean)documentation.hasGraphNodes());
        List dataTypes = documentation.getDataTypesList();
        Assert.assertEquals((long)4L, (long)dataTypes.size());
        Assert.assertEquals((Object)"", (Object)((DMNDocumentationDataType)dataTypes.get(0)).getConstraint());
        Assert.assertEquals((Object)"tUUID", (Object)((DMNDocumentationDataType)dataTypes.get(0)).getName());
        Assert.assertEquals((Object)"String", (Object)((DMNDocumentationDataType)dataTypes.get(0)).getType());
        Assert.assertEquals((Object)"", (Object)((DMNDocumentationDataType)dataTypes.get(0)).getListLabel());
        Assert.assertEquals((long)0L, (long)((DMNDocumentationDataType)dataTypes.get(0)).getLevel());
        Assert.assertTrue((boolean)((DMNDocumentationDataType)dataTypes.get(0)).isTopLevel());
        Assert.assertEquals((Object)"", (Object)((DMNDocumentationDataType)dataTypes.get(1)).getConstraint());
        Assert.assertEquals((Object)"tPerson", (Object)((DMNDocumentationDataType)dataTypes.get(1)).getName());
        Assert.assertEquals((Object)"Structure", (Object)((DMNDocumentationDataType)dataTypes.get(1)).getType());
        Assert.assertEquals((Object)"", (Object)((DMNDocumentationDataType)dataTypes.get(1)).getListLabel());
        Assert.assertEquals((long)0L, (long)((DMNDocumentationDataType)dataTypes.get(1)).getLevel());
        Assert.assertTrue((boolean)((DMNDocumentationDataType)dataTypes.get(1)).isTopLevel());
        Assert.assertEquals((Object)"Constraints: [1, 2, 3]", (Object)((DMNDocumentationDataType)dataTypes.get(2)).getConstraint());
        Assert.assertEquals((Object)"id", (Object)((DMNDocumentationDataType)dataTypes.get(2)).getName());
        Assert.assertEquals((Object)"tUUID", (Object)((DMNDocumentationDataType)dataTypes.get(2)).getType());
        Assert.assertEquals((Object)"List: Yes", (Object)((DMNDocumentationDataType)dataTypes.get(2)).getListLabel());
        Assert.assertEquals((long)1L, (long)((DMNDocumentationDataType)dataTypes.get(2)).getLevel());
        Assert.assertFalse((boolean)((DMNDocumentationDataType)dataTypes.get(2)).isTopLevel());
        Assert.assertEquals((Object)"", (Object)((DMNDocumentationDataType)dataTypes.get(3)).getConstraint());
        Assert.assertEquals((Object)"name", (Object)((DMNDocumentationDataType)dataTypes.get(3)).getName());
        Assert.assertEquals((Object)"String", (Object)((DMNDocumentationDataType)dataTypes.get(3)).getType());
        Assert.assertEquals((Object)"", (Object)((DMNDocumentationDataType)dataTypes.get(3)).getListLabel());
        Assert.assertEquals((long)1L, (long)((DMNDocumentationDataType)dataTypes.get(3)).getLevel());
        Assert.assertFalse((boolean)((DMNDocumentationDataType)dataTypes.get(3)).isTopLevel());
    }

    @Test
    public void testGetDiagramImageWhenCanvasHandlerIsPresent() {
        AbstractCanvasHandler canvasHandler = (AbstractCanvasHandler)Mockito.mock(AbstractCanvasHandler.class);
        String image = "<image>";
        Mockito.when((Object)this.graphUtils.getCanvasHandler()).thenReturn((Object)canvasHandler);
        Mockito.when((Object)this.canvasFileExport.exportToPng(canvasHandler)).thenReturn((Object)"<image>");
        Assert.assertEquals((Object)"<image>", (Object)this.documentationFactory.getDiagramImage());
    }

    @Test
    public void testGetDiagramImageWhenCanvasHandlerIsNotPresent() {
        Mockito.when((Object)this.graphUtils.getCurrentSession()).thenReturn(Optional.empty());
        Assert.assertEquals((Object)"", (Object)this.documentationFactory.getDiagramImage());
    }

    @Test
    public void testGetHasGraphNodesWhenIsReturnsFalse() {
        Mockito.when((Object)this.graphUtils.getDRGElements(this.diagram)).thenReturn(Collections.emptyList());
        Assert.assertFalse((boolean)this.documentationFactory.hasGraphNodes(this.diagram));
    }

    @Test
    public void testGetHasGraphNodesWhenIsReturnsTrue() {
        Mockito.when((Object)this.graphUtils.getDRGElements(this.diagram)).thenReturn(Collections.singletonList((DRGElement)Mockito.mock(DRGElement.class)));
        Assert.assertTrue((boolean)this.documentationFactory.hasGraphNodes(this.diagram));
    }

    private ItemDefinition makeItemDefinition(String name, String type, ItemDefinition ... itemDefinitions) {
        ItemDefinition itemDefinition = (ItemDefinition)Mockito.spy((Object)new ItemDefinition());
        itemDefinition.setName(new Name(name));
        if (type != null) {
            itemDefinition.setTypeRef(new QName("://namespace", type));
        }
        itemDefinition.getItemComponent().addAll(Arrays.asList(itemDefinitions));
        return itemDefinition;
    }
}

