/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.documentation.common;

import com.google.gwtmockito.GwtMockitoTestRunner;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.editors.documentation.common.DMNDocumentation;
import org.kie.workbench.common.dmn.client.editors.documentation.common.DMNDocumentationFactory;
import org.kie.workbench.common.dmn.client.editors.documentation.common.DMNDocumentationServiceImpl;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.documentation.model.DocumentationOutput;
import org.kie.workbench.common.stunner.core.documentation.model.HTMLDocumentationTemplate;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.ext.editor.commons.client.template.mustache.ClientMustacheTemplateRenderer;

@RunWith(value=GwtMockitoTestRunner.class)
public class DMNDocumentationServiceImplTest {
    @Mock
    private ClientMustacheTemplateRenderer mustacheTemplateRenderer;
    @Mock
    private DMNDocumentationFactory dmnDocumentationFactory;
    @Mock
    private Diagram diagram;
    private DMNDocumentationServiceImpl service;

    @Before
    public void setup() {
        this.service = (DMNDocumentationServiceImpl)Mockito.spy((Object)new DMNDocumentationServiceImpl(this.mustacheTemplateRenderer, this.dmnDocumentationFactory));
    }

    @Test
    public void testProcessDocumentation() {
        DMNDocumentation expectedDocumentation = (DMNDocumentation)Mockito.mock(DMNDocumentation.class);
        Mockito.when((Object)this.dmnDocumentationFactory.create(this.diagram)).thenReturn((Object)expectedDocumentation);
        DMNDocumentation actualDocumentation = this.service.processDocumentation(this.diagram);
        Assert.assertEquals((Object)expectedDocumentation, (Object)actualDocumentation);
    }

    @Test
    public void testGetDocumentationTemplate() {
        HTMLDocumentationTemplate documentationTemplate = this.service.getDocumentationTemplate();
        String expectedTemplate = "documentationTemplate";
        String actualTemplate = documentationTemplate.getTemplate();
        Assert.assertEquals((Object)"documentationTemplate", (Object)actualTemplate);
    }

    @Test
    public void testBuildDocumentation() {
        HTMLDocumentationTemplate template = (HTMLDocumentationTemplate)Mockito.mock(HTMLDocumentationTemplate.class);
        DMNDocumentation documentation = (DMNDocumentation)Mockito.mock(DMNDocumentation.class);
        String documentationTemplate = "documentationTemplate";
        String rendered = "<template rendered='true' />";
        DocumentationOutput expectedOutput = new DocumentationOutput("<template rendered='true' />");
        Mockito.when((Object)template.getTemplate()).thenReturn((Object)"documentationTemplate");
        Mockito.when((Object)this.mustacheTemplateRenderer.render("documentationTemplate", (Object)documentation)).thenReturn((Object)"<template rendered='true' />");
        DocumentationOutput actualOutput = this.service.buildDocumentation(template, documentation);
        Assert.assertEquals((Object)expectedOutput.getValue(), (Object)actualOutput.getValue());
    }

    @Test
    public void testGenerateWhenDiagramIsPresent() {
        HTMLDocumentationTemplate template = (HTMLDocumentationTemplate)Mockito.mock(HTMLDocumentationTemplate.class);
        DMNDocumentation documentation = (DMNDocumentation)Mockito.mock(DMNDocumentation.class);
        DocumentationOutput expectedOutput = (DocumentationOutput)Mockito.mock(DocumentationOutput.class);
        ((DMNDocumentationServiceImpl)Mockito.doReturn((Object)template).when((Object)this.service)).getDocumentationTemplate();
        ((DMNDocumentationServiceImpl)Mockito.doReturn((Object)documentation).when((Object)this.service)).processDocumentation(this.diagram);
        ((DMNDocumentationServiceImpl)Mockito.doReturn((Object)expectedOutput).when((Object)this.service)).buildDocumentation(template, documentation);
        DocumentationOutput actualOutput = this.service.generate(this.diagram);
        Assert.assertEquals((Object)expectedOutput, (Object)actualOutput);
    }

    @Test
    public void testGenerateWhenDiagramIsNotPresent() {
        DocumentationOutput expectedOutput = DocumentationOutput.EMPTY;
        DocumentationOutput actualOutput = this.service.generate(null);
        Assert.assertEquals((Object)expectedOutput, (Object)actualOutput);
    }
}

